**********************************************************************
*   MASTER MECHANISM V.3.0 ROUTINE NAME        -       CKINPT        *
*                                                                    *
*            -- OLD COMMENT - NEED UPDATING --                       * 
*            -- OLD COMMENT - NEED UPDATING --                       * 
*            -- OLD COMMENT - NEED UPDATING --                       * 
*                                                                    *
*                                                                    *
*   PURPOSE         - Check for misordered groups in parentheses     *
*                     next to each other.                            *
*                                                                    *
*   USAGE           - CALL CKINPT(CHEM,LOCAT)                        *
*                                                                    *
*   ARGUMENTS  CHEM - Input/Output chemical species                  *
*              LOCAL- Pointer of first string ")(" in CHEM           *
*                                                                    *
*   CKINPT checks the input - CHEM - for misordered groups in paren- *
*   theses next to each other. For group PRIority see include file,  *
*   where the Priority invers TOP-DOWN.                              *
*                                                                    *
*   Do ensure full permutation of:  C(X1)(X2)(X3)                    *
*                                                                    *
*                       PTR21  PTR23   LNG3                          *
*                         |      |____/___                           *
*                C(..X1..)(..X2..)(..X3..)                           *
*                 |      |        |      |                           *
*               PTR11  PTR12    PTR32  PTR33                         *
*                                                                    *
*   INCLUDE     general.h includes variable PRI.                     *
*                                                                    *
*   LOCAL VARIABLES...                                               *
*                                                                    *
*   TCHEM       temporary storage for CHEM                           *
*   PTRii       are pointers to locate the position of the parenthe- *
*               ses in CHEM in order to exchange quickly groups if   *
*               PRIority demands it.                                 *
*   GRPi        are the groups with parentheses.                     *
*   GRP(i)      are the three first characters of a group            *
*   TRI, SWITCH are flags to indicate tripple-() and exchange status *
*   CFLG        cntrol flag to indicate if a third () is misordered  *
*   I, J, L, K  DO-LOOP indexes                                      *
*                                                                    *
**********************************************************************
      SUBROUTINE ckinpt(chem,locat)
      IMPLICIT NONE
      INCLUDE 'general.h'
      INCLUDE 'organic.h'

* input/output:
      CHARACTER(LEN=lfo),INTENT(inout) :: chem
      INTEGER,INTENT(inout)         :: locat

* internal:
      CHARACTER(LEN=lfo) tchem
      CHARACTER(LEN=lgr) grp1, grp2, grp3
      CHARACTER*3     grp(3)
      CHARACTER*1     tri, switch
      INTEGER         ptr11, ptr12, ptr21
      INTEGER         ptr23, ptr32, ptr33
      INTEGER         cflg,i,j,k,l,p,diff,lng3

* initialise
      grp1=' '
      grp2=' '
      grp3=' '
      ptr11=0
      ptr23=0
      ptr33=0
      lng3=0

* set the pointers for the first pair of unequal parentheses:
      ptr12 = locat
      ptr21 = locat + 1

* ptr11 is location of '(' match for ')' of the first pair ')(':
      l = locat - 1
      p = 0
      DO i=l,2,-1
        IF (chem(i:i).EQ.')') p = p + 1
        IF (chem(i:i).EQ.'(') p = p - 1
        IF (p.LT.0) THEN
          ptr11 = i
          GO TO 13
        ENDIF
      ENDDO

* take and save what's sure!
13    tchem = chem(1:(ptr11 - 1))

* ptr23 is location of ')' match for '(' of the first pair ')(':
      p = 0
      j = ptr12 + 2

      DO i=j,lfo
	IF (chem(i:i).EQ.'(') p = p + 1
        IF (chem(i:i).EQ.')') p = p - 1 
        IF (p.LT.0) THEN
          ptr23 = i
          GO TO 17
	ENDIF
      ENDDO

* look if there are TRIpple groups in parentheses instead
* of a pair PTR32 is *'(' and PTR33 is *')' of the third
* group in parentheses:
17    ptr32 = ptr23 + 1
      tri = '0'
      IF (chem(ptr32:ptr32).EQ.'(') THEN
        tri = '1'
        p = 0
        k = ptr32 + 1
        DO i=k,lfo
          IF(chem(i:i).EQ.')') p = p - 1 
          IF(chem(i:i).EQ.'(') p = p + 1
          IF(p.LT.0) THEN
            ptr33 = i
            GO TO 25
	  ENDIF
        ENDDO
25      lng3   = ptr33 - ptr23
        grp3   = chem(ptr32:ptr33)
        grp(3) = chem(k:k+2)
      ENDIF

* define all GRP(i) and GRPi
      i = ptr11 + 1
      grp1   = chem(ptr11:ptr12)
      grp(1) = chem(i:i+2)
      grp2   = chem(ptr21:ptr23)
      grp(2) = chem(j:j+2)
* fluor is a special case, since it is only one character long:
      DO i=1,3
        IF (grp(i)(1:1).EQ.'F') grp(i) = 'F  '
      ENDDO

* define if third  group has higher PRIority than the two others:
      cflg = 0
      DO i=1,2
        IF (INDEX(pri,grp(i)).LT.INDEX(pri,grp(3))) cflg=cflg+1
      ENDDO

* switch contents of () if in wrong priority - if the first
* two groups are wrongly placed then SWITCH:
      switch = '0'
      IF (INDEX(pri,grp(1)).LT.INDEX(pri,grp(2))) THEN
        switch = '1'
        ptr21 = ptr11 + (ptr23 - ptr12)
        tchem(ptr11:lfo) = grp2
        tchem(ptr21:lfo) = grp1
        tchem(ptr32:lfo) = chem(ptr32:lfo)
        chem = tchem
        diff = INDEX(grp2,' ') - INDEX(grp1,' ')
        IF (diff.NE.0) ptr12 = ptr12 + diff
      ENDIF

      locat = ptr23 + 1
* if there exists a  third group(TRI='1') and wrong placed
* then switch again:
      tchem = ' '
      IF((tri.EQ.'1').AND.(cflg.NE.0)) THEN
        IF(cflg.EQ.1) THEN
          IF(switch.EQ.'1') THEN
            tchem = chem(1:ptr12)
            tchem(ptr21:lfo) = grp3
            tchem(ptr21+lng3:lfo) = grp1
          ELSE
            tchem = chem(1:ptr12)
            tchem(ptr21:lfo) = grp3
            tchem(ptr21+lng3:lfo) = grp2
          ENDIF
        ELSE
          tchem = chem(1:(ptr11 - 1))
          tchem(ptr11:lfo) = grp3
          tchem((ptr11 + lng3):lfo) = chem(ptr11:ptr23)
        ENDIF
        locat = ptr33 + 1
        tchem(locat:lfo) = chem(locat:lfo)
        chem = tchem
      ENDIF

      RETURN
      END


