      SUBROUTINE calc_difvol(chem,name,vdmol)
      INCLUDE 'general.h'

      CHARACTER(LEN=lfo),INTENT(in) :: chem
      CHARACTER(LEN=lco),INTENT(in) :: name

      INTEGER         :: nc,ic,in,io,ir,is,ifl,ibr,icl
      REAL            :: vdmol ! diffusion volumn of molecule

! atomic diffusion volumes for C,H,O,N units=(none): 
! Reference: Reid, Prausnitzs & Poling, The properties of liquids 
! and gases, McGraw-Hill inc., New York (1987)
      REAL,PARAMETER :: vdatom(4) =[15.9,2.31,6.11,4.54]

!------------------------------------------------------------------
! calculate vdmol for chem
      nc = INDEX(chem,' ') - 1
      CALL number(chem,nc,ic,ih,in,io,ir,is,ifl,ibr,icl)

      vdmol = 0.0
      vdmol = ic*vdatom(1) + ih*vdatom(2) + io*vdatom(3) + in*vdatom(4)

! if chem = aromatic or heteroyclic ring, subtract 18.3
      IF((nring.GT.0).AND.
     &   (INDEX(chem,'c').GT.0.OR.INDEX(chem,'-O').GT.0)) 
     &    vdmol = vdmol - 18.3

      END
