      PROGRAM boxmod_main

!-----------------------------------------------------------------------------
!     programme lagrangien en simple precision
!-----------------------------------------------------------------------------
!     Fortran90 version: Julia Lee-Taylor, NCAR, Jan 2019
!     NetCDF updates: Julia Lee-Taylor, NCAR, Oct 2017
!     updates: Julia Lee-Taylor, NCAR, Aug 2009
!     - time-dependent advective/diffusive mixing
!     - time-dependent species-dependent emissions
!     - time-dependent seed aerosol : all added via keyfile
!     - aerosol concs adjusted for dilution before partitioning routine
!     - NAN & Simpol Pvap options added, Nov 23, 2011
!     - time-dependent constrained concentrations: May 1, 2015
!     - options for fixed sumc, water, sza, f185, f254: May 1, 2015
!     - tracking of OH and HO2 loss & production rates: Jan 8, 2016
!-----------------------------------------------------------------------------
!----------------------------------------------------------------------------
      USE flags_module,ONLY: print_steadystate_fg
      USE io_units_module,ONLY: lout
      USE time_mgmt_module,ONLY: itout,ntout,tdat

      IMPLICIT NONE

      CHARACTER*(10)    :: date,time1,time2

!====================================================================
! END OF DECLARATIONS
!====================================================================
      PRINT*,"--------------starting boxmod----------------"

      CALL date_and_time(date,time1)

! Do all setup in one subroutine call:
      CALL setup_GECKO

! SOLVE THE EQUATIONS : INITIALIZATION 
      CALL manage_initial

! SOLVE THE EQUATIONS : INTEGRATION LOOP
      CALL manage_loop

! END OF THE SIMULATION: CLOSE FILES, DEALLOCATE VARIABLES
      CALL cleanup
      IF (print_steadystate_fg .EQ. 1) CALL printsteadystate

      WRITE(lout,*)
      WRITE(lout,*)' output file has ',itout,' time datasets'
      WRITE(lout,*)' out of an expected ',ntout,' times'

! WRITE the CPU time used to achieve the simulation
      !tdat(1)=0.
      !tdat(2)=0.
      !duree=etime(tdat)

      !WRITE (lout,'(a14, 1pe11.4)') 'duree=', duree

      CALL date_and_time(date,time2)
      WRITE (lout,*) 'runtime: ', time1," => ",time2

! -------------------------------
      END PROGRAM boxmod_main
! -------------------------------

