      SUBROUTINE twostep5                              &
      (maxsp, maxre, numre, mxleft, mxright, mself,    &
       numsp, numstoi, idrestoi, idpdstoi, nself, idselfreac, &
       t, te, dtmin, dtmax, anrat, restoicf, pdstoicf, &
       numit, atol, rtol, rem, rdep, rex, rdil,        &
       mtr, ntr, idtr, trprod, trloss, conid,ncons,    &
       y, noxfix, sumnox, idno, idno2, idno3,          &
       lpmap)

!jmlt!
! loops ondensed where possible
! yields additional terms (rates / s):
!        trprod(t)=dt*yp(t,idtr) &
!        trloss(t)=dt*yl(t,idtr)*y(t,idtr)
! !! or !! (tracer prod / loss, organi! rxns only)
!        trprod(t)=dt*tp(t,idtr) &
!        trloss(t)=dt*tl(t,idtr)*y(t,idtr)
! allows concentrations to be fixed at iteration level

! **********************************************************************
! programmes appelants : CHIMV4, CHIMPUFF
! programmes appeles   : iter, fit, newdt
! **********************************************************************

!     author: Jan Verwer, Centre for Mathematics and Computer Science
!     (CWI), Kruislaan 413, 1098 sj Amsterdam, the Netherlands

!     email address: janV@wi.nl
!     Version: november 1994 / 2

!     purpose: twostep is designed for the numerical solution of
!     stiff ODE systems

!        dy(t)/dt = yp(t,y) - yl(y,t)*y(t)

!     Originating from atmospheric chemistry. Its underlying integration
!     method is the implicit, 2nd order, 2-step bdf formula. A simple
!     explicit gauss-seidel technique is used for approximating the
!     implicitly defined bdf solutions, rather than the usual modified
!     newton method [1,2]. By this approach twostep is explicit, whereas
!     the excellent stability of the bdf method is maintained. Also the
!     Jacobi technique may be appropriate. In general, however, its use
!     generally dereases the stability of twostep and hence also the
!     efficiency.

!     While in the prototype solver discussed in [1] the number of
!     iterations is determined by a convergence criterion, twostep
!     works with a fixed, a priori given number of iterations. This
!     leads to a somewhat simpler code and in various experiments
!     this more simple strategy has turned out to be as efficient as
!     the iteration strategy [2]. In fact, twostep may work well with
!     only a few iterations per integration step. In this situation
!     twostep has a workload omparable to explicit solvers based
!     on the quasi-steady-state-approach (qssa) [3]. Note that when
!     a few gauss-seidel iterations are used, the order of the components
!     generally will influence the accuracy. To our experience this
!     influence is minor.

!     [1] j.g. verwer, gauss-seidel iteration for stiff odes from
!     chemical kinetics, siam journal on scientific computing 15,
!     1243 - 1250, 1994.

!     [2] j.g. verwer & d. simpson, a comparison between two explicit
!     methods for stiff odes from atmospheric chemistry. report
!     nm-r9414, CWI, amsterdam, 1994 (to appear in appl. numer. math.).

!     [3] j.g. verwer & m. van loon,  an evaluation of explicit pseudo-
!     steady-state approximation schemes for stiff ode systems from
!     chemical kinetics, j. comput. phys. 113, 347 - 352, 1994.

!----------------------------------------------------------------------

!     Meaning of Parameters:

!     numsp   - INTEGER. number of components.
!     t       - REAL. the independent variable time.
!     te      - REAL. the endpoint of time.
!     dt      - REAL. the stepsize.
!     dtmin   - REAL. a minimum for dt.
!     dtmax   - REAL. a maximum for dt.
!     yold    - REAL array (n). solution at previous time point.
!     y       - REAL array (n). solution at current time point.
!     ynew    - REAL array (n). solution at forward time point.
!     yp      - REAL array (n). storage for the prodution term.
!     yl      - REAL array (n). storage for the loss term.
!     yl_org  - REAL array (n). storage for the loss term due to organi
!     reactions only.
!     tot     - REAL array (n). workarray for the bdf2 method.
!     atol    - REAL array (n). absolute tolerances.
!     rtol    - REAL array (n). relative tolerances.
!     numit   - INTEGER. number of gauss-seidel or Jacobi iterations.
!     nfcn    - INTEGER. the total number of (function) CALLs of iter.
!     naccpt  - INTEGER. the number of accepted integration steps.
!     nrejec  - INTEGER. the number of rejected integration steps.
!     nstart  - INTEGER. the number of restarts + 1.

!----------------------------------------------------------------------
!     storage: 9 REAL arrays of dimension n.
!----------------------------------------------------------------------

!     input:

!     numsp   - number of components.
!     t       - initial time; t is changed.
!     te      - the endpoint of time.
!     dtmin   - the minimal stepsize that twostep is allowed to use.
!     dtmax   - the maximal stepsize that twostep is allowed to use.

!               IF on input dtmin = dtmax, THEN dt:=dtmin and dt is kept
!               fixed throughout the integration, possibly except for
!               the final step where dt may be adjusted to precisely hit
!               the end point te. so, the length of the interval need not be
!               an INTEGER multiple of the selected stepsize.

!               IF dtmin = dtmax, the stepsize control is switched off.
!               the user thus should ascertain that the integration
!               process remains stable for the selected stepsize.

!               IF dtmax > dtmin, THEN stepsize control is carried out
!               and twostep determines an initial stepsize itself. however,
!               the control and the initial stepsize selection can be
!               overruled to satisfy the constraint dtmin <= dt <= dtmax.

!     y       - initial solution vector; y is changed.
!     atol    - absolute tolerances.
!     rtol    - relative tolerances.

!     numit   - the number of gauss-seidel (or Jacobi iterations) used
!               per time step. this number thus is a priori described
!               for the whole integration. a low number is recommended
!               for gauss-seidel iteration [1,2].

!               note that for the gauss-seidel technique the order of
!               the components within iter will play a role. it is
!               recommended to order the components in decreasing
!               of the loss rates for the very short living species
!               like the radicals.

!----------------------------------------------------------------------
!     output:

!     t       - t = te.
!     dtold   - the last stepsize value used when working with
!               variable stepsizes.
!     dt      - the last stepsize used to hit the endpoint te
!               when working with constant stepsizes.
!     y       - the computed solution at t = te.
!     nfcn, naccpt, nrejec, nstart, startdt - see meaning of parameters.

!----------------------------------------------------------------------
!     tracer info:

!     ntr : number of tracers for which information is required
!     idtr(mtr) : i.d. numbers of these tracers
!     trprod(maxsp) : total prodution rate of each tracer (molec/cc/s)
!     trloss(maxsp) : total loss ratw of eah tracer (molec/cc/s)

!----------------------------------------------------------------------

!     subroutines:

!     twostep calls three subroutines, viz. newdt, fit and iter. only
!     subroutine iter is to be defined by the user.

!     newdt  - computes the new stepsize. newdt itself CALLs fit.
!     fit    - may adjust dt to guarantee that the remainder
!              of the integration interval is an INTEGER multiple of
!              the current stepsize. the adjustment is carried as soon
!              as (te-t)/dt <= 10.0. hence the adjustment may lead to
!              a stepsize smaller than dtmin for approximately
!              ten integration steps.
!     iter   - a user defined routine for the ODE system. within iter
!              also the gauss-seidel or Jacobi technique is to be
!              implemented by the user, as exemplified below:

!----------------------------------------------------------------------

       USE prodloss_module
       IMPLICIT NONE

! ----------------------------------------------------------------------
! 1.1 variables d interfae
! ----------------------------------------------------------------------

! n             i    input     nb d especes
! maxsp         i    input     nb max d especes
! maxre         i    input     nb max de reactions
! numre         i    input     nb de reactions
! maxstoi       i    input     nb max de doeff. stoechio
! numsp         i    input     nb d especes
! t             r    input     temps de debut
! te            r    input
! dtmin, dtmax  r    input     pas de temps mim, max
! anrat         r    input
! stoidf        r    input     stoichio. coefficients for cvar reactions
! numit         i    input     nb d iterations pour seidel ou Jacobi (= 2)
! startdt       r    input     pas de temps min
! atol, rtol    r    input     tolerance absolute, relative
! mtr           i    input     nb max de tracers
! ntr           i    input     nb de tracers
! idtr          i    input     i.d. de tracers
! y             r    in/output concentration
! dt            r    output
! trloss,trprod r    output    tracer loss / production rates

! tot           r    local
! yold          r    local
! ynew          r    local
! yl            r    local
! yp            r    local


      INTEGER maxsp, maxre, numsp, numre
      INTEGER numit
      INTEGER mxleft, mxright
      INTEGER mself,nself
      INTEGER,DIMENSION(maxre,2):: numstoi
      INTEGER,DIMENSION(mself,2):: idselfreac
      INTEGER,DIMENSION(maxre,mxleft)::  idrestoi
      INTEGER,DIMENSION(maxre,mxright):: idpdstoi
! arrays for tracer production/loss rate tracking
      INTEGER  mtr,ntr
      INTEGER,DIMENSION(mtr)::  idtr
      REAL,DIMENSION(maxsp)::   trprod,trloss
! constrained concentrations
      INTEGER  noxfix, idno, idno2, idno3
      INTEGER  ncons
      INTEGER,DIMENSION(ncons):: conid
      REAL     sumnox
! index map
      TYPE(spec_reac_map),TARGET,INTENT(IN):: lpmap(maxsp)

!       REAL atol(maxsp), rtol(maxsp)
      REAL atol, rtol
      REAL t, te, dtmin, dtmax, dt
      REAL,DIMENSION(maxre):: anrat
      REAL,DIMENSION(maxre,mxleft)::  restoicf
      REAL,DIMENSION(maxre,mxright):: pdstoicf
      REAL,DIMENSION(maxsp):: tot, y, yold, ynew
      REAL,DIMENSION(maxsp):: yl, yp
      REAL,DIMENSION(maxsp):: tl, tp
      REAL,DIMENSION(maxsp):: rem, rdep, rex
      REAL rdil
      REAL errt,memerrt
      INTEGER memid


! ----------------------------------------------------------------------
! 1.2 variables locales
! ----------------------------------------------------------------------

      INTEGER i, j, k
      INTEGER nfcn, naccpt, nrejec
      INTEGER nstart
! jmlt: max orders of magnitude available for dt alculation
      INTEGER,PARAMETER :: mach = 38

      REAL dtold, errlte, dtg
      REAL ratio, ytol, dy
      REAL a1, a2, c, cp1
      REAL zero

      LOGICAL accept, restart, failer

! ***************************************************************************
! etape 2 :
! ***************************************************************************
!      WRITE(6,*) 'starting twostep'
! --------------------------------------------------------------------------
!     initialization of counters, etc.
! -------------------------------------------------------------------------

      naccpt=0
      nrejec=0
      nfcn=0
      nstart=0
      failer=.false.
      restart=.false.
      accept=.true.

      trprod = 0.
      trloss = 0.


! --------------------------------------------------------------------------
!     initial stepsize computation.
! --------------------------------------------------------------------------

      IF (dtmin.EQ.dtmax) THEN
       nstart=1
       dt=min(dtmin,(te-t)/2)
       GOTO 28
      ENDIF

      tot =y
      !PRINT*,"----- FIRST CALL ------",0.
      CALL iter4                               &
        (maxsp, maxre, mxleft, mxright, mself, &
         numsp, numre, numstoi, idrestoi, idpdstoi, nself,idselfreac, &
         restoicf,pdstoicf,                     &
         anrat, tot, 0.,                       &
         rem, rdep, rex, rdil,                 &
         y, yp, yl, tp, tl, conid,ncons,        &
         noxfix, sumnox, idno, idno2, idno3,   &
         lpmap)

      nfcn=nfcn+1
      dt=te-t

      DO 20 i=1,numsp
      !DO i=1,numsp
!!       ytol=atol(i)+rtol(i)*abs(y(i))
       ytol=atol+rtol*abs(y(i))
       dy=yp(i)-y(i)*yl(i)

       IF (dy.NE.0.0) THEN
!jmlt added ondition to prevent fpes for very large dt values
!      PRINT*,ytol,abs(log10(ytol))+abs(log10(abs(dy))),dt
         IF(abs(log10(ytol))+abs(log10(abs(dy))).GT.mach)THEN
           dt = dt
         ELSE
           dt=min(dt,ytol/abs(dy))
         ENDIF

       ENDIF
   20 CONTINUE ! replaced with ENDDO
      !ENDDO

   25 CONTINUE  ! "going back in time" condition jumps back here

      nstart=nstart+1
      IF (restart) dt=dt/10.0
      restart=.true.
      dt=max(dtmin,min(dt,dtmax))

      CALL fit (t,te,dt)

      dt=min(dt,(te-t)/2)

! --------------------------------------------------------------------------
!     the starting step is carried out, using the implicit euler method.
! --------------------------------------------------------------------------

   28 CONTINUE

      ynew(1:numsp)=y(1:numsp)
      yold(1:numsp)=y(1:numsp)
      tot(1:numsp)=y(1:numsp)

      DO 40 i=1,numit
!      DO i=1,numit
        !PRINT*,"----- SECOND CALL ------", dt
        CALL iter4                             &
        (maxsp, maxre, mxleft, mxright, mself, &
         numsp, numre, numstoi, idrestoi, idpdstoi, nself,idselfreac, &
         restoicf,pdstoicf,                     &
         anrat, tot, dt,                       &
         rem, rdep, rex, rdil,                 &
         ynew, yp, yl, tp, tl, conid,ncons,     & 
         noxfix, sumnox, idno, idno2, idno3,   &
         lpmap)

        nfcn=nfcn+1
   40 CONTINUE  ! replaced with ENDDO
!      ENDDO

      naccpt=naccpt+1
      t=t+dt
      y(1:numsp)=ynew(1:numsp)

      dtold=dt
      ratio=1.0

! --------------------------------------------------------------------------
!     subsequent steps are carried out with the two-step bdf method.
! --------------------------------------------------------------------------

   60 CONTINUE ! replaced with "DO WHILE" structure 
      !loop60: DO WHILE ((dt.NE.dtold).AND.(t.LT.te))
      !DO WHILE ((dt.NE.dtold) AND (t.LT.te))

      c=1.0/ratio
      cp1=c+1.0
      a1=((c+1.0)**2)/(c*c+2.0*c)
      a2=-1.0/(c*c+2.0*c)
      dtg=dt*(1.0+c)/(2.0+c)
      zero = 0.

      tot(1:numsp)=a1*y(1:numsp)+a2*yold(1:numsp)
      ynew(1:numsp)=  &
         max(zero,y(1:numsp)+ratio*(y(1:numsp)-yold(1:numsp)))

      DO 80 i=1,numit
!      DO i=1,numit
        PRINT*,"----- THIRD CALL ------",dtg
        CALL iter4                             &
        (maxsp, maxre, mxleft, mxright, mself, &
         numsp, numre, numstoi, idrestoi, idpdstoi, nself, idselfreac, &
         restoicf, pdstoicf,                   &
         anrat, tot, dtg,                      &
         rem, rdep, rex, rdil,                 &
         ynew, yp, yl, tp, tl, conid, ncons,   &
         noxfix, sumnox, idno, idno2, idno3,   &
         lpmap)

        nfcn=nfcn+1
   80 CONTINUE ! replaced with ENDDO
!      ENDDO 

! --------------------------------------------------------------------------
!     IF stepsizes should remain equal, stepsize control is omitted.
! --------------------------------------------------------------------------

      IF (dtmin.EQ.dtmax) THEN
        PRINT*,"dtmin = dtmax",dtmin,dtmax

        t=t+dtold
        naccpt=naccpt+1

        yold(1:numsp)=y(1:numsp)
        y(1:numsp)=ynew(1:numsp)
 
        IF (dt.NE.dtold) THEN
          t=t-dtold+dt
          PRINT*,"RETURNING: 1"
          GOTO 120 ! replaced with "RETURN"
          !RETURN
        ENDIF ! replaced with ELSE: moved to later

        dt=min(dtold,te-t)
        ratio=dt/dtold

        IF (t.GE.te) THEN
          PRINT*,"RETURNING: 2"
          GOTO 120
          !RETURN
        ELSE
          GOTO 60 ! replaced with "CYCLE"
          !CYCLE loop60
        ENDIF

      ENDIF ! replaced with ELSE: moved to later
      ! ELSE

! --------------------------------------------------------------------------
!     otherwise stepsize control is carried out.
! --------------------------------------------------------------------------
        PRINT*,"stepwise control: CALLING newdt"

        errlte=0.0

      DO 90 i=1,numsp
      !  DO i=1,numsp
          ytol=atol+rtol*abs(y(i))
          errt=abs(c*ynew(i)-cp1*y(i)+yold(i))/ytol
          IF (errt.GT.errlte) THEN
            errlte=errt
            memerrt=errt
            memid=i
          ENDIF
   90 CONTINUE ! replaced with ENDDO
!        ENDDO

! troubleshooting 
!      WRITE(55,'(3(e13.5),i7)') t,dt,memerrt,memid

        errlte=2.0*errlte/(c+c*c)

        CALL newdt(t,te,dtold,errlte,dtmin,dtmax,dt,ratio,accept)

        PRINT*,"----------"
        PRINT*,"t, te, dtold, errlte, dtmin, dtmax, dt, ratio, accept"
        PRINT*,t, te, dtold, errlte, dtmin, dtmax, dt, ratio, accept
        PRINT*,"----------"

      !ENDIF

! --------------------------------------------------------------------------
!     here the step has been accepted.
! --------------------------------------------------------------------------

      IF (accept) THEN

       failer=.false.
       restart=.false.
       t=t+dtold
       naccpt=naccpt+1

       yold(1:numsp)=y(1:numsp)
       y(1:numsp)=ynew(1:numsp)

!jmlt: tracer rates!
        DO k=1,ntr
! all rates
!          trprod(idtr(k))=yp(idtr(k))
!          trloss(idtr(k))=yl(idtr(k))*y(idtr(k))
! rates for organic reactions only
          trprod(idtr(k))=tp(idtr(k))
          trloss(idtr(k))=tl(idtr(k))*y(idtr(k))
        ENDDO
!jmlt: end tracer rates!

       !IF (t.GE.te) GOTO 120
       IF (t.GE.te) RETURN

       PRINT*,"CYCLING 60: step accepted"
       GOTO 60
       !CYCLE loop60
      ENDIF

! --------------------------------------------------------------------------
!     a restart heck is carried out.
! --------------------------------------------------------------------------

      IF (failer) THEN

       nrejec=nrejec+1
       failer=.false.
       naccpt=naccpt-1
       t=t-dtold
       y(1:numsp)=yold(1:numsp)

       !WRITE(6,*) 'going back in time'
       PRINT*,"GOTO 25: going back in time"
       GOTO 25

      ENDIF

! --------------------------------------------------------------------------
!     here the step has been rejeted.
! --------------------------------------------------------------------------

        nrejec=nrejec+1
        failer=.true.
      GOTO 60
      !ENDDO loop60

  120 CONTINUE ! rendered unnecessary by use of "RETURN" statements

! --------------------------------------------------------------------------
      END SUBROUTINE twostep5
! --------------------------------------------------------------------------
