      SUBROUTINE rin3(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for O3             =*
*=  photolysis:                                                              =*
*=         O3 + hv -> O3P                                                =*
*=                                                                           =*
*=  Cross section:  SAPRC99                                                  =*
*=  Quantum yield:  SAPRC99                                                  =*
*-----------------------------------------------------------------------------*
*=  PARAMETERS:                                                              =*
*=  NW     - INTEGER, number of specified intervals + 1 in working        (I)=*
*=           wavelength grid                                                 =*
*=  WL     - REAL, vector of lower limits of wavelength intervals in      (I)=*
*=           working wavelength grid                                         =*
*=  WC     - REAL, vector of center points of wavelength intervals in     (I)=*
*=           working wavelength grid                                         =*
*=  NZ     - INTEGER, number of altitude levels in working altitude grid  (I)=*
*=  TLEV   - REAL, temperature (K) at each specified altitude level       (I)=*
*=  AIRLEV - REAL, air density (molec/cc) at each altitude level          (I)=*
*=  J      - INTEGER, counter for number of weighting functions defined  (IO)=*
*=  SQ     - REAL, cross section x quantum yield (cm^2) for each          (O)=*
*=           photolysis reaction defined, at each defined wavelength and     =*
*=           at each defined altitude level                                  =*
*=  JLABEL - CHARACTER*40, string identifier for each photolysis reaction (O)=*
*=           defined                                                         =*
*-----------------------------------------------------------------------------*
*=  EDIT HISTORY:                                                            =*
*=  05/98  Original, adapted from former JSPEC1 subroutine                   =*
*-----------------------------------------------------------------------------*
*= This program is free software;  you can redistribute it and/or modify     =*
*= it under the terms of the GNU General Public License as published by the  =*
*= Free Software Foundation;  either version 2 of the license, or (at your   =*
*= option) any later version.                                                =*
*= The TUV package is distributed in the hope that it will be useful, but    =*
*= WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHANTIBI-  =*
*= LITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public     =*
*= License for more details.                                                 =*
*= To obtain a copy of the GNU General Public License, write to:             =*
*= Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.   =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'O3 -> O3P MCM'
!      jlabel3(j) = 'PHOT  O3  3  10'
      jlabel3(j) = 'PHOT  O3  3 '


      OPEN(UNIT=kin,FILE='MCM2001/INORG/O3O3P.PHD',
     $     STATUS='old')
      do i = 1, 11
         read(kin,*)
      enddo
      n = 81
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

* combine:
      DO iw = 1, nw - 1
         DO i = 1, nz
            sig = yg(iw)
* quantum yields:
            qy1 = yg1(iw)
            sq(j  ,i,iw) = sig * qy1
         ENDDO
      ENDDO
        
      END


* =============================================================================
      SUBROUTINE rin2(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for O3             =*
*=  photolysis:                                                              =*
*=         O3 + hv -> O1D                                           =*
*=                                                                           =*
*=  Cross section:  SAPRC99                                                  =*
*=  Quantum yield:  SAPRC99                                                  =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'O3 -> O1D MCM'
!      jlabel3(j) = 'PHOT  O3  2  10'
      jlabel3(j) = 'PHOT  O3  2 '


      OPEN(UNIT=kin,FILE='MCM2001/INORG/O3O1D.PHD',
     $     STATUS='old')
      do i = 1, 12
         read(kin,*)
      enddo
      n = 61
cba store the number of data
      n1=n
      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END
* =============================================================================
      SUBROUTINE rin4(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for NO2            =*
*=  photolysis:                                                              =*
*=         NO2 + hv -> NO + O(3P)                                               =*
*=                                                                           =*
*=  Cross section:  SAPRC99                                                  =*
*=  Quantum yield:  SAPRC99                                                  =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'NO2 -> NO + O(3P) MCM'
!      jlabel3(j) = 'PHOT  NO2  4  10'
      jlabel3(j) = 'PHOT  NO2  4 '


      OPEN(UNIT=kin,FILE='MCM2001/INORG/NO2.PHD',
     $     STATUS='old')
      do i = 1, 6
         read(kin,*)
      enddo
      n = 56
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END


* =============================================================================
      SUBROUTINE rin40(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for CH3ONO         =*
*=  photolysis:                                                              =*
*=         CH3ONO + hv -> NO + CH3O
*=                                                                           =*
*=  Cross section:  SAPRC99  (using values for NO2)                          =*
*=  Quantum yield:  SAPRC99  (using valuse for NO2)                          =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'CH3ONO -> NO + CH3O after NO2 MCM'
      jlabel3(j) = 'PHOT  CH3ONO  40000 '


      OPEN(UNIT=kin,FILE='MCM2001/INORG/NO2.PHD',
     $     STATUS='old')
      do i = 1, 6
         read(kin,*)
      enddo
      n = 56
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END


* =============================================================================
      SUBROUTINE rin11(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for H2O2           =*
*=  photolysis:                                                              =*
*=         H2O2 + hv -> 2 OH                                               =*
*=                                                                           =*
*=  Cross section:  SAPRC99                                                  =*
*=  Quantum yield:  SAPRC99                                                  =*
* XS held constant from 190 to 180 (estimate)
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'H2O2 -> 2 OH MCM'
!      jlabel3(j) = 'PHOT  H2O2  11  10'
      jlabel3(j) = 'PHOT  H2O2  11 '


      OPEN(UNIT=kin,FILE='MCM2001/INORG/H2O2.PHD',
     $     STATUS='old')
      do i = 1, 6
         read(kin,*)
      enddo
      !n = 34
      n = 36
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END


* =============================================================================
      SUBROUTINE rin5(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for NO3             =*
*=  photolysis:                                                              =*
*=         NO3 + hv -> NO + O2                                               =*
*=                                                                           =*
*=  Cross section:  SAPRC99                                                  =*
*=  Quantum yield:  SAPRC99                                                  =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'NO3 -> NO + O2 MCM'
!      jlabel3(j) = 'PHOT  NO3  5  10'
      jlabel3(j) = 'PHOT  NO3  5 '

      OPEN(UNIT=kin,FILE='MCM2001/INORG/NO3NO.PHD',
     $     STATUS='old')
      do i = 1, 6
         read(kin,*)
      enddo
      n = 56
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
      ENDDO
      CLOSE(kin)
      
      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo

      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF
 
* combine:
      DO iw = 1, nw - 1
         DO i = 1, nz
            sig = yg(iw)
* quantum yields:
            qy1 = yg1(iw)
            sq(j  ,i,iw) = sig * qy1
         ENDDO
      ENDDO
      
      END

* =============================================================================
      SUBROUTINE rin6(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for NO3             =*
*=  photolysis:                                                              =*
*=         NO3 + hv -> NO2 + O(3P)                                               =*
*=                                                                           =*
*=  Cross section:  SAPRC99                                                  =*
*=  Quantum yield:  SAPRC99                                                  =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'NO3 -> NO2 + O(3P) MCM'
!      jlabel3(j) = 'PHOT  NO3  6  10'
      jlabel3(j) = 'PHOT  NO3  6 '


      OPEN(UNIT=kin,FILE='MCM2001/INORG/NO3NO2.PHD',
     $     STATUS='old')
      do i = 1, 6
         read(kin,*)
      enddo
      n = 236
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
c        write(*,*) x1(i),y1(i)
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

* combine:
      DO iw = 1, nw - 1
         DO i = 1, nz
            sig = yg(iw)
* quantum yields:
            qy1 = yg1(iw)
            sq(j  ,i,iw) = sig * qy1
         ENDDO
      ENDDO

      END

* =============================================================================
      SUBROUTINE rin12(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for HONO           =*
*=  photolysis:                                                              =*
*=         HONO + hv -> NO + OH                                              =*
*=                                                                           =*
*=  Cross section:  Stutz 00                                                 =*
*=  Quantum yield:  1.                                                       =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'HONO -> NO + OH MCM'
!      jlabel3(j) = 'PHOT  HONO  12  10'
      jlabel3(j) = 'PHOT  HONO  12 '


      OPEN(UNIT=kin,FILE='MCM2001/INORG/HONO.txt',
     $     STATUS='old')
      do i = 1, 4
         read(kin,*)
      enddo
      n = 191
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)
            sq(j  ,i,iw) = sig * qy1
         ENDDO
      ENDDO
      END

* =============================================================================
      SUBROUTINE rin13(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for HNO3           =*
*=  photolysis:                                                              =*
*=         HNO3 + hv -> NO2 + OH                                             =*
*=                                                                           =*
*=  Cross section:  SAPRC99                                                  =*
*=  Quantum yield:  SAPRC99                                                  =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'HNO3 -> NO2 + OH MCM'
!      jlabel3(j) = 'PHOT  HNO3  13  10'
      jlabel3(j) = 'PHOT  HNO3  13 '


      OPEN(UNIT=kin,FILE='MCM2001/INORG/HNO3.PHD',
     $     STATUS='old')
      do i = 1, 6
         read(kin,*)
      enddo
      n = 34
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END


* =============================================================================
      SUBROUTINE rin14(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for HNO4           =*
*=  photolysis:                                                              =*
*=         HNO4 + hv -> 0.61 NO2 + 0.61 HO2 + 0.39 NO3 + 0.39 OH             =*
*=                                                                           =*
*=  Cross section:  SAPRC99                                                  =*
*=  Quantum yield:  SAPRC99                                                  =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'HNO4 -> 0.61 NO2+ 0.61 HO2+ 0.39 NO3+ 0.39 OH MCM'
!      jlabel3(j) = 'PHOT  HNO4  14  10'
      jlabel3(j) = 'PHOT  HNO4  14 '


      OPEN(UNIT=kin,FILE='MCM2001/INORG/HO2NO2.PHD',
     $     STATUS='old')
      do i = 1, 6
         read(kin,*)
      enddo
      n = 30
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END


* =============================================================================
      SUBROUTINE rin15(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for H2CO           =*
*=  photolysis:                                                              =*
*=         H2CO + hv -> 2 HO2 + CO                                             =*
*=                                                                           =*
*=  Cross section:  SAPRC99                                                  =*
*=  Quantum yield:  SAPRC99                                                  =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'HCHO -> 2 HO2 + CO MCM'
!!      jlabel3(j) = 'PHOT  H2CO  15  10'  ! old version
!      jlabel3(j) = 'PHOT  H2CO  110  10'   ! 2012 
      jlabel3(j) = 'PHOT  H2CO  110 '   ! 2012 


      OPEN(UNIT=kin,FILE='MCM2001/INORG/HCHO_R.PHD',
     $     STATUS='old')
      do i = 1, 6
         read(kin,*)
      enddo
      n = 103  !101
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END

* =============================================================================
      SUBROUTINE rin16(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for H2CO           =*
*=  photolysis:                                                              =*
*=         H2CO + hv -> H2 + CO                                             =*
*=                                                                           =*
*=  Cross section:  SAPRC99                                                  =*
*=  Quantum yield:  SAPRC99                                                  =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'HCHO -> H2 + CO MCM'
!!      jlabel3(j) = 'PHOT  H2CO  16  10'  ! old version
!      jlabel3(j) = 'PHOT  H2CO  17  10'  ! 2012 version
      jlabel3(j) = 'PHOT  H2CO  17 '  ! 2012 version


      OPEN(UNIT=kin,FILE='MCM2001/INORG/HCHO_M.PHD',
     $     STATUS='old')
      do i = 1, 6
         read(kin,*)
      enddo
      n = 123  !121
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO
      END
* =============================================================================
      SUBROUTINE rin72(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for aromatic         =*
*=  photolysis:                                                              =*
*=         DCB2 + hv -> cf SAPRC99                                             =*
*=                                                                           =*
*=  Cross section:  SAPRC99                                                  =*
*=  Quantum yield:  SAPRC99                                                  =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'DCB2 -> product MCM'
!      jlabel3(j) = 'PHOT  DCB2  72  10'
      jlabel3(j) = 'PHOT  DCB2  72 '


      OPEN(UNIT=kin,FILE='MCM2001/INORG/MGLY_ABS.PHD',
     $     STATUS='old')
      do i = 1, 6
         read(kin,*)
      enddo
      n = 551
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
	 y2(i) = 3.7E-1
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO
      END  
* =============================================================================
      SUBROUTINE rin73(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for              =*
*=  photolysis:                                                              =*
*=         DCB3 + hv -> cf SAPRC99                                           =*
*=                                                                           =*
*=  Cross section:  SAPRC99                                                  =*
*=  Quantum yield:  SAPRC99                                                  =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'DCB3 -> product MCM'
!      jlabel3(j) = 'PHOT  DCB3  73  10'
      jlabel3(j) = 'PHOT  DCB3  73 '


      OPEN(UNIT=kin,FILE='MCM2001/INORG/ACROLEIN.PHD',
     $     STATUS='old')
      do i = 1, 6
         read(kin,*)
      enddo
      n = 131
cba store the number of data
      n1=n
      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
         y2(i) = 7.3E+00
	 
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END
* =============================================================================
      SUBROUTINE rin74(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for benzaldehyde   =*
*=  photolysis:                                                              =*
*=         BALD + hv -> cf SAPRC99                                           =*
*=                                                                           =*
*=  Cross section:  SAPRC99                                                  =*
*=  Quantum yield:  SAPRC99                                                  =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'BALD -> nothing MCM'
!      jlabel3(j) = 'PHOT  BENZAL  74  10'
      jlabel3(j) = 'PHOT  BENZAL  74 '


      OPEN(UNIT=kin,FILE='MCM2001/INORG/BZCHO.PHD',
     $     STATUS='old')
      do i = 1, 6
         read(kin,*)
      enddo
      n = 26
cba store the number of data
      n1=n
      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
         y2(i) = 5.0E-2
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END
