      SUBROUTINE rou1(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*				NITRATES
*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for 1_C5H11ONO2    =*
*=  photolysis:                                                              =*
*=         1_C5H11ONO2 + hv -> 1_C5H11H9O. + NO2                             =*
*=                                                                           =*
*=  Cross section:  Zhu 97                                                   =*
*=  Quantum yield:  Zhu 97                                                   =*
*-----------------------------------------------------------------------------*
*=  PARAMETERS:                                                              =*
*=  NW     - INTEGER, number of specified intervals + 1 in working        (I)=*
*=           wavelength grid                                                 =*
*=  WL     - REAL, vector of lower limits of wavelength intervals in      (I)=*
*=           working wavelength grid                                         =*
*=  WC     - REAL, vector of center points of wavelength intervals in     (I)=*
*=           working wavelength grid                                         =*
*=  NZ     - INTEGER, number of altitude levels in working altitude grid  (I)=*
*=  TLEV   - REAL, temperature (K) at each specified altitude level       (I)=*
*=  AIRLEV - REAL, air density (molec/cc) at each altitude level          (I)=*
*=  J      - INTEGER, counter for number of weighting functions defined  (IO)=*
*=  SQ     - REAL, cross section x quantum yield (cm^2) for each          (O)=*
*=           photolysis reaction defined, at each defined wavelength and     =*
*=           at each defined altitude level                                  =*
*=  JLABEL - CHARACTER*40, string identifier for each photolysis reaction (O)=*
*=           defined                                                         =*
*-----------------------------------------------------------------------------*
*=  EDIT HISTORY:                                                            =*
*=  05/98  Original, adapted from former JSPEC1 subroutine                   =*
*-----------------------------------------------------------------------------*
*= This program is free software;  you can redistribute it and/or modify     =*
*= it under the terms of the GNU General Public License as published by the  =*
*= Free Software Foundation;  either version 2 of the license, or (at your   =*
*= option) any later version.                                                =*
*= The TUV package is distributed in the hope that it will be useful, but    =*
*= WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHANTIBI-  =*
*= LITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public     =*
*= License for more details.                                                 =*
*= To obtain a copy of the GNU General Public License, write to:             =*
*= Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.   =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = '1_C5H11ONO2 + hv -> 1_C5H11H9O. + NO2'
!      jlabel3(j) = 'PHOT  1_C5H11ONO2  10100  10'
      jlabel3(j) = 'PHOT  1_C5H11ONO2  10100 '


      OPEN(UNIT=kin,FILE='MCM2001/npentylnitrate.prn',
     $     STATUS='old')
      do i = 1, 2
         read(kin,*)
      enddo
      n = 20
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END
* =============================================================================
      SUBROUTINE rou2(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)
*=------------------------------------------------------------------------
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for 2_C4H9ONO2     =*
*=  photolysis:                                                              =*
*=         2_C4H9ONO2 + hv -> 2_C4H9O. + NO2                                 =*
*=                                                                           =*
*=  Cross section:  IUPAC99                                                  =*
*=  Quantum yield:  IUPAC99                                                  =*
*-----------------------------------------------------------------------------*


      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = '2_C4H9ONO2 + hv -> 2_C4H9O. + NO2'
!      jlabel3(j) = 'PHOT  2_C4H9ONO2  10200  10'
      jlabel3(j) = 'PHOT  2_C4H9ONO2  10200 '


      OPEN(UNIT=kin,FILE='MCM2001/2butylnitrate.prn',
     $     STATUS='old')
      do i = 1, 2
         read(kin,*)
      enddo
      n = 20
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END


* =============================================================================
      SUBROUTINE rou3(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for tert_C4H9ONO2             =*
*=  photolysis:                                                              =*
*=         tert_C4H9ONO2 + hv -> tert_C4H9O. + NO2                                            =*
*=                                                                           =*
*=  Cross section:  Roberts 89                                                  =*
*=  Quantum yield:  Roberts 89                                                =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'tert_C4H9ONO2 + hv -> tert_C4H9O. + NO2'
!      jlabel3(j) = 'PHOT  tert_C4H9ONO2  10300  10'
      jlabel3(j) = 'PHOT  tert_C4H9ONO2  10300 '


      OPEN(UNIT=kin,FILE='MCM2001/tertbutyl.prn',
     $     STATUS='old')
      do i = 1, 3
         read(kin,*)
      enddo
      n = 19
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END

* =============================================================================
      SUBROUTINE rou4(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for CH3OONO2             =*
*=  photolysis:                                                              =*
*=         CH3OONO2 + hv -> products                                             =*
*=                                                                           =*
*=  Cross section:  IUPAC99                                                  =*
*=  Quantum yield:  IUPAC99                                                  =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'CH3OONO2 + hv -> products'
!      jlabel3(j) = 'PHOT  CH3OONO2  10400  10'
      jlabel3(j) = 'PHOT  CH3OONO2  10400 '


      OPEN(UNIT=kin,FILE='MCM2001/CH3O2NO2.prn',
     $     STATUS='old')
      do i = 1, 3
         read(kin,*)
      enddo
      n = 47
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END




* =============================================================================
      SUBROUTINE rou5(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for PAN            =*
*=  photolysis:                                                              =*
*=         PAN + hv -> products                                              =*
*=                                                                           =*
*=  Cross section:  IUPAC99                                                  =*
*=  Quantum yield:  IUPAC99                                                  =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'PAN + hv -> products'
!      jlabel3(j) = 'PHOT  PAN  10500  10'
      jlabel3(j) = 'PHOT  PAN  10500 '


      OPEN(UNIT=kin,FILE='MCM2001/PAN.prn',
     $     STATUS='old')
      do i = 1, 2
         read(kin,*)
      enddo
      n = 88
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END



*				ALDEHYDES
* =============================================================================
      SUBROUTINE rou6(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for          =*
*=  RCHO (without gamma-H) photolysis and Calpha= tertiary:                                                              =*
*=         n-RCHO (without gamma-H) + hv -> CHO. + R.                                      =*
*=                                                                           =*
*=  Cross section:  t-pentanal (Zhu 99)                                                  =*
*=  Quantum yield:  t-pentanal (Zhu 99)                                                  =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'n-aldehyde (no gamma-H + Calpha tert)+ hv -> 
     &           CHO + R.'
!      jlabel3(j) = 'PHOT  n_aldehyde  20100  10'
      jlabel3(j) = 'PHOT  n_aldehyde  20100 '


      OPEN(UNIT=kin,FILE='MCM2001/t_pentanal_rad',
     $     STATUS='old')
      do i = 1, 3
         read(kin,*)
      enddo
      n = 23
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END
* =============================================================================
      SUBROUTINE rou7(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for          =*
*=  RCHO (without gamma-H) photolysis and Calpha = secondary:                                                              =*
*=         RCHO (without gamma-H) + hv -> CHO. + R.                                      =*
*=                                                                           =*
*=  Cross section:  i-butyraldehyde (Desai86)                                                  =*
*=  Quantum yield:  i-butyraldehyde (Desai86)                                                  =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'n-aldehyde (no gamma-H + Calpha sec) + hv ->
     &               R. + CHO.'
!      jlabel3(j) = 'PHOT  n_aldehyde  20200  10'
      jlabel3(j) = 'PHOT  n_aldehyde  20200 '


      OPEN(UNIT=kin,FILE='MCM2001/i_butyraldehyde_R.prn',
     $     STATUS='old')
      do i = 1, 3
         read(kin,*)
      enddo
      n = 101
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END
* =============================================================================
      SUBROUTINE rou8(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for          =*
*=  RCHO (without gamma-H) and (Calph = primary) photolysis:                                                              =*
*=         RCHO (without gamma-H) + hv -> products                                      =*
*=                                                                           =*
*=  Cross section:  propanal IUPAC 99                                                  =*
*=  Quantum yield:  propanal IUPAC 99                                                  =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'linear aldehyde (no gamma-H + Calpha primary) + hv ->
     &            CHO + R.'
!      jlabel3(j) = 'PHOT  aldehyde  20300  10'
      jlabel3(j) = 'PHOT  aldehyde  20300 '


      OPEN(UNIT=kin,FILE='MCM2001/propanal.prn',
     $     STATUS='old')
      do i = 1, 3
         read(kin,*)
      enddo
      n = 113   !99
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END
* =============================================================================
      SUBROUTINE rou9(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for          =*
*=  RCHO (without gamma-H) and (Calpha = tertiary) photolysis:                                                              =*
*=         RCHO (with gamma-H) + hv -> R. + CHO.                                     =*
*=                                                                           =*
*=  Cross section:  t-pentanal Zhu 99                                                  =*
*=  Quantum yield:  n-pentanal Zhu 99                                                  =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) ='aldehyde (gamma-H + Calpha tert) + hv -> CHO.  + R.'
!      jlabel3(j) = 'PHOT  aldehyde  20400  10'
      jlabel3(j) = 'PHOT  aldehyde  20400 '


      OPEN(UNIT=kin,FILE='MCM2001/ald1',
     $     STATUS='old')
      do i = 1, 4
         read(kin,*)
      enddo
      n = 23
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END
* =============================================================================
      SUBROUTINE rou10(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for          =*
*=  RCHO (with gamma-H) and (Calpha = tertiary) photolysis:                                                              =*
*=         RCHO (with gamma-H) + hv -> Norrish II                                      =*
*=                                                                           =*
*=  Cross section:  t-pentanal (Zhu 99)                                                  =*
*=  Quantum yield:  n-pentanal (Moortgat 99)                                                  =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'RCHO (gamma-H + Calpha tert) + hv -> Norrish II'
!      jlabel3(j) = 'PHOT  RCHO  20500  10'
      jlabel3(j) = 'PHOT  RCHO  20500 '


      OPEN(UNIT=kin,FILE='MCM2001/ald2',
     $     STATUS='old')
      do i = 1, 4
         read(kin,*)
      enddo
      n = 23
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END

* =============================================================================
      SUBROUTINE rou11(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for          =*
*=  RCHO (with gamma-H) and (C alpha not tertiary) photolysis:                                                              =*
*=         RCHO (with gamma-H) + hv -> R. + CHO.                                      =*
*=                                                                           =*
*=  Cross section:  n-pentanal (Zhu 99)                                                 =*
*=  Quantum yield:  n-pentanal (Zhu 99)                                                  =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'RCHO (gamma-H + Calpha sec or prim) + hv -> 
     & CHO. + R.'
!      jlabel3(j) = 'PHOT  RCHO  20600  10'
      jlabel3(j) = 'PHOT  RCHO  20600 '


      OPEN(UNIT=kin,FILE='MCM2001/n_pentanal_rad',
     $     STATUS='old')
      do i = 1, 3
         read(kin,*)
      enddo
      n = 23
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END
* =============================================================================
      SUBROUTINE rou12(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for          =*
*=  RCHO (with gamma-H) and (Calpha = primary or secondary) photolysis:                                                              =*
*=         RCHO (with gamma-H) + hv -> Norrish II                                   =*
*=                                                                           =*
*=  Cross section:  n-pentanal (Zhu 99)                                                 =*
*=  Quantum yield:  n-pentanal (Moortgat 99)                                                  =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'RCHO (gamma-H + Calpha sec or prim) + hv -> Norrish
     &                II'
!      jlabel3(j) = 'PHOT  RCHO  20700  10'
      jlabel3(j) = 'PHOT  RCHO  20700 '


      OPEN(UNIT=kin,FILE='MCM2001/n_pentanal_Norrish',
     $     STATUS='old')
      do i = 1, 3
         read(kin,*)
      enddo
      n = 23
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END

* =============================================================================
      SUBROUTINE rou13(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for          =*
*=  RRC=CRCHO structures photolysis:                                                              =*
*=        RRC=CRCHO structures + hv -> RRC=C(.)R + CHO.                                     =*
*=                                                                           =*
*=  Cross section:  acrolein (Gardner 87)                                                 =*
*=  Quantum yield:  0.02 * 0.34                                                 =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'RRC=CRCHO structures+ hv -> CHO. + =.'
!      jlabel3(j) = 'PHOT  RRC=CRCHO  21100  10'
      jlabel3(j) = 'PHOT  RRC=CRCHO  21100 '


      OPEN(UNIT=kin,FILE='MCM2001/acro_struct1.prn',
     $     STATUS='old')
      do i = 1, 3
         read(kin,*)
      enddo
      n = 131
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END

* =============================================================================
      SUBROUTINE rou14(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for          =*
*=  RRC=CRCHO structures photolysis:                                                              =*
*=        RRC=CRCHO structures + hv -> CO + Crieggee                                      =*
*=                                                                           =*
*=  Cross section:  acrolein (Gardner 87)                                                 =*
*=  Quantum yield:  0.02 * 0.33                                                 =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'RRC=CRCHO structures+ hv -> CO + Crieggee'
!      jlabel3(j) = 'PHOT  RRC=CRCHO  21200  10'
      jlabel3(j) = 'PHOT  RRC=CRCHO  21200 '


      OPEN(UNIT=kin,FILE='MCM2001/acro_struct2.prn',
     $     STATUS='old')
      do i = 1, 3
         read(kin,*)
      enddo
      n = 131
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END

* =============================================================================
      SUBROUTINE rou15(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for          =*
*=  RRC=CRCHO structures photolysis:                                                              =*
*=        RRC=CRCHO structures + hv -> H. + RRC=CRC(.)O                                     =*
*=                                                                           =*
*=  Cross section:  acrolein                                                  =*
*=  Quantum yield:  0.02 *0.33                                                 =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'RRC=CRCHO structures+ hv -> H. + RRC=CRC(.)O'
!      jlabel3(j) = 'PHOT  RRC=CRCHO  21300  10'
      jlabel3(j) = 'PHOT  RRC=CRCHO  21300 '


      OPEN(UNIT=kin,FILE='MCM2001/acro_struct3.prn',
     $     STATUS='old')
      do i = 1, 3
         read(kin,*)
      enddo
      n = 131
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END


* =============================================================================
      SUBROUTINE rou16(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for             =*
*=  RCOCHO photolysis:                                                              =*
*=         RCOCHO + hv -> RC(.)O + CHO.                                           =*
*=                                                                           =*
*=  Cross section:  Calvert 2000                                                  =*
*=  Quantum yield:  Raber 95                                                  =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'RCOCHO + hv -> RC(.)O + CHO.'
!      jlabel3(j) = 'PHOT  RCOCHO  21400  10'
      jlabel3(j) = 'PHOT  RCOCHO  21400 '


      OPEN(UNIT=kin,FILE='MCM2001/Mglyoxal1.prn',
     $     STATUS='old')
      do i = 1, 3
         read(kin,*)
      enddo
      n = 273  !271
    
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
	 
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END
* =============================================================================
      SUBROUTINE rou17(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for             =*
*=  CH3COCHO photolysis:                                                              =*
*=         CH3COCHO + hv -> CO + RCHO                                           =*
*=                                                                           =*
*=  Cross section:  Calvert 2000                                                  =*
*=  Quantum yield:  Raber 95                                                  =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'CH3COCHO + hv -> CO + RCHO'
!      jlabel3(j) = 'PHOT  CH3COCHO  21500  10 '
      jlabel3(j) = 'PHOT  CH3COCHO  21500 '


      OPEN(UNIT=kin,FILE='MCM2001/Mglyoxal2.prn',
     $     STATUS='old')
      do i = 1, 3
         read(kin,*)
      enddo
      n = 273  !271
    
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
	 
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END

* =============================================================================
      SUBROUTINE rou18(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for             =*
*=  CH3COCHO photolysis:                                                              =*
*=         CH3COCHO + hv -> 2 CO + RH                                           =*
*=                                                                           =*
*=  Cross section:  Calvert 2000                                                  =*
*=  Quantum yield:  Raber 95                                                  =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'CH3COCHO + hv -> 2 CO + RH'
!      jlabel3(j) = 'PHOT  CH3COCHO  21600  10'
      jlabel3(j) = 'PHOT  CH3COCHO  21600 '


      OPEN(UNIT=kin,FILE='MCM2001/Mglyoxal3.prn',
     $     STATUS='old')
      do i = 1, 3
         read(kin,*)
      enddo
      n = 273  !271
    
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
	 
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END
* =============================================================================
      SUBROUTINE rou19(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for             =*
*=  EE-2.4 hexadienedial photolysis:                                                              =*
*=         EE-2.4 hexadienedial + hv -> 4 ways                                           =*
*=                                                                           =*
*=  Cross section: Klotz 95                                                  =*
*=  Quantum yield: 0.30 * 0.25                                                  =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'EEhexadienedial + hv -> 4 ways'
     
!      jlabel3(j) = 'PHOT  EEhexadienedial  21900  10'
      jlabel3(j) = 'PHOT  EEhexadienedial  21900 '


      OPEN(UNIT=kin,FILE='MCM2001/EEhexadienedial1.prn',
     $     STATUS='old')
      do i = 1, 5
         read(kin,*)
      enddo
      n = 13
    
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
	 
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END
* =============================================================================
      SUBROUTINE rou20(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for             =*
*=  EE-2.4 hexadienedial photolysis:                                                              =*
*=         EE-2.4 hexadienedial + hv -> 2 different ways                                           =*
*=                                                                           =*
*=  Cross section: Klotz 95                                                  =*
*=  Quantum yield: 0.30 * 0.5                                                 =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'EEhexadienedial + hv -> 2 different ways'
!      jlabel3(j) = 'PHOT  EEhexadienedial  22000  10'
      jlabel3(j) = 'PHOT  EEhexadienedial  22000 '


      OPEN(UNIT=kin,FILE='MCM2001/EEhexadienedial2.prn',
     $     STATUS='old')
      do i = 1, 5
         read(kin,*)
      enddo
      n = 13
    
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
	 
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END

* =============================================================================
      SUBROUTINE rou21(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for             =*
*=  OHCH2CHO photolysis:                                                              =*
*=         OHCH2CHO + hv -> CHO. + RRC(OH).                                           =*
*=                                                                           =*
*=  Cross section:  Moortgat 99                                                   =*
*=  Quantum yield:  1                                                =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'RRC(OH)CHO + hv -> CHO. + RRC(OH).'
!      jlabel3(j) = 'PHOT  RRC(OH)CHO  21800  10 '
      jlabel3(j) = 'PHOT  RRC(OH)CHO  21800 '


      OPEN(UNIT=kin,FILE='MCM2001/glycolaldehyde',
     $     STATUS='old')
      do i = 1, 2
         read(kin,*)
      enddo
      n = 133  !131
    
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
	 
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END

*				KETONES
* =============================================================================
      SUBROUTINE rou22(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for ketone  =*
*=  without gamma-H  photolysis:                                                 =*
*=         C2H5COC2H5 + hv -> RC(.)O + R.                                             =*
*=                                                                           =*
*=  Cross section:  Martinez 92                                                  =*
*=  Quantum yield:  Raber 95 (for 2-butanone)                                                  =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'n-ketone (no gammaH) + hv -> RC(.)O + R.'
!      jlabel3(j) = 'PHOT  n_ketone  30100  10'
      jlabel3(j) = 'PHOT  n_ketone  30100 '


      OPEN(UNIT=kin,FILE='MCM2001/n_ketone1',
     $     STATUS='old')
      do i = 1, 4
         read(kin,*)
      enddo
      n = 95
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END
* =============================================================================
      SUBROUTINE rou23(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for C2H5COC2H5             =*
*=  photolysis:                                                              =*
*=         ketone (gamma-H + two primary C in apha) + hv -> R. + RCO.                                              =*
*=                                                                           =*
*=  Cross section:  Martinez 92                                                  =*
*=  Quantum yield:  Raber 95 (for 2-butanone)                                                  =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'n-ketone + hv -> RC(.)O + R.'
!      jlabel3(j) = 'PHOT  n_ketone  30200  10'
      jlabel3(j) = 'PHOT  n_ketone  30200 '


      OPEN(UNIT=kin,FILE='MCM2001/n_ketone2',
     $     STATUS='old')
      do i = 1, 4
         read(kin,*)
      enddo
      n = 95
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END

* =============================================================================
      SUBROUTINE rou24(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for C2H5COC2H5             =*
*=  photolysis:                                                              =*
*=         ketone (gamma-H + two pimary C in alpha) + hv -> Norrish II                                              =*
*=                                                                           =*
*=  Cross section:  Martinez 92                                                  =*
*=  Quantum yield:  Raber 95 (for 2-butanone)                                                  =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'n_ketone + hv -> Norrish II'
!      jlabel3(j) = 'PHOT  n_ketone  30300  10'
      jlabel3(j) = 'PHOT  n_ketone  30300 '


      OPEN(UNIT=kin,FILE='MCM2001/n_ketone3',
     $     STATUS='old')
      do i = 1, 4
         read(kin,*)
      enddo
      n = 95
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END
* =============================================================================
      SUBROUTINE rou25(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for             =*
*=  ketone photolysis:                                                              =*
*=  ketone (no gamma-H+only one primary c in alpha position)+hv -> R.+RCO.
*=                                                                           =*
*=  Cross section:  mean value between 3pentanone and
*=                    24dimethylpentanone                                                 =*
*=  Quantum yield: 2 butanone (Raber 95)                                                  =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'i_ketone (no gamma-H) + hv -> RC(.)O + R.'
!      jlabel3(j) = 'PHOT  i_ketone  30600  10'
      jlabel3(j) = 'PHOT  i_ketone  30600 '


      OPEN(UNIT=kin,FILE='MCM2001/i_ketone1',
     $     STATUS='old')
      do i = 1, 4
         read(kin,*)
      enddo
      n = 101
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END
* =============================================================================
      SUBROUTINE rou26(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for             =*
*=  ketone photolysis:                                                              =*
*=         ketone (gammaH and only one primary Calpha)+ hv -> R. + RC(.)O                                           =*
*=                                                                           =*
*=  Cross section:  mean value between 3pentanone and
*=                    24dimethylpentanone                                                 =*
*=  Quantum yield:                                                   =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'i_ketone(with gammaH) + hv -> RC(.)O + R.'
!      jlabel3(j) = 'PHOT  i_ketone  30700  10'
      jlabel3(j) = 'PHOT  i_ketone  30700 '


      OPEN(UNIT=kin,FILE='MCM2001/i_ketone2',
     $     STATUS='old')
      do i = 1, 4
         read(kin,*)
      enddo
      n = 101
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END
* =============================================================================
      SUBROUTINE rou27(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for             =*
*=  ketone photolysis:                                                              =*
*=         ketone (with gammaH)+ hv -> products                                           =*
*=                                                                           =*
*=  Cross section:  mean value between 3pentanone and
*=                    24dimethylpentanone                                                 =*
*=  Quantum yield:                                                   =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'i_ketone + hv -> Norrish II'
!      jlabel3(j) = 'PHOT  i_ketone  30800  10'
      jlabel3(j) = 'PHOT  i_ketone  30800 '


      OPEN(UNIT=kin,FILE='MCM2001/i_ketone3',
     $     STATUS='old')
      do i = 1, 4
         read(kin,*)
      enddo
      n = 101
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END
* =============================================================================
      SUBROUTINE rou28(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for             =*
*=  ketone photolysis:                                                              =*
*=         ketone (without gamma H) + hv -> products                                           =*
*=                                                                           =*
*=  Cross section:  24dimethylpentanone
*=                                                                     =*
*=  Quantum yield:   2 butanone (Raber 95)                                                =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 't_ketone (no gammaH) + hv -> RC(.)O + R.'
!      jlabel3(j) = 'PHOT  t_ketone  31100  10'
      jlabel3(j) = 'PHOT  t_ketone  31100 '


      OPEN(UNIT=kin,FILE='MCM2001/t_ketone1',
     $     STATUS='old')
      do i = 1, 4
         read(kin,*)
      enddo
      n = 131
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END
* =============================================================================
      SUBROUTINE rou29(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for             =*
*=  ketone photolysis:                                                              =*
*=         ketone + hv -> R. + RC(.)O                                           =*
*=                                                                           =*
*=  Cross section:  24dimethylpentanone   
*=                                                                    =*
*=  Quantum yield:                                                   =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 't_ketone + hv -> R. + RC(.)O'
!      jlabel3(j) = 'PHOT  t_ketone  31200  10'
      jlabel3(j) = 'PHOT  t_ketone  31200 '


      OPEN(UNIT=kin,FILE='MCM2001/t_ketone2',
     $     STATUS='old')
      do i = 1, 4
         read(kin,*)
      enddo
      n = 131
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END
* =============================================================================
      SUBROUTINE rou30(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for             =*
*=  ketone photolysis:                                                              =*
*=         ketone + hv -> products                                           =*
*=                                                                           =*
*=  Cross section:  24dimethylpentanone 
*=                                                                    =*
*=  Quantum yield:                                                   =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 't_ketone + hv -> Norrish II'
!      jlabel3(j) = 'PHOT  t_ketone  31300  10'
      jlabel3(j) = 'PHOT  t_ketone  31300 '


      OPEN(UNIT=kin,FILE='MCM2001/t_ketone3',
     $     STATUS='old')
      do i = 1, 4
         read(kin,*)
      enddo
      n = 131
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END
* =============================================================================
      SUBROUTINE rou31(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for             =*
*=  CH2=CHCOCH3 photolysis:                                                              =*
*=         CH2=CHCOCH3 + hv -> = + CO                                           =*
*=                                                                           =*
*=  Cross section:  Raber 1995                                                  =*
*=  Quantum yield:  Raber 1995                                                  =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'CH2=CHCOCH3 + hv -> = + CO'
!      jlabel3(j) = 'PHOT  CH2=CHCOCH3  31600  10 '
      jlabel3(j) = 'PHOT  CH2=CHCOCH3  31600 '


      OPEN(UNIT=kin,FILE='MCM2001/MVK1',
     $     STATUS='old')
      do i = 1, 2
         read(kin,*)
      enddo
      n = 128
    
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
	 
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END
* =============================================================================
      SUBROUTINE rou32(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for             =*
*=  CH2=CHCOCH3 photolysis:                                                              =*
*=         CH2=CHCOCH3 + hv ->  =. + RC(.)O                                           =*
*=                                                                           =*
*=  Cross section:  Raber 1995                                                  =*
*=  Quantum yield:  Raber 1995                                                  =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'CH2=CHCOCH3 + hv -> =. + RC(.)O'
!      jlabel3(j) = 'PHOT  CH2=CHCOCH3  31700  10'
      jlabel3(j) = 'PHOT  CH2=CHCOCH3  31700 '


      OPEN(UNIT=kin,FILE='MCM2001/MVK2',
     $     STATUS='old')
      do i = 1, 2
         read(kin,*)
      enddo
      n = 128
    
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
	 
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END

* =============================================================================
      SUBROUTINE rou33(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for             =*
*=  CH3COCOCH3 photolysis:                                                              =*
*=         CH3COCOCH3 + hv -> 2 CH3CO.                                           =*
*=                                                                           =*
*=  Cross section:  Plum 83                                                   =*
*=  Quantum yield:  SAPRC 99                                                  =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'CH3COCOCH3 + hv -> 2 CH3CO.'
!      jlabel3(j) = 'PHOT  CH3COCOCH3  31800  10'
      jlabel3(j) = 'PHOT  CH3COCOCH3  31800 '


      OPEN(UNIT=kin,FILE='MCM2001/BACL_ADJ.PHD',
     $     STATUS='old')
      do i = 1, 6
         read(kin,*)
      enddo
      n = 98
    
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
	 
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END
* =============================================================================
      SUBROUTINE rou34(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for             =*
*=  OHCH2COCH3 photolysis:                                                              =*
*=         OHCH2COCH3 + hv -> products                                           =*
*=                                                                           =*
*=  Cross section:  Orlando 99                                                   =*
*=  Quantum yield:                                                  =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'OHCH2COR + hv -> RC(.)O + C(OH)(.)H2'
!      jlabel3(j) = 'PHOT  OHCH2COR  31900  10'
      jlabel3(j) = 'PHOT  OHCH2COR  31900 '


      OPEN(UNIT=kin,FILE='MCM2001/hydroxyacetone_rdt1',
     $     STATUS='old')
      do i = 1, 3
         read(kin,*)
      enddo
      n = 113
    
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
	 
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END
* =============================================================================
      SUBROUTINE rou35(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for             =*
*=  Pyruvic Acid photolysis:                                                              =*
*=         RC(O)COOH + hv -> RCHO + CO2                                           =*
*=                                                                           =*
*=  Cross section:  Moortgat 99                                                =*
*=  Quantum yield:  Moortgat 99                                                =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'RC(O)COOH + hv -> RCHO + CO2'
!      jlabel3(j) = 'PHOT  RC(O)COOH  32100  10'
      jlabel3(j) = 'PHOT  RC(O)COOH  32100 '


      OPEN(UNIT=kin,FILE='MCM2001/Pyruvic.prn',
     $     STATUS='old')
      do i = 1, 2
         read(kin,*)
      enddo
      n = 152  !150
    
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
	 
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END
      
*			OTHER STRUCTURES      
* =============================================================================
      SUBROUTINE rou36(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for             =*
*=  CH3OOH photolysis:                                                              =*
*=         CH3OOH + hv -> CH3O.+ OH.                                           =*
*=                                                                           =*
*=  Cross section:  IUPAC99                                                   =*
*=  Quantum yield:  IUPAC99                                                =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'CH3OOH + hv -> CH3O.+ OH.'
!      jlabel3(j) = 'PHOT  CH3OOH  40100  10'
      jlabel3(j) = 'PHOT  CH3OOH  40100 '


      OPEN(UNIT=kin,FILE='MCM2001/CH3OOH.prn',
     $     STATUS='old')
      do i = 1, 3
         read(kin,*)
      enddo
      n = 35  !33
    
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
	 
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END
* =============================================================================
      SUBROUTINE rou37(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for             =*
*=  RC(O)CR=CRCHO photolysis:                                                              =*
*=        HC(O)CR=CRCHO + hv -> 3H-furan-2-one                                           =*
*=                                                                           =*
*=  Cross section:  trans-butenedial (Bierbach 94)                                                   =*
*=  Quantum yield:  trans-butenedial (Bierbach 94)                                                =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'RC(O)CR=CRCHO + hv ->3H furan-2-one'
!      jlabel3(j) = 'PHOT  RC(O)CR=CRCHO  23000  10'
      jlabel3(j) = 'PHOT  RC(O)CR=CRCHO  23000 '


      OPEN(UNIT=kin,FILE='MCM2001/butenedial1',
     $     STATUS='old')
      do i = 1, 6
         read(kin,*)
      enddo
      n = 56
    
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
	 
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END
* =============================================================================
      SUBROUTINE rou38(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for             =*
*=  RC(O)CR=CRCHO photolysis:                                                              =*
*=        HC(O)CR=CRCHO + hv -> maleic anhydride + 2 HO2.                                            =*
*=                                                                           =*
*=  Cross section:  butenedial Bierbach 94                                                   =*
*=  Quantum yield:  butenedial Bierbach 94                                                =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'RC(O)CR=CRCHO + hv ->maleic anhydride + 2 HO2. '
!      jlabel3(j) = 'PHOT  RC(O)CR=CRCHO  23100  10'
      jlabel3(j) = 'PHOT  RC(O)CR=CRCHO  23100 '


      OPEN(UNIT=kin,FILE='MCM2001/butenedial2',
     $     STATUS='old')
      do i = 1, 6
         read(kin,*)
      enddo
      n = 56
    
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
	 
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END
* =============================================================================
      SUBROUTINE rou39(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for             =*
*=  RC(O)CR=CRCHO photolysis:                                                              =*
*=        RC(O)CR=CRCHO + hv -> 5methyl-3H-furan-2-one                                           =*
*=                                                                           =*
*=  Cross section:  4 oxo2pentenal Bierbach 94                                                   =*
*=  Quantum yield:  4 oxo2pentenal Bierbach 94                                                =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'RaC(O)CR=CRCHO + hv -> 5(Ra)-3H-furan-2-one'
!      jlabel3(j) = 'PHOT  RC(O)CR=CRCHO  23200  10'
      jlabel3(j) = 'PHOT  RC(O)CR=CRCHO  23200 '


      OPEN(UNIT=kin,FILE='MCM2001/4oxo2pentenal1',
     $     STATUS='old')
      do i = 1, 6
         read(kin,*)
      enddo
      n = 56
    
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
	 
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END
* =============================================================================
      SUBROUTINE rou40(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for             =*
*=  RC(O)CR=CRCHO photolysis:                                                              =*
*=        RC(O)CR=CRCHO + hv -> maleic anhydride + HO2. + R.                                           =*
*=                                                                           =*
*=  Cross section:  4 oxo 2 pentenal Bierbach 94                                                   =*
*=  Quantum yield:  4 oxo 2 pentenal Bierbach 94                                                =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'RC(O)CR=CRCHO + hv ->maleic anhydride + HO2. + R.'
!      jlabel3(j) = 'PHOT  RC(O)CR=CRCHO  23300  10'
      jlabel3(j) = 'PHOT  RC(O)CR=CRCHO  23300 '


      OPEN(UNIT=kin,FILE='MCM2001/4oxo2pentenal2',
     $     STATUS='old')
      do i = 1, 6
         read(kin,*)
      enddo
      n = 56
    
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
	 
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END
* =============================================================================
      SUBROUTINE rou41(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for             =*
*=  RC(O)CR=CRCHO photolysis:                                                              =*
*=        RC(O)CR=CRC(O)R + hv -> 4oxo2pentenal + R.                                           =*
*=                                                                           =*
*=  Cross section:  4 oxo 2 pentenal Bierbach 94                                                   =*
*=  Quantum yield:  4 oxo 2 pentenal Bierbach 94                                                =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'RC(O)CR=CRC(O)R + hv -> 4 oxo pentenal + R.'
!      jlabel3(j) = 'PHOT  RC(O)CR=CRC(O)R  23400  10'
      jlabel3(j) = 'PHOT  RC(O)CR=CRC(O)R  23400 '


      OPEN(UNIT=kin,FILE='MCM2001/3hexene25dione1',
     $     STATUS='old')
      do i = 1, 6
         read(kin,*)
      enddo
      n = 56
    
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
	 
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END
* =============================================================================
      SUBROUTINE rou42(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for             =*
*=  RC(O)CR=CRC(O)R photolysis:                                                              =*
*=        RC(O)CR=CRC(O)R + hv -> maleic anhydride + R. + R.                                           =*
*=                                                                           =*
*=  Cross section:  3 hexene2.5dione Bierbach 94                                                   =*
*=  Quantum yield:  3 hexene2.5dione Bierbach 94                                                =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'RC(O)CR=CRC(O)R + hv ->maleic anhydride + R. + R.'
!      jlabel3(j) = 'PHOT  RC(O)CR=CRC(O)R  23500  10'
      jlabel3(j) = 'PHOT  RC(O)CR=CRC(O)R  23500 '


      OPEN(UNIT=kin,FILE='MCM2001/3hexene25dione2',
     $     STATUS='old')
      do i = 1, 6
         read(kin,*)
      enddo
      n = 56
    
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
	 
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END
