*     DIFUNCTIONAL NITRATES 

      SUBROUTINE rdn3(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)
*-----------------------------------------------------------------------------*
*=  PURPOSE:
*=  Provide the product (cross section) x (quantum yield) for C2H5COCH2(ONO2)
*=  photolysis (1-nitrooxy-2-butanone)
*=        C2H5COCH2(ONO2) + hv -> C2H5COCH2(O.) + NO2
*=
*=  Cross section:  Barnes, Becker, & Zhu (1993) J. Atmos. Chem. 17, 353-373
*=  Quantum yield:  None available
*-----------------------------------------------------------------------------*
*   previously named rdn1 - renamed for consistency 2018-05-04, JMLT
*   PREVIOUSLY HAD I.D. 701000, NOW = 40003 FOR CONSISTENCY WITH GENERATOR 
*-----------------------------------------------------------------------------*
*=  PARAMETERS:
*========= in ====================
*=  NW     - INTEGER, number of specified intervals + 1 in working
*=           wavelength grid
*=  WL     - REAL, vector of lower limits of wavelength intervals in
*=           working wavelength grid
*=  WC     - REAL, vector of center points of wavelength intervals in
*=           working wavelength grid
*=  NZ     - INTEGER, number of altitude levels in working altitude grid
*=  TLEV   - REAL, temperature (K) at each specified altitude level
*=  AIRLEV - REAL, air density (molec/cc) at each altitude level
*========= in/out ====================
*=  J      - INTEGER, counter for number of weighting functions defined
*========= out ====================
*=  SQ     - REAL, cross section x quantum yield (cm^2) for each
*=           photolysis reaction defined, at each defined wavelength and
*=           at each defined altitude level
*=  JLABEL - CHARACTER*40, string identifier for each photolysis reaction 
*=           defined
*-----------------------------------------------------------------------------*
*=  EDIT HISTORY:
*=  01/08  Original, adapted from former JSPEC1 subroutine
*-----------------------------------------------------------------------------*
*= This program is free software;  you can redistribute it and/or modify
*= it under the terms of the GNU General Public License as published by the
*= Free Software Foundation;  either version 2 of the license, or (at your 
*= option) any later version.
*= The TUV package is distributed in the hope that it will be useful, but 
*= WITHOUT ANY WARRANTY;  without even the implied warranty of *MERCHANTIBI-
*= LITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
*= License for more details.
*= To obtain a copy of the GNU General Public License, write to:
*= Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input
      INTEGER nw
      REAL wl(kw), wc(kw)
      INTEGER nz
      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions
      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:
      INTEGER j

* data arrays
      INTEGER kdata
      PARAMETER(kdata=580)
      INTEGER i,ii, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
*ba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local
      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw
      INTEGER mabs, myld

* input file parameters
      INTEGER nhdr,nlin,ncol ! # header lines, # total lines, # irrelevant columns
      PARAMETER(nhdr=20)
      PARAMETER(nlin=33)
      PARAMETER(ncol=6)
      REAL tmpdat(ncol)
      LOGICAL qyflg          ! is QY known?
      qyflg = .FALSE.
     
      j = j+1
      jlabel(j) = 'C2H5COCH2(ONO2) + hv -> C2H5COCH2(O.) + NO2'
!      jlabel3(j) = 'PHOT  C2H5COCH2(ONO2)  70100  10'
!      jlabel3(j) = 'PHOT  C2H5COCH2(ONO2)  70100 '
! new label for consistency with generator, 2018-05-04
      jlabel3(j) = 'PHOT  C2H5COCH2(ONO2)  40003 '

      OPEN(UNIT=kin,FILE='DATAJ2/difun_nitrates_Barnes93.abs',
     $     STATUS='old')
      do i = 1, nhdr
         read(kin,*)
      enddo

* store the number of data
      n = nlin-nhdr
      n1=n
      DO i = 1, n
         READ(kin,*) x1(i), (tmpdat(ii),ii=1,ncol), y1(i)
         !x2(i) = x1(i)
         y1(i) = y1(i)*1e-20
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields
      IF(qyflg)THEN
        CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
        CALL addpnt(x2,y2,kdata,n1,               0.,0.)
        CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
        CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
        CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
        IF (ierr .NE. 0) THEN
           WRITE(*,*) ierr, jlabel(j)
           STOP
        ENDIF
      ELSE
! assume unity QY if none in file
        DO iw = 1, nw - 1
          yg1(iw) = 1.0
        ENDDO
      ENDIF

* combine x-section and QY:
      DO iw = 1, nw - 1
         DO i = 1, nz
            sig = yg(iw)
            qy1 = yg1(iw)
            sq(j  ,i,iw) = sig * qy1
         ENDDO
      ENDDO

      END

*-----------------------------------------------------------------------------*
      SUBROUTINE rdn2(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)
*-----------------------------------------------------------------------------*
*=  PURPOSE:
*=  Provide the product (cross section) x (quantum yield) for C2H4(ONO2)COCH3
*=  photolysis (3-nitrooxy-2-butanone)
*=        C2H4(ONO2)COCH3 + hv -> C2H4(O.)COCH3 + NO2
*=
*=  Cross section:  Barnes, Becker, & Zhu (1993) J. Atmos. Chem. 17, 353-373
*=  Quantum yield:  None available
*-----------------------------------------------------------------------------*
*   PREVIOUSLY HAD I.D. 702000, NOW = 40002 FOR CONSISTENCY WITH GENERATOR 
*-----------------------------------------------------------------------------*
*=  PARAMETERS:
*========= in ====================
*=  NW     - INTEGER, number of specified intervals + 1 in working
*=           wavelength grid
*=  WL     - REAL, vector of lower limits of wavelength intervals in
*=           working wavelength grid
*=  WC     - REAL, vector of center points of wavelength intervals in
*=           working wavelength grid
*=  NZ     - INTEGER, number of altitude levels in working altitude grid
*=  TLEV   - REAL, temperature (K) at each specified altitude level
*=  AIRLEV - REAL, air density (molec/cc) at each altitude level
*========= in/out ====================
*=  J      - INTEGER, counter for number of weighting functions defined
*========= out ====================
*=  SQ     - REAL, cross section x quantum yield (cm^2) for each
*=           photolysis reaction defined, at each defined wavelength and
*=           at each defined altitude level
*=  JLABEL - CHARACTER*40, string identifier for each photolysis reaction 
*=           defined
*-----------------------------------------------------------------------------*
*=  EDIT HISTORY:
*=  01/08  Original, adapted from former JSPEC1 subroutine
*-----------------------------------------------------------------------------*
*= This program is free software;  you can redistribute it and/or modify
*= it under the terms of the GNU General Public License as published by the
*= Free Software Foundation;  either version 2 of the license, or (at your 
*= option) any later version.
*= The TUV package is distributed in the hope that it will be useful, but 
*= WITHOUT ANY WARRANTY;  without even the implied warranty of *MERCHANTIBI-
*= LITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
*= License for more details.
*= To obtain a copy of the GNU General Public License, write to:
*= Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input
      INTEGER nw
      REAL wl(kw), wc(kw)
      INTEGER nz
      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions
      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:
      INTEGER j

* data arrays
      INTEGER kdata
      PARAMETER(kdata=580)
      INTEGER i,ii, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
*ba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local
      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw
      INTEGER mabs, myld

* input file parameters
      INTEGER nhdr,nlin,ncol ! # header lines, # total lines, # irrelvant columns 
      PARAMETER(nhdr=20)
      PARAMETER(nlin=33)
      PARAMETER(ncol=7)
      REAL tmpdat(ncol)
      LOGICAL qyflg          ! is QY known?
      qyflg = .FALSE.
     
      j = j+1
      jlabel(j) = 'C2H4(ONO2)COCH3 + hv -> C2H4(O.)COCH3 + NO2'
!      jlabel3(j) = 'PHOT  C2H5(ONO2)COCH3  70200  10'
!      jlabel3(j) = 'PHOT  C2H4(ONO2)COCH3  70200 '
! new label for consistency with generator, 2018-05-04
      jlabel3(j) = 'PHOT  C2H4(ONO2)COCH3  40002 '

      OPEN(UNIT=kin,FILE='DATAJ2/difun_nitrates_Barnes93.abs',
     $     STATUS='old')
      do i = 1, nhdr
         read(kin,*)
      enddo

* store the number of data
      n = nlin-nhdr
      n1=n
      DO i = 1, n
         READ(kin,*) x1(i), (tmpdat(ii),ii=1,ncol), y1(i)
         !x2(i) = x1(i)
         y1(i) = y1(i) * 1e-20
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields
      IF(qyflg)THEN
        CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
        CALL addpnt(x2,y2,kdata,n1,               0.,0.)
        CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
        CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
        CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
        IF (ierr .NE. 0) THEN
           WRITE(*,*) ierr, jlabel(j)
           STOP
        ENDIF
      ELSE
! assume unity QY if none in file
        DO iw = 1, nw - 1
          yg1(iw) = 1.0
        ENDDO
      ENDIF

* combine x-section and QY:
      DO iw = 1, nw - 1
         DO i = 1, nz
            sig = yg(iw)
            qy1 = yg1(iw)
            sq(j  ,i,iw) = sig * qy1
         ENDDO
      ENDDO

      END

*-----------------------------------------------------------------------------*
      SUBROUTINE rdn1(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)
*-----------------------------------------------------------------------------*
*=  PURPOSE:
*=  Provide the product (cross section) x (quantum yield) for
*=  CH3COCH2(ONO2) photolysis (a-nitrooxy-acetone)
*=
*=  Cross section:  Barnes, Becker, & Zhu (1993) J. Atmos. Chem. 17, 353-373
*=  Quantum yield:  None available
*-----------------------------------------------------------------------------*
* previously named rdn3 - renamed for consistency 2018-05-04, JMLT
*-----------------------------------------------------------------------------*
*=  PARAMETERS:
*========= in ====================
*=  NW     - INTEGER, number of specified intervals + 1 in working
*=           wavelength grid
*=  WL     - REAL, vector of lower limits of wavelength intervals in
*=           working wavelength grid
*=  WC     - REAL, vector of center points of wavelength intervals in
*=           working wavelength grid
*=  NZ     - INTEGER, number of altitude levels in working altitude grid
*=  TLEV   - REAL, temperature (K) at each specified altitude level
*=  AIRLEV - REAL, air density (molec/cc) at each altitude level
*========= in/out ====================
*=  J      - INTEGER, counter for number of weighting functions defined
*========= out ====================
*=  SQ     - REAL, cross section x quantum yield (cm^2) for each
*=           photolysis reaction defined, at each defined wavelength and
*=           at each defined altitude level
*=  JLABEL - CHARACTER*40, string identifier for each photolysis reaction 
*=           defined
*-----------------------------------------------------------------------------*
*=  EDIT HISTORY:
*=  01/08  Original, adapted from former JSPEC1 subroutine
*-----------------------------------------------------------------------------*
*= This program is free software;  you can redistribute it and/or modify
*= it under the terms of the GNU General Public License as published by the
*= Free Software Foundation;  either version 2 of the license, or (at your 
*= option) any later version.
*= The TUV package is distributed in the hope that it will be useful, but 
*= WITHOUT ANY WARRANTY;  without even the implied warranty of *MERCHANTIBI-
*= LITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
*= License for more details.
*= To obtain a copy of the GNU General Public License, write to:
*= Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input
      INTEGER nw
      REAL wl(kw), wc(kw)
      INTEGER nz
      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions
      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:
      INTEGER j

* data arrays
      INTEGER kdata
      PARAMETER(kdata=580)
      INTEGER i,ii, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
*ba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local
      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw
      INTEGER mabs, myld

* input file parameters
      INTEGER nhdr,nlin,ncol ! # header lines, # total lines, # irrelvant columns 
      PARAMETER(nhdr=20)
      PARAMETER(nlin=33)
      PARAMETER(ncol=5)
      REAL tmpdat(ncol)
      LOGICAL qyflg          ! is QY known?
      qyflg = .FALSE.
     
      j = j+1
      jlabel(j) = 'CH3COCH2(ONO2) + hv' 
      jlabel3(j) = 'PHOT  CH3COCH2(ONO2) 40001 '

      OPEN(UNIT=kin,FILE='DATAJ2/difun_nitrates_Barnes93.abs',
     $     STATUS='old')
      do i = 1, nhdr
         read(kin,*)
      enddo

* store the number of data
      n = nlin-nhdr
      n1=n
      DO i = 1, n
         READ(kin,*) x1(i), (tmpdat(ii),ii=1,ncol), y1(i)
         !x2(i) = x1(i)
         y1(i) = y1(i) * 1e-20
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields
      IF(qyflg)THEN
        CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
        CALL addpnt(x2,y2,kdata,n1,               0.,0.)
        CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
        CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
        CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
        IF (ierr .NE. 0) THEN
           WRITE(*,*) ierr, jlabel(j)
           STOP
        ENDIF
      ELSE
! assume unity QY if none in file
        DO iw = 1, nw - 1
          yg1(iw) = 1.0
        ENDDO
      ENDIF

* combine x-section and QY:
      DO iw = 1, nw - 1
         DO i = 1, nz
            sig = yg(iw)
            qy1 = yg1(iw)
            sq(j  ,i,iw) = sig * qy1
         ENDDO
      ENDDO

      END

*-----------------------------------------------------------------------------*
