      SUBROUTINE ro1(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for CH3ONO2             =*
*=  photolysis:                                                              =*
*=         CH3ONO2 + hv ->  CH3O. + NO2                                               =*
*=                                                                           =*
*=  Cross section:  IUPAC99                                                  =*
*=  Quantum yield:  IUPAC99                                                  =*
*-----------------------------------------------------------------------------*
*=  PARAMETERS:                                                              =*
*=  NW     - INTEGER, number of specified intervals + 1 in working        (I)=*
*=           wavelength grid                                                 =*
*=  WL     - REAL, vector of lower limits of wavelength intervals in      (I)=*
*=           working wavelength grid                                         =*
*=  WC     - REAL, vector of center points of wavelength intervals in     (I)=*
*=           working wavelength grid                                         =*
*=  NZ     - INTEGER, number of altitude levels in working altitude grid  (I)=*
*=  TLEV   - REAL, temperature (K) at each specified altitude level       (I)=*
*=  AIRLEV - REAL, air density (molec/cc) at each altitude level          (I)=*
*=  J      - INTEGER, counter for number of weighting functions defined  (IO)=*
*=  SQ     - REAL, cross section x quantum yield (cm^2) for each          (O)=*
*=           photolysis reaction defined, at each defined wavelength and     =*
*=           at each defined altitude level                                  =*
*=  JLABEL - CHARACTER*40, string identifier for each photolysis reaction (O)=*
*=           defined                                                         =*
*-----------------------------------------------------------------------------*
*=  EDIT HISTORY:                                                            =*
*=  05/98  Original, adapted from former JSPEC1 subroutine                   =*
*-----------------------------------------------------------------------------*
*= This program is free software;  you can redistribute it and/or modify     =*
*= it under the terms of the GNU General Public License as published by the  =*
*= Free Software Foundation;  either version 2 of the license, or (at your   =*
*= option) any later version.                                                =*
*= The TUV package is distributed in the hope that it will be useful, but    =*
*= WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHANTIBI-  =*
*= LITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public     =*
*= License for more details.                                                 =*
*= To obtain a copy of the GNU General Public License, write to:             =*
*= Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.   =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'CH3ONO2 -> CH3O. + NO2'
      !jlabel3(j) = 'PHOT  CH3ONO2  100  10'
      jlabel3(j) = 'PHOT  CH3ONO2  100 '


      OPEN(UNIT=kin,FILE='MCM2001/methylnitrate.prn',
     $     STATUS='old')
      do i = 1, 2
         read(kin,*)
      enddo
      n = 23
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO
           
      END


* =============================================================================
      SUBROUTINE ro2(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for C2H5ONO2             =*
*=  photolysis:                                                              =*
*=         C2H5ONO2 + hv -> C2H5O. + NO2                                                =*
*=                                                                           =*
*=  Cross section:  IUPAC99                                                  =*
*=  Quantum yield:  IUPAC99                                                   =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'C2H5ONO2 + hv -> C2H5O. + NO2'
      !jlabel3(j) = 'PHOT  C2H5ONO2  200  10'
      jlabel3(j) = 'PHOT  C2H5ONO2  200 '


      OPEN(UNIT=kin,FILE='MCM2001/ethylnitrate.prn',
     $     STATUS='old')
      do i = 1, 2
         read(kin,*)
      enddo
      n = 35
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END


* =============================================================================
      SUBROUTINE ro3(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for n_C3H7ONO2             =*
*=  photolysis:                                                              =*
*=         n_C3H7ONO2 + hv -> n_C3H7O. + NO2                                               =*
*=                                                                           =*
*=  Cross section:  IUPAC99                                                  =*
*=  Quantum yield:  IUPAC99                                                   =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'n_C3H7ONO2 + hv -> n_C3H7O. + NO2'
!      jlabel3(j) = 'PHOT  C3H7ONO2  300  10'
      jlabel3(j) = 'PHOT  C3H7ONO2  300 '


      OPEN(UNIT=kin,FILE='MCM2001/n_propylnitrate.prn',
     $     STATUS='old')
      do i = 1, 2
         read(kin,*)
      enddo
      n = 43
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END


* =============================================================================
      SUBROUTINE ro4(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for i_C3H7ONO2             =*
*=  photolysis:                                                              =*
*=         i_C3H7ONO2 + hv -> i_C3H7O. + NO2                                              =*
*=                                                                           =*
*=  Cross section:  IUPAC99                                                  =*
*=  Quantum yield:  IUPAC99                                                  =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'i_C3H7ONO2 + hv -> i_C3H7O. + NO2'
!      jlabel3(j) = 'PHOT  C3H7ONO2  400  10'
      jlabel3(j) = 'PHOT  C3H7ONO2  400 '


      OPEN(UNIT=kin,FILE='MCM2001/ipropylnitrate.prn',
     $     STATUS='old')
      do i = 1, 2
         read(kin,*)
      enddo
      n = 36
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END


* =============================================================================
      SUBROUTINE ro5(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for 1_C4H9ONO2             =*
*=  photolysis:                                                              =*
*=         1_C4H9ONO2 + hv -> 1_C4H9O. + NO2                                               =*
*=                                                                           =*
*=  Cross section:  IUPAC99                                                  =*
*=  Quantum yield:  IUPAC99                                                 =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = '1_C4H9ONO2 + hv -> 1_C4H9O. + NO2'
!      jlabel3(j) = 'PHOT  C4H9ONO2  500  10'
      jlabel3(j) = 'PHOT  C4H9ONO2  500 '


      OPEN(UNIT=kin,FILE='MCM2001/1butylnitrate.prn',
     $     STATUS='old')
      do i = 1, 2
         read(kin,*)
      enddo
      n = 48
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END


* =============================================================================
      SUBROUTINE ro6(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for 2_C4H9ONO2             =*
*=  photolysis:                                                              =*
*=         2_C4H9ONO2 + hv -> 2_C4H9O. + NO2                                               =*
*=                                                                           =*
*=  Cross section:  IUPAC99                                                  =*
*=  Quantum yield:  IUPAC99                                                  =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = '2_C4H9ONO2 + hv -> 2_C4H9O. + NO2'
!      jlabel3(j) = 'PHOT  C4H9ONO2  600  10'
      jlabel3(j) = 'PHOT  C4H9ONO2  600 '


      OPEN(UNIT=kin,FILE='MCM2001/2butylnitrate.prn',
     $     STATUS='old')
      do i = 1, 2
         read(kin,*)
      enddo
      n = 20
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END


* =============================================================================
      SUBROUTINE ro7(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for tert_C4H9ONO2             =*
*=  photolysis:                                                              =*
*=         tert_C4H9ONO2 + hv -> tert_C4H9O. + NO2                                            =*
*=                                                                           =*
*=  Cross section:  Roberts 89                                                  =*
*=  Quantum yield:  Roberts 89                                                =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'tert_C4H9ONO2 + hv -> tert_C4H9O. + NO2'
!      jlabel3(j) = 'PHOT  C4H9ONO2 700  10'
      jlabel3(j) = 'PHOT  C4H9ONO2 700 '


      OPEN(UNIT=kin,FILE='MCM2001/tertbutyl.prn',
     $     STATUS='old')
      do i = 1, 3
         read(kin,*)
      enddo
      n = 19
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END


* =============================================================================
      SUBROUTINE ro8(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for 1_C5H11ONO2             =*
*=  photolysis:                                                              =*
*=         1_C5H11ONO2 + hv -> 1_C5H11H9O. + NO2                                             =*
*=                                                                           =*
*=  Cross section:  Zhu 97                                                  =*
*=  Quantum yield:  Zhu 97                                                  =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = '1_C5H11ONO2 + hv -> 1_C5H11H9O. + NO2'
!      jlabel3(j) = 'PHOT  C5H11ONO2  800  10'
      jlabel3(j) = 'PHOT  C5H11ONO2  800 '


      OPEN(UNIT=kin,FILE='MCM2001/npentylnitrate.prn',
     $     STATUS='old')
      do i = 1, 2
         read(kin,*)
      enddo
      n = 20
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END


* =============================================================================
      SUBROUTINE ro9(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for 2_C5H11ONO2             =*
*=  photolysis:                                                              =*
*=         2_C5H11ONO2 + hv -> 2_C5H11H9O. + NO2                             =*
*=  Cross section:  Roberts 89                                                  =*
*=  Quantum yield:  Roberts 89                                                  =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = '2_C5H11ONO2 + hv -> 2_C5H11H9O. + NO2'
!      jlabel3(j) = 'PHOT  2_C5H11ONO2  900  10'
      jlabel3(j) = 'PHOT  2_C5H11ONO2  900 '


      OPEN(UNIT=kin,FILE='MCM2001/2_pentylN.prn',
     $     STATUS='old')
      do i = 1, 3
         read(kin,*)
      enddo
      n = 17
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END


* =============================================================================
      SUBROUTINE ro10(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for 3_C5H11ONO2             =*
*=  photolysis:                                                              =*
*=         3_C5H11ONO2 + hv -> 3_C5H11H9O. + NO2                                             =*
*=                                                                           =*
*=  Cross section:  Roberts 89                                                 =*
*=  Quantum yield:  Roberts 89                                                  =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = '3_C5H11ONO2 + hv -> 3_C5H11H9O. + NO2'
!      jlabel3(j) = 'PHOT  3_C5H11ONO2 1000 10'
      jlabel3(j) = 'PHOT  3_C5H11ONO2 1000 '


      OPEN(UNIT=kin,FILE='MCM2001/3_pentylN.prn',
     $     STATUS='old')
      do i = 1, 3
         read(kin,*)
      enddo
      n = 17
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END




* =============================================================================
      SUBROUTINE ro11(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for 2methyl1propylnitrate             =*
*=  photolysis:                                                              =*
*=         2methyl1propylnitrate + hv -> RO. + NO2                                             =*
*=                                                                           =*
*=  Cross section:  Clemitshaw 97                                                  =*
*=  Quantum yield:  Clemitshaw 97                                                  =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = '2methyl1propylnitrate + hv -> RO. + NO2'
!      jlabel3(j) = 'PHOT  2methyl1propylnitrate 1100  10'
      jlabel3(j) = 'PHOT  2methyl1propylnitrate 1100 '


      OPEN(UNIT=kin,FILE='MCM2001/2methyl1propylnitrate.prn',
     $     STATUS='old')
      do i = 1, 2
         read(kin,*)
      enddo
      n = 33
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END




* =============================================================================
      SUBROUTINE ro12(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for CH3OONO2             =*
*=  photolysis:                                                              =*
*=         CH3OONO2 + hv -> CH3OO. + NO2                                             =*
*=                                                                           =*
*=  Cross section:  IUPAC99                                                  =*
*=  Quantum yield:  no data  (0.5 for each channel)                                                  =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'CH3OONO2 + hv -> CH3OO. + NO2'
!      jlabel3(j) = 'PHOT  CH3OONO2  1200  10'
      jlabel3(j) = 'PHOT  CH3OONO2  1200 '


      OPEN(UNIT=kin,FILE='MCM2001/CH3O2NO2.prn',
     $     STATUS='old')
      do i = 1, 3
         read(kin,*)
      enddo
      n = 47
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END
* =============================================================================
      SUBROUTINE ro13(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for CH3OONO2             =*
*=  photolysis:                                                              =*
*=         CH3OONO2 + hv -> CH3O. + NO3.                                             =*
*=                                                                           =*
*=  Cross section:  IUPAC99                                                  =*
*=  Quantum yield:  no data  (0.5 for each channel)                                                  =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'CH3OONO2 + hv -> CH3O. + NO3.'
!      jlabel3(j) = 'PHOT  CH3OONO2 1300  10'
      jlabel3(j) = 'PHOT  CH3OONO2 1300  '


      OPEN(UNIT=kin,FILE='MCM2001/CH3O2NO2.prn',
     $     STATUS='old')
      do i = 1, 3
         read(kin,*)
      enddo
      n = 47
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END




* =============================================================================
      SUBROUTINE ro14(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for PAN             =*
*=  photolysis:                                                              =*
*=         PAN + hv -> CH3C(O)OO. + NO2                                         =*
*=                                                                           =*
*=  Cross section:  IUPAC99                                                  =*
*=  Quantum yield:  IUPAC99                                                  =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'PAN + hv -> CH3C(O)OO. + NO2'
!      jlabel3(j) = 'PHOT  PAN  1400  10'
      jlabel3(j) = 'PHOT  PAN  1400  '


      OPEN(UNIT=kin,FILE='MCM2001/PAN.prn',
     $     STATUS='old')
      do i = 1, 2
         read(kin,*)
      enddo
      n = 88
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END



* =============================================================================
      SUBROUTINE ro17(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for CH3CHO             =*
*=  photolysis:                                                              =*
*=         CH3CHO + hv -> CH3. + CHO.                                         =*
*=                                                                           =*
*=  Cross section:  IUPAC99                                                  =*
*=  Quantum yield:  IUPAC99                                                 =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'CH3CHO + hv -> CH3. + CHO.'
!      jlabel3(j) = 'PHOT  CH3CHO  1700  10'
      jlabel3(j) = 'PHOT  CH3CHO  1700  '


      OPEN(UNIT=kin,FILE='MCM2001/acetal_R.prn',
     $     STATUS='old')
      do i = 1, 3
         read(kin,*)
      enddo
      n = 106
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END





* =============================================================================
      SUBROUTINE ro18(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for C2H5CHO             =*
*=  photolysis:                                                              =*
*=         C2H5CHO + hv -> C2H5. + CHO.                                 =*
*=                                                                           =*
*=  Cross section:  IUPAC99                                                  =*
*=  Quantum yield:  IUPAC99                                                   =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'C2H5CHO + hv -> C2H5. + CHO.'
!      jlabel3(j) = 'PHOT  C2H5CHO  1800  10'
      jlabel3(j) = 'PHOT  C2H5CHO  1800  '


      OPEN(UNIT=kin,FILE='MCM2001/propanal.prn',
     $     STATUS='old')
      do i = 1, 3
         read(kin,*)
      enddo
      n = 113   !99
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END

* =============================================================================
      SUBROUTINE ro19(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for O3             =*
*=  photolysis:                                                              =*
*=         n-C3H7CHO + hv ->  n-C3H7. +  CHO.                                          =*
*=                                                                           =*
*=  Cross section:  Martinez 92                                                  =*
*=  Quantum yield:  Moortgat 99                                                  =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'n-C3H7CHO + hv -> n-C3H7. +  CHO.'
!      jlabel3(j) = 'PHOT  n_C3H7CHO  1900  10'
      jlabel3(j) = 'PHOT  n_C3H7CHO  1900  '


      OPEN(UNIT=kin,FILE='MCM2001/n_butyraldehyde_rad',
     $     STATUS='old')
      do i = 1, 3
         read(kin,*)
      enddo
      n = 106
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END
* =============================================================================
      SUBROUTINE ro20(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for O3             =*
*=  photolysis:                                                              =*
*=         n-C3H7CHO + hv -> C2H4 + CH3CHO  
*=                                                                                 =*
*=                                                                           =*
*=  Cross section:  Martinez 92                                                  =*
*=  Quantum yield:  Moortgat 99                                                  =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'n-C3H7CHO + hv -> C2H4 + CH3CHO Norrish II' 
!      jlabel3(j) = 'PHOT  n_C3H7CHO  2000  10'
      jlabel3(j) = 'PHOT  n_C3H7CHO  2000  '


      OPEN(UNIT=kin,FILE='MCM2001/n_butyraldehyde_mol',
     $     STATUS='old')
      do i = 1, 3
         read(kin,*)
      enddo
      n = 106
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END




* =============================================================================
      SUBROUTINE ro21(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for i-C3H7CHO             =*
*=  photolysis:                                                              =*
*=         i-C3H7CHO + hv -> C3H7. + CHO.                                              =*
*=                                                                           =*
*=  Cross section:  Desai 86                                                  =*
*=  Quantum yield:  Desai 86                                                  =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'i-C3H7CHO + hv -> C3H7. + CHO.'
!      jlabel3(j) = 'PHOT  i_C3H7CHO  2100 10'
      jlabel3(j) = 'PHOT  i_C3H7CHO  2100 '


      OPEN(UNIT=kin,FILE='MCM2001/i_butyraldehyde_R.prn',
     $     STATUS='old')
      do i = 1, 3
         read(kin,*)
      enddo
      n = 101
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END




* =============================================================================
      SUBROUTINE ro23(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for nC4H9CHO             =*
*=  photolysis:                                                              =*
*=         nC4H9CHO + hv -> C4H9. +  CHO.                                               =*
*=                                                                          =*
*=  Cross section:  ZHU 99                                                  =*
*=  Quantum yield:  Zhu 99                                                  =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'nC4H9CHO + hv -> C4H9. +  CHO.'
!      jlabel3(j) = 'PHOT  nC4H9CHO  2300  10'
      jlabel3(j) = 'PHOT  nC4H9CHO  2300  '


      OPEN(UNIT=kin,FILE='MCM2001/n_pentanal_rad',
     $     STATUS='old')
      do i = 1, 3
         read(kin,*)
      enddo
      n = 23
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END
* =============================================================================
      SUBROUTINE ro24(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for nC4H9CHO             =*
*=  photolysis:                                                              =*
*=         nC4H9CHO + hv ->  CH3CHO + CH2=CHCH3                                              =*
*=                                                                          =*
*=  Cross section:  ZHU 99                                                  =*
*=  Quantum yield:  Moortgat 99                                                  =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'nC4H9CHO + hv -> HCO. '
!      jlabel3(j) = 'PHOT  nC4H9CHO  2400  10'
      jlabel3(j) = 'PHOT  nC4H9CHO  2400  '


      OPEN(UNIT=kin,FILE='MCM2001/n_pentanal_Norrish',
     $     STATUS='old')
      do i = 1, 3
         read(kin,*)
      enddo
      n = 23
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END





* =============================================================================
      SUBROUTINE ro25(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for iC4H9CHO             =*
*=  photolysis:                                                              =*
*=  iC4H9CHO + hv -> C4H9. + CHO.                                        =*
*=                                                                           =*
*=  Cross section:  Zhu 99                                                  =*
*=  Quantum yield:  Zhu 99                                                 =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'iC4H9CHO + hv -> C4H9. + CHO.'
!      jlabel3(j) = 'PHOT  iC4H9CHO  2500  10'
      jlabel3(j) = 'PHOT  iC4H9CHO  2500  '


      OPEN(UNIT=kin,FILE='MCM2001/i_pentanal_rad',
     $     STATUS='old')
      do i = 1, 2
         read(kin,*)
      enddo
      n = 23
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END


* =============================================================================
      SUBROUTINE ro26(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for iC4H9CHO             =*
*=  photolysis:                                                              =*
*=  iC4H9CHO + hv -> CH3CHO +  CH2=CHCH3                                 =*
*=                                                                           =*
*=  Cross section:  Zhu 99                                                  =*
*=  Quantum yield: Moortgat 99 for n-pentanal (0.63*0.29)                                                  =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'iC4H9CHO + hv -> CH3CHO +  CH2=CHCH3'
!      jlabel3(j) = 'PHOT  iC4H9CHO  2600  10'
      jlabel3(j) = 'PHOT  iC4H9CHO  2600  '


      OPEN(UNIT=kin,FILE='MCM2001/i_pentanal_Norrish',
     $     STATUS='old')
      do i = 1, 3
         read(kin,*)
      enddo
      n = 23
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END




* =============================================================================
      SUBROUTINE ro27(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for t-C4H9CHO             =*
*=  photolysis:                                                              =*
*=         t-C4H9CHO + hv -> HCO. +  t-C4H9.                                             =*
*=                                                                           =*
*=  Cross section:  Zhu 99                                                  =*
*=  Quantum yield:  Zhu 99                                                  =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 't-C4H9CHO + hv -> HCO. +  t-C4H9.'
!      jlabel3(j) = 'PHOT  t_C4H9CHO  2700   10'
      jlabel3(j) = 'PHOT  t_C4H9CHO  2700   '


      OPEN(UNIT=kin,FILE='MCM2001/t_pentanal_rad',
     $     STATUS='old')
      do i = 1, 3
         read(kin,*)
      enddo
      n = 23
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END




* =============================================================================
      SUBROUTINE ro28(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for C5H11CHO             =*
*=  photolysis:                                                              =*
*=         n-C5H11CHO + hv -> HCO. + n-C5H11.                                              =*
*=                                                                           =*
*=  Cross section:  Plagens 98                                                  =*
*=  Quantum yield:  Moortgat 99                                                  =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'C5H11CHO + hv -> HCO. + n-C5H11.'
!      jlabel3(j) = 'PHOT  C5H11CHO  2800  10'
      jlabel3(j) = 'PHOT  C5H11CHO  2800  '


      OPEN(UNIT=kin,FILE='MCM2001/hexanal_rad',
     $     STATUS='old')
      do i = 1, 2
         read(kin,*)
      enddo
      n = 89
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END

* =============================================================================
      SUBROUTINE ro29(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for C5H11CHO             =*
*=  photolysis:                                                              =*
*=         n-C5H11CHO + hv -> CH3CHO + CH2=CHCH2CH3                                              =*
*=                                                                           =*
*=  Cross section:  Plagens 98                                                  =*
*=  Quantum yield:  Moortgat 99                                                  =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'C5H11CHO + hv ->CH3CHO + CH2=CHCH2CH3'
!      jlabel3(j) = 'PHOT  C5H11CHO  2900  10'
      jlabel3(j) = 'PHOT  C5H11CHO  2900  '


      OPEN(UNIT=kin,FILE='MCM2001/hexanal_norrish',
     $     STATUS='old')
      do i = 1, 2
         read(kin,*)
      enddo
      n = 89
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END



* =============================================================================
      SUBROUTINE ro30(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for acetone             =*
*=  photolysis:                                                              =*
*=         Acetone + hv -> CH3CO. + CH3.                                    =*
*=                                                                           =*
*=  Cross section:  IUPAC99                                                  =*
*=  Quantum yield:  IUPAC99                                                  =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'Acetone + hv -> CH3CO + CH3'
!      jlabel3(j) = 'PHOT  acetone  3000  10'
      jlabel3(j) = 'PHOT  acetone  3000  '


      OPEN(UNIT=kin,FILE='MCM2001/acetone.prn',
     $     STATUS='old')
      do i = 1, 2
         read(kin,*)
      enddo
      n = 96
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END




* =============================================================================
      SUBROUTINE ro31(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for CH3COC2H5             =*
*=  photolysis:                                                              =*
*=         CH3COC2H5 + hv -> C2H5. + CH3CO.                                              =*
*=                                                                           =*
*=  Cross section:  IUPAC99                                                  =*
*=  Quantum yield:  Raber et Moortgat 95 (0.34*0.85)                                                 =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'CH3COC2H5 + hv -> C2H5. + CH3CO.'
!      jlabel3(j) = 'PHOT  CH3COC2H5  3100  10'
      jlabel3(j) = 'PHOT  CH3COC2H5  3100  '


      OPEN(UNIT=kin,FILE='MCM2001/2butanone_rad1',
     $     STATUS='old')
      do i = 1, 2
         read(kin,*)
      enddo
      n = 96
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END
* =============================================================================
      SUBROUTINE ro32(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for CH3COC2H5             =*
*=  photolysis:                                                              =*
*=         CH3COC2H5 + hv ->  CH3. + C2H5CO.                                              =*
*=                                                                           =*
*=  Cross section:  IUPAC99                                                  =*
*=  Quantum yield:  Raber et Moortgat 95  (0.34*0.15)                                                =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'CH3COC2H5 + hv -> CH3. + C2H5CO.'
!      jlabel3(j) = 'PHOT  CH3COC2H5  3200  10'
      jlabel3(j) = 'PHOT  CH3COC2H5  3200  '


      OPEN(UNIT=kin,FILE='MCM2001/2butanone_rad2',
     $     STATUS='old')
      do i = 1, 2
         read(kin,*)
      enddo
      n = 96
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END




* =============================================================================
      SUBROUTINE ro33(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for CH3COC3H7             =*
*=  photolysis:                                                              =*
*=         CH3COC3H7 + hv -> C3H7. + CH3CO.                                              =*
*=                                                                           =*
*=  Cross section:  Martinez 92                                                  =*
*=  Quantum yield:  Raber 95 (for 2-butanone)                                                  =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'CH3COC3H7 + hv -> C3H7. + CH3CO.'
!      jlabel3(j) = 'PHOT  CH3COC3H7  3300  10'
      jlabel3(j) = 'PHOT  CH3COC3H7  3300  '


      OPEN(UNIT=kin,FILE='MCM2001/2pentanone_rad',
     $     STATUS='old')
      do i = 1, 1
         read(kin,*)
      enddo
      n = 96
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END


* =============================================================================
      SUBROUTINE ro34(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for C2H5COC2H5             =*
*=  photolysis:                                                              =*
*=         C2H5COC2H5 + hv -> C2H5CO. + C2H5.                                              =*
*=                                                                           =*
*=  Cross section:  Martinez 92                                                  =*
*=  Quantum yield:  Raber 95 (for 2-butanone)                                                  =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'C2H5COC2H5 + hv -> C2H5CO. + C2H5.'
!      jlabel3(j) = 'PHOT  C2H5COC2H5  3400  10'
      jlabel3(j) = 'PHOT  C2H5COC2H5  3400  '


      OPEN(UNIT=kin,FILE='MCM2001/3pentanone.prn',
     $     STATUS='old')
      do i = 1, 1
         read(kin,*)
      enddo
      n = 95
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END

* =============================================================================
      SUBROUTINE ro35(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for(CH3)2CHCOCH(CH3)2             =*
*=  photolysis:                                                              =*
*=         (CH3)2CHCOCH(CH3)2 + hv -> (CH3)2CHCO(.) + C(.)H(CH3)2                                           =*
*=                                                                           =*
*=  Cross section:  Yujing 2000                                                  =*
*=  Quantum yield:  Raber 95 (for 2-butanone)                                                  =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = '(CH3)2CHCOCH(CH3)2 + hv -> (CH3)2CHCO(.) 
     & + C(.)H(CH3)2'
!      jlabel3(j) = 'PHOT  (CH3)2CHCOCH(CH3)2  3500  10'
      jlabel3(j) = 'PHOT  (CH3)2CHCOCH(CH3)2  3500  '


      OPEN(UNIT=kin,FILE='MCM2001/24dimethyl3pentanone.prn',
     $     STATUS='old')
      do i = 1, 2
         read(kin,*)
      enddo
      n = 131
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END

* =============================================================================
      SUBROUTINE ro36(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) forCH3COCH2CH(CH3)2             =*
*=  photolysis:                                                              =*
*=         CH3COCH2CH(CH3)2 + hv -> CH3CO. + CH2(.)CH(CH3)2                                           =*
*=                                                                           =*
*=  Cross section:  Yujing 2000                                                  =*
*=  Quantum yield:  Raber 95 (for 2-butanone) 0.34*0.3                                                  =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'CH3COCH2CH(CH3)2 + hv -> CH3CO. + CH2(.)CH(CH3)2'
!      jlabel3(j) = 'PHOT  CH3COCH2CH(CH3)2  3600  10'
      jlabel3(j) = 'PHOT  CH3COCH2CH(CH3)2  3600  '


      OPEN(UNIT=kin,FILE='MCM2001/4methyl2pentanone_rad',
     $     STATUS='old')
      do i = 1, 3
         read(kin,*)
      enddo
      n = 133
    
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
	 
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO
      
      END
* =============================================================================
      SUBROUTINE ro37(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) forCH3COCH2CH(CH3)2             =*
*=  photolysis:                                                              =*
*=         CH3COCH2CH(CH3)2 + hv -> CH3COCH3 + CH2=CHCH3                                           =*
*=                                                                           =*
*=  Cross section:  Yujing 2000                                                  =*
*=  Quantum yield:  Raber 95 (for 2-butanone) 0.34*0.7                                                  =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'CH3COCH2CH(CH3)2 + hv -> CH3COCH3 + CH2=CHCH3'
!      jlabel3(j) = 'PHOT  CH3COCH2CH(CH3)2  3700  10'
      jlabel3(j) = 'PHOT  CH3COCH2CH(CH3)2  3700  '


      OPEN(UNIT=kin,FILE='MCM2001/4methyl2pentanone_Nor',
     $     STATUS='old')
      do i = 1, 3
         read(kin,*)
      enddo
      n = 133
    
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
	 
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO
      
      END
* =============================================================================
      SUBROUTINE ro38(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for                =*
*=  CH3COCH2CH2CH(CH3)2 photolysis:                                                              =*
*=         CH3COCH2CH2CH(CH3)2 + hv -> CH3CO. + .CH2CH2CH(CH3)2                                           =*
*=                                                                           =*
*=  Cross section:  Yujing 2000                                                  =*
*=  Quantum yield:  Raber 95 (for 2-butanone) 0.34*0.3                                                 =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'CH3COCH2CH2CH(CH3)2 + hv ->CH3CO. + .CH2CH2CH(CH3)2'
!      jlabel3(j) = 'PHOT  CH3COCH2CH2CH(CH3)2  3800  10'
      jlabel3(j) = 'PHOT  CH3COCH2CH2CH(CH3)2  3800  '


      OPEN(UNIT=kin,FILE='MCM2001/5methyl2hexanone_rad',
     $     STATUS='old')
      do i = 1, 3
         read(kin,*)
      enddo
      n = 135
    
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
	 
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO
      END
* =============================================================================
      SUBROUTINE ro39(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for                =*
*=  CH3COCH2CH2CH(CH3)2 photolysis:                                                              =*
*=         CH3COCH2CH2CH(CH3)2 + hv -> CH3COCH3 + CH2=C(CH3)2                                           =*
*=                                                                           =*
*=  Cross section:  Yujing 2000                                                  =*
*=  Quantum yield:  Raber 95 (for 2-butanone) 0.34*0.7                                                 =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'CH3COCH2CH2CH(CH3)2 + hv ->CH3COCH3 + CH2=C(CH3)2'
!      jlabel3(j) = 'PHOT  CH3COCH2CH2CH(CH3)2  3900  10'
      jlabel3(j) = 'PHOT  CH3COCH2CH2CH(CH3)2  3900  '


      OPEN(UNIT=kin,FILE='MCM2001/5methyl2hexanone_Nor',
     $     STATUS='old')
      do i = 1, 3
         read(kin,*)
      enddo
      n = 135
    
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
	 
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO
      END
* =============================================================================
      SUBROUTINE ro40(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for             =*
*=  CH2=CHCHO photolysis:                                                              =*
*=         CH2=CHCHO + hv -> CH2CH=CHCO. + HO2.                                           =*
*=                                                                           =*
*=  Cross section:  Gardner 87                                                  =*
*=  Quantum yield:  Magneron 99  *0.4                                                =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'CH2=CHCHO + hv -> CH2CH=CHCO. + HO2.'
!      jlabel3(j) = 'PHOT  CH2=CHCHO  4000  10'
      jlabel3(j) = 'PHOT  CH2=CHCHO  4000  '


      OPEN(UNIT=kin,FILE='MCM2001/acrolein0_4.txt',
     $     STATUS='old')
      do i = 1, 2
         read(kin,*)
      enddo
      n = 131
    
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
	 
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO
      END
* =============================================================================
      SUBROUTINE ro41(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for             =*
*=  CH2=CHCHO photolysis:                                                              =*
*=         CH2=CHCHO + hv -> CH2=CH. + CHO.                                          =*
*=                                                                           =*
*=  Cross section:  Gardner 87                                                  =*
*=  Quantum yield:  Magneron 99  *0.3                                                =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'CH2=CHCHO + hv -> CH2=CH. + CHO.'
!      jlabel3(j) = 'PHOT  CH2=CHCHO  4100  10'
      jlabel3(j) = 'PHOT  CH2=CHCHO  4100  '


      OPEN(UNIT=kin,FILE='MCM2001/acrolein0_3.txt',
     $     STATUS='old')
      do i = 1, 2
         read(kin,*)
      enddo
      n = 131
    
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
	 
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO
      END
* =============================================================================
      SUBROUTINE ro42(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for             =*
*=  CH2=CHCHO photolysis:                                                              =*
*=         CH2=CHCHO + hv -> CH3C(.)(.)H + CO                                       =*
*=                                                                           =*
*=  Cross section:  Gardner 87                                                  =*
*=  Quantum yield:  Magneron 99  *0.3                                                =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'CH2=CHCHO + hv -> CH3C(.)(.)H + CO '
!      jlabel3(j) = 'PHOT  CH2=CHCHO  4200  10'
      jlabel3(j) = 'PHOT  CH2=CHCHO  4200  '


      OPEN(UNIT=kin,FILE='MCM2001/acrolein0_3.txt',
     $     STATUS='old')
      do i = 1, 2
         read(kin,*)
      enddo
      n = 131
    
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
	 
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO
      END
* =============================================================================
      SUBROUTINE ro43(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for             =*
*=  CH2=C(CH3)CHO photolysis:                                                              =*
*=         CH2=C(CH3)CHO + hv -> CH2=C(.)CH3 +CHO.                                          =*
*=                                                                           =*
*=  Cross section:  Raber 95                                                 =*
*=  Quantum yield: 0.02 * 0.34                                                   =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'CH2=C(CH3)CHO + hv -> CH2=C(.)CH3 +CHO.'
!      jlabel3(j) = 'PHOT  CH2=C(CH3)CHO  4300  10'
      jlabel3(j) = 'PHOT  CH2=C(CH3)CHO  4300  '


      OPEN(UNIT=kin,FILE='MCM2001/MACR_034',
     $     STATUS='old')
      do i = 1, 2
         read(kin,*)
      enddo
      n = 143
    
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
	 
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO
      END
* =============================================================================
      SUBROUTINE ro44(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for             =*
*=  CH2=C(CH3)CHO photolysis:                                                              =*
*=         CH2=C(CH3)CHO + hv -> CH3C(.)(.)CH3 + CO                                          =*
*=                                                                           =*
*=  Cross section:  Raber 95                                                 =*
*=  Quantum yield: 0.02 * 0.33                                                   =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'CH2=C(CH3)CHO + hv ->CH3C(.)(.)CH3 + CO '
!      jlabel3(j) = 'PHOT  CH2=C(CH3)CHO  4400  10'
      jlabel3(j) = 'PHOT  CH2=C(CH3)CHO  4400  '


      OPEN(UNIT=kin,FILE='MCM2001/MACR_033',
     $     STATUS='old')
      do i = 1, 2
         read(kin,*)
      enddo
      n = 143
    
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
	 
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO
      END
* =============================================================================
      SUBROUTINE ro45(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for             =*
*=  CH2=C(CH3)CHO photolysis:                                                              =*
*=         CH2=C(CH3)CHO + hv -> CH2=C(CH3)C(.)O                                          =*
*=                                                                           =*
*=  Cross section:  Raber 95                                                 =*
*=  Quantum yield: 0.02 * 0.33                                                   =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'CH2=C(CH3)CHO + hv ->CH2=C(CH3)C(.)O'
!      jlabel3(j) = 'PHOT  CH2=C(CH3)CHO  4500  10'
      jlabel3(j) = 'PHOT  CH2=C(CH3)CHO  4500  '


      OPEN(UNIT=kin,FILE='MCM2001/MACR_033',
     $     STATUS='old')
      do i = 1, 2
         read(kin,*)
      enddo
      n = 143
    
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
	 
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO
      END
* =============================================================================
      SUBROUTINE ro46(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for             =*
*=  CH3CH=CHCHO photolysis:                                                              =*
*=         CH3CH=CHCHO + hv -> CH3CH=CH(.) + CHO.                                           =*
*=                                                                           =*
*=  Cross section:  Magneron 1999                                                  =*
*=  Quantum yield:  Magneron 1999                                                  =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'CH3CH=CHCHO + hv -> CH3CH=CH(.) + CHO.'
!      jlabel3(j) = 'PHOT  CH3CH=CHCHO  4600  10'
      jlabel3(j) = 'PHOT  CH3CH=CHCHO  4600  '


      OPEN(UNIT=kin,FILE='MCM2001/crotonaldehyde',
     $     STATUS='old')
      do i = 1, 2
         read(kin,*)
      enddo
      n = 185
    
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
	 
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END
* =============================================================================
      SUBROUTINE ro47(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for             =*
*=  CH3CH=CHCHO photolysis:                                                              =*
*=         CH3CH=CHCHO + hv -> CH2CH=CHC(.)O + H.                                            =*
*=                                                                           =*
*=  Cross section:  Magneron 1999                                                  =*
*=  Quantum yield:  Magneron 1999                                                  =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'CH3CH=CHCHO + hv -> CH2CH=CHC(.)O + H.'
!      jlabel3(j) = 'PHOT  CH3CH=CHCHO  4700  10'
      jlabel3(j) = 'PHOT  CH3CH=CHCHO  4700  '


      OPEN(UNIT=kin,FILE='MCM2001/crotonaldehyde',
     $     STATUS='old')
      do i = 1, 2
         read(kin,*)
      enddo
      n = 185
    
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
	 
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END
* =============================================================================
      SUBROUTINE ro48(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for             =*
*=  CH3CH=CHCHO photolysis:                                                              =*
*=         CH3CH=CHCHO + hv -> CH3CH2CH(.)(.)H + CO                                           =*
*=                                                                           =*
*=  Cross section:  Magneron 1999                                                  =*
*=  Quantum yield:  Magneron 1999                                                  =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'CH3CH=CHCHO + hv -> CH3CH2CH(.)(.)H + CO'
!      jlabel3(j) = 'PHOT  CH3CH=CHCHO  4800  10'
      jlabel3(j) = 'PHOT  CH3CH=CHCHO  4800  '


      OPEN(UNIT=kin,FILE='MCM2001/crotonaldehyde',
     $     STATUS='old')
      do i = 1, 2
         read(kin,*)
      enddo
      n = 185
    
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
	 
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END
* =============================================================================
      SUBROUTINE ro49(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for             =*
*=  CH2=CHCOCH3 photolysis:                                                              =*
*=         CH2=CHCOCH3 + hv -> CH2=CHCH3 + CO                                           =*
*=                                                                           =*
*=  Cross section:  Raber 1995                                                  =*
*=  Quantum yield:  Raber 1995                                                  =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'CH2=CHCOCH3 + hv -> CH2=CHCH3 + CO '
!      jlabel3(j) = 'PHOT  CH2=CHCOCH3  4900  10'
      jlabel3(j) = 'PHOT  CH2=CHCOCH3  4900  '


      OPEN(UNIT=kin,FILE='MCM2001/MVK094',
     $     STATUS='old')
      do i = 1, 2
         read(kin,*)
      enddo
      n = 128
    
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
	 
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END
* =============================================================================
      SUBROUTINE ro50(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for             =*
*=  CH2=CHCOCH3 photolysis:                                                              =*
*=         CH2=CHCOCH3 + hv -> CH2=CH. + CH3CO.                                           =*
*=                                                                           =*
*=  Cross section:  Raber 1995                                                  =*
*=  Quantum yield:  Raber 1995                                                  =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'CH2=CHCOCH3 + hv -> CH2=CH. + CH3CO.  '
!      jlabel3(j) = 'PHOT  CH2=CHCOCH3  5000  10'
      jlabel3(j) = 'PHOT  CH2=CHCOCH3  5000  '


      OPEN(UNIT=kin,FILE='MCM2001/MVK006',
     $     STATUS='old')
      do i = 1, 2
         read(kin,*)
      enddo
      n = 128
    
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
	 
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END
* =============================================================================
      SUBROUTINE ro51(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for             =*
*=  CHOCHO photolysis:                                                              =*
*=        CHOCHO + hv -> H2 + 2CO                                           =*
*=                                                                           =*
*=  Cross section: IUPAC 99                                                  =*
*=  Quantum yield:  Magneron 99                                                  =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'CHOCHO + hv -> H2 + 2CO'
!      jlabel3(j) = 'PHOT  CHOCHO  5100  10'
      jlabel3(j) = 'PHOT  CHOCHO  5100  '


      OPEN(UNIT=kin,FILE='MCM2001/glyoxal_phi1.prn',
     $     STATUS='old')
      do i = 1, 2
         read(kin,*)
      enddo
      n = 107  !104
    
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
	 
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END
* =============================================================================
      SUBROUTINE ro52(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for             =*
*=  CHOCHO  photolysis:                                                              =*
*=         CHOCHO  + hv -> 2 CHO.                                           =*
*=                                                                           =*
*=  Cross section:  IUPAC 99                                                  =*
*=  Quantum yield:  Magneron 99                                                 =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'CHOCHO  + hv -> 2 CHO.'
!      jlabel3(j) = 'PHOT  CHOCHO  5200  10'
      jlabel3(j) = 'PHOT  CHOCHO  5200  '


      OPEN(UNIT=kin,FILE='MCM2001/glyoxal_phi2.prn',
     $     STATUS='old')
      do i = 1, 2
         read(kin,*)
      enddo
      n = 60 !57
    
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
	 
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END
* =============================================================================
      SUBROUTINE ro53(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for             =*
*=  CHOCHO photolysis:                                                              =*
*=         CHOCHO + hv -> H2CO + CO                                           =*
*=                                                                           =*
*=  Cross section:  IUPAC99                                                  =*
*=  Quantum yield:  Magneron 99                                                   =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'CHOCHO + hv -> H2CO + CO'
!      jlabel3(j) = 'PHOT  CHOCHO  5300  10'
      jlabel3(j) = 'PHOT  CHOCHO  5300  '


      OPEN(UNIT=kin,FILE='MCM2001/glyoxal_phi3.prn',
     $     STATUS='old')
      do i = 1, 2
         read(kin,*)
      enddo
      n = 107  !104
    
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
	 
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END
* =============================================================================
      SUBROUTINE ro54(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for             =*
*=  CH3COCHO photolysis:                                                              =*
*=         CH3COCHO + hv -> CHO. + CH3CO.                                           =*
*=                                                                           =*
*=  Cross section:  Calvert 2000                                                  =*
*=  Quantum yield:  Raber 95                                                  =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'CH3COCHO + hv -> CHO. + CH3CO.'
!      jlabel3(j) = 'PHOT  CH3COCHO  5400  10'
      jlabel3(j) = 'PHOT  CH3COCHO  5400  '


      OPEN(UNIT=kin,FILE='MCM2001/Mglyoxal090.txt',
     $     STATUS='old')
      do i = 1, 2
         read(kin,*)
      enddo
      n = 273  !271
    
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
	 
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END
* =============================================================================
      SUBROUTINE ro55(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for             =*
*=  CH3COCHO photolysis:                                                              =*
*=         CH3COCHO + hv -> CO + CH3CHO                                           =*
*=                                                                           =*
*=  Cross section:  Calvert 2000                                                  =*
*=  Quantum yield:  Raber 95                                                  =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'CH3COCHO + hv -> CO + CH3CHO'
!      jlabel3(j) = 'PHOT  CH3COCHO  5500  10'
      jlabel3(j) = 'PHOT  CH3COCHO  5500  '


      OPEN(UNIT=kin,FILE='MCM2001/Mglyoxal005.txt',
     $     STATUS='old')
      do i = 1, 2
         read(kin,*)
      enddo
      n = 273  !271
    
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
	 
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO
      END
* =============================================================================
      SUBROUTINE ro56(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for             =*
*=  CH3COCHO photolysis:                                                              =*
*=         CH3COCHO + hv -> 2 CO + CH4                                           =*
*=                                                                           =*
*=  Cross section:  Calvert 2000                                                  =*
*=  Quantum yield:  Raber 95                                                  =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'CH3COCHO + hv -> 2 CO + CH4'
!      jlabel3(j) = 'PHOT  CH3COCHO  5600  10'
      jlabel3(j) = 'PHOT  CH3COCHO  5600  '


      OPEN(UNIT=kin,FILE='MCM2001/Mglyoxal005.txt',
     $     STATUS='old')
      do i = 1, 2
         read(kin,*)
      enddo
      n = 273  !271
    
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
	 
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END
      
* =============================================================================
      SUBROUTINE ro57(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for             =*
*=  CH3COCOCH3 photolysis:                                                              =*
*=         CH3COCOCH3 + hv -> 2 CH3CO.                                           =*
*=                                                                           =*
*=  Cross section:  Plum 83                                                   =*
*=  Quantum yield:  SAPRC 99                                                  =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'CH3COCOCH3 + hv -> 2 CH3CO.'
!      jlabel3(j) = 'PHOT  CH3COCOCH3  5700  10'
      jlabel3(j) = 'PHOT  CH3COCOCH3  5700  '


      OPEN(UNIT=kin,FILE='MCM2001/BACL_ADJ.PHD',
     $     STATUS='old')
      do i = 1, 6
         read(kin,*)
      enddo
      n = 98
    
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
	 
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END
* =============================================================================
      SUBROUTINE ro58(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for             =*
*=  CHOCH=CHCH=CHCHO photolysis:                                                              =*
*=         CHOCH=CHCH=CHCHO + hv ->  CHO. + .CH=CHCH=CHCHO                                         =*
*=                                                                           =*
*=  Cross section:  Klotz 95                                                  =*
*=  Quantum yield:                                                   =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'CHOCH=CHCH=CHCHO + hv ->  CHO. + .CH=CHCH=CHCHO'
!      jlabel3(j) = 'PHOT  CHOCH=CHCH=CHCHO  5800  10'
      jlabel3(j) = 'PHOT  CHOCH=CHCH=CHCHO  5800  '


      OPEN(UNIT=kin,FILE='MCM2001/EEhexadienedial',
     $     STATUS='old')
      do i = 1, 5
         read(kin,*)
      enddo
      n = 13
    
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
	 
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END
* =============================================================================
      SUBROUTINE ro59(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for             =*
*=  CHOCH=CHCH=CHCHO photolysis:                                                              =*
*=         CHOCH=CHCH=CHCHO + hv ->  CHOCH=CHCH=CHCO. + HO2.                                         =*
*=                                                                           =*
*=  Cross section:  Klotz 95                                                  =*
*=  Quantum yield:                                                   =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'CHOCH=CHCH=CHCHO + hv ->  CHOCH=CHCH=CHCO. + HO2. '
!      jlabel3(j) = 'PHOT  CHOCH=CHCH=CHCHO  5900  10'
      jlabel3(j) = 'PHOT  CHOCH=CHCH=CHCHO  5900  '


      OPEN(UNIT=kin,FILE='MCM2001/EEhexadienedial',
     $     STATUS='old')
      do i = 1, 5
         read(kin,*)
      enddo
      n = 13
    
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
	 
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END
* =============================================================================
      SUBROUTINE ro61(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for             =*
*=  CHOC(CH3)=CHCH=CHCHO photolysis:                                                              =*
*=         CHOC(CH3)=CHCH=CHCHO + hv -> CHOC(CH3)=CHCH=CH. + .CHO                                           =*
*=                                                                           =*
*=  Cross section:  Klotz 95                                                   =*
*=  Quantum yield:                                                  =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'CHOC(CH3)=CHCH=CHCHO + hv -> CHOC(CH3)=CHCH=CH. 
     & + .CHO'
!      jlabel3(j) = 'PHOT  CHOC(CH3)=CHCH=CHCHO  6100  10'
      jlabel3(j) = 'PHOT  CHOC(CH3)=CHCH=CHCHO  6100  '


      OPEN(UNIT=kin,FILE='MCM2001/EE2methylhexadienedial.prn',
     $     STATUS='old')
      do i = 1, 2
         read(kin,*)
      enddo
      n = 13
    
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
	 
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END
* =============================================================================
      SUBROUTINE ro62(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for             =*
*=  CHOC(CH3)=CHCH=CHCHO photolysis:                                                              =*
*=         CHOC(CH3)=CHCH=CHCHO + hv -> CHO. + .C(CH3)=CHCH=CHCHO                                           =*
*=                                                                           =*
*=  Cross section:  Klotz 95                                                   =*
*=  Quantum yield:                                                  =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'CHOC(CH3)=CHCH=CHCHO + hv -> CHO. + 
     & .C(CH3)=CHCH=CHCHO'
!      jlabel3(j) = 'PHOT  CHOC(CH3)=CHCH=CHCHO  6200  10'
      jlabel3(j) = 'PHOT  CHOC(CH3)=CHCH=CHCHO  6200  '


      OPEN(UNIT=kin,FILE='MCM2001/EE2methylhexadienedial.prn',
     $     STATUS='old')
      do i = 1, 2
         read(kin,*)
      enddo
      n = 13
    
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
	 
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END
* =============================================================================
      SUBROUTINE ro63(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for             =*
*=  CHOC(CH3)=CHCH=CHCHO photolysis:                                                              =*
*=         CHOC(CH3)=CHCH=CHCHO + hv -> CHOC(CH3)=CHCH=CHCO. + HO2.                                           =*
*=                                                                           =*
*=  Cross section:  Klotz 95                                                   =*
*=  Quantum yield:                                                  =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'CHOC(CH3)=CHCH=CHCHO + hv -> CHOC(CH3)=CHCH=CHCO. 
     & + HO2.'
!      jlabel3(j) = 'PHOT  CHOC(CH3)=CHCH=CHCHO  6300  10'
      jlabel3(j) = 'PHOT  CHOC(CH3)=CHCH=CHCHO  6300  '


      OPEN(UNIT=kin,FILE='MCM2001/EE2methylhexadienedial.prn',
     $     STATUS='old')
      do i = 1, 2
         read(kin,*)
      enddo
      n = 13
    
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
	 
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END
* =============================================================================
      SUBROUTINE ro64(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for             =*
*=  CHOC(CH3)=CHCH=CHCHO photolysis:                                                              =*
*=         CHOC(CH3)=CHCH=CHCHO + hv -> C(.)OC(CH3)=CHCH=CHCHO + HO2.                                           =*
*=                                                                           =*
*=  Cross section:  Klotz 95                                                   =*
*=  Quantum yield:                                                  =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'CHOC(CH3)=CHCH=CHCHO + hv -> C(.)OC(CH3)=CHCH=CHCHO
     &  + HO2.'
!      jlabel3(j) = 'PHOT  CHOC(CH3)=CHCH=CHCHO  6400  10'
      jlabel3(j) = 'PHOT  CHOC(CH3)=CHCH=CHCHO  6400  '


      OPEN(UNIT=kin,FILE='MCM2001/EE2methylhexadienedial.prn',
     $     STATUS='old')
      do i = 1, 2
         read(kin,*)
      enddo
      n = 13
    
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
	 
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END
* =============================================================================
      SUBROUTINE ro65(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for             =*
*=  CH3CH(ONO2)CH2(ONO2) photolysis:                                                              =*
*=         CH3CH(ONO2)CH2(ONO2) + hv -> CH3CH(O.)CH2(ONO2) + NO2                                           =*
*=                                                                           =*
*=  Cross section:  Barnes 93                                                   =*
*=  Quantum yield:                                                  =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'CH3CH(ONO2)CH2(ONO2) + hv -> CH3CH(O.)CH2(ONO2) 
     & + NO2'
!      jlabel3(j) = 'PHOT  CH3CH(ONO2)CH2(ONO2)  6500  10'
      jlabel3(j) = 'PHOT  CH3CH(ONO2)CH2(ONO2)  6500  '


      OPEN(UNIT=kin,FILE='MCM2001/D1.prn',
     $     STATUS='old')
      do i = 1, 1
         read(kin,*)
      enddo
      n = 20
    
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
	 
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END
* =============================================================================
      SUBROUTINE ro66(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for             =*
*=  CH3CH(ONO2)CH2(ONO2) photolysis:                                                              =*
*=         CH3CH(ONO2)CH2(ONO2) + hv -> CH3CH(ONO2)CH2O. + NO2                                          =*
*=                                                                           =*
*=  Cross section:  Barnes 93                                                   =*
*=  Quantum yield:                                                  =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'CH3CH(ONO2)CH2(ONO2) + hv -> products'
!      jlabel3(j) = 'PHOT  CH3CH(ONO2)CH2(ONO2)  6600  10'
      jlabel3(j) = 'PHOT  CH3CH(ONO2)CH2(ONO2)  6600  '


      OPEN(UNIT=kin,FILE='MCM2001/D1.prn',
     $     STATUS='old')
      do i = 1, 1
         read(kin,*)
      enddo
      n = 20
    
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
	 
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END
* =============================================================================
      SUBROUTINE ro67(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for             =*
*=  CH3CH2CH(ONO2)CH2(ONO2)photolysis:                                                              =*
*=         CH3CH2CH(ONO2)CH2(ONO2) + hv -> CH3CH2CH(O.)CH2(ONO2) + NO2                                           =*
*=                                                                           =*
*=  Cross section:  Barnes 93                                                   =*
*=  Quantum yield:                                                  =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'CH3CH2CH(ONO2)CH2(ONO2) + hv -> 
     &  CH3CH2CH(O.)CH2(ONO2) + NO2'
!      jlabel3(j) = 'PHOT  CH3CH2CH(ONO2)CH2(ONO2)  6700  10'
      jlabel3(j) = 'PHOT  CH3CH2CH(ONO2)CH2(ONO2)  6700  '


      OPEN(UNIT=kin,FILE='MCM2001/D2.prn',
     $     STATUS='old')
      do i = 1, 1
         read(kin,*)
      enddo
      n = 20
    
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
	 
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END
* =============================================================================
      SUBROUTINE ro68(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for             =*
*=  CH3CH2CH(ONO2)CH2(ONO2)photolysis:                                                              =*
*=         CH3CH2CH(ONO2)CH2(ONO2) + hv -> CH3CH2CH(ONO2)CH2O. + NO2                                           =*
*=                                                                           =*
*=  Cross section:  Barnes 93                                                   =*
*=  Quantum yield:                                                  =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'CH3CH2CH(ONO2)CH2(ONO2) + hv -> CH3CH2CH(ONO2)CH2O. 
     &  + NO2'
!      jlabel3(j) = 'PHOT  CH3CH2CH(ONO2)CH2(ONO2)  6800  10'
      jlabel3(j) = 'PHOT  CH3CH2CH(ONO2)CH2(ONO2)  6800  '


      OPEN(UNIT=kin,FILE='MCM2001/D2.prn',
     $     STATUS='old')
      do i = 1, 1
         read(kin,*)
      enddo
      n = 20
    
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
	 
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END
* =============================================================================
      SUBROUTINE ro69(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for             =*
*=  CH3CH(ONO2)CH(ONO2)CH3  photolysis:                                                              =*
*=         CH3CH(ONO2)CH(ONO2)CH3 + hv -> CH3CH(O.)CH(ONO2)CH3 + NO2                                          =*
*=                                                                           =*
*=  Cross section:  Barnes 93                                                  =*
*=  Quantum yield:                                                  =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'CH3CH(ONO2)CH(ONO2)CH3 + hv -> CH3CH(O.)CH(ONO2)CH3 
     & + NO2'
!      jlabel3(j) = 'PHOT  CH3CH(ONO2)CH(ONO2)CH3  6900  10'
      jlabel3(j) = 'PHOT  CH3CH(ONO2)CH(ONO2)CH3  6900  '


      OPEN(UNIT=kin,FILE='MCM2001/D3.prn',
     $     STATUS='old')
      do i = 1, 1
         read(kin,*)
      enddo
      n = 20
    
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
	 
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END
* =============================================================================
      SUBROUTINE ro70(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for             =*
*=  CH2(ONO2)CH(ONO2)CH=CH2 photolysis:                                                              =*
*=         CH2(ONO2)CH(ONO2)CH=CH2 + hv -> CH2(ONO2)CH(O.)CH=CH2 + NO2                                          =*
*=                                                                           =*
*=  Cross section:  Barnes 93                                                   =*
*=  Quantum yield:                                                  =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'CH2(ONO2)CH(ONO2)CH=CH2 + hv -> CH2(ONO2)CH(O.)CH=CH2
     &  + NO2'
!      jlabel3(j) = 'PHOT  CH2(ONO2)CH(ONO2)CH=CH2  7000  10'
      jlabel3(j) = 'PHOT  CH2(ONO2)CH(ONO2)CH=CH2  7000  '


      OPEN(UNIT=kin,FILE='MCM2001/D4.prn',
     $     STATUS='old')
      do i = 1, 2
         read(kin,*)
      enddo
      n = 20
    
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
	 
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END
* =============================================================================
      SUBROUTINE ro71(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for             =*
*=  CH2(ONO2)CH(ONO2)CH=CH2 photolysis:                                                              =*
*=         CH2(ONO2)CH(ONO2)CH=CH2 + hv -> CH2(O.)CH(ONO2)CH=CH2 + NO2                                          =*
*=                                                                           =*
*=  Cross section:  Barnes 93                                                   =*
*=  Quantum yield:                                                  =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'CH2(ONO2)CH(ONO2)CH=CH2 + hv -> CH2(O.)CH(ONO2)CH=CH2
     &  + NO2'
!      jlabel3(j) = 'PHOT  CH2(ONO2)CH(ONO2)CH=CH2  7100  10'
      jlabel3(j) = 'PHOT  CH2(ONO2)CH(ONO2)CH=CH2  7100  '


      OPEN(UNIT=kin,FILE='MCM2001/D4.prn',
     $     STATUS='old')
      do i = 1, 2
         read(kin,*)
      enddo
      n = 20
    
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
	 
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END
* =============================================================================
      SUBROUTINE ro72(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for             =*
*=  CH2(ONO2)CH=CHCH2(ONO2) photolysis:                                                              =*
*=         CH2(ONO2)CH=CHCH2(ONO2) + hv ->CH2(ONO2)CH=CHCH2O. + NO2                                          =*
*=                                                                           =*
*=  Cross section:  Barnes 93                                                   =*
*=  Quantum yield:                                                  =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'CH2(ONO2)CH=CHCH2(ONO2) + hv -> CH2(ONO2)CH=CHCH2O. 
     & + NO2'
!      jlabel3(j) = 'PHOT  CH2(ONO2)CH=CHCH2(ONO2)  7200  10'
      jlabel3(j) = 'PHOT  CH2(ONO2)CH=CHCH2(ONO2)  7200  '


      OPEN(UNIT=kin,FILE='MCM2001/D5.prn',
     $     STATUS='old')
      do i = 1, 2
         read(kin,*)
      enddo
      n = 18
    
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
	 
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END
* =============================================================================
      SUBROUTINE ro73(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for             =*
*=  CH3OOH photolysis:                                                              =*
*=         CH3OOH + hv -> CH3O.+ OH.                                           =*
*=                                                                           =*
*=  Cross section:  IUPAC99                                                   =*
*=  Quantum yield:  IUPAC99                                                =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'CH3OOH + hv -> CH3O.+ OH.'
!      jlabel3(j) = 'PHOT  CH3OOH  7300  10'
      jlabel3(j) = 'PHOT  CH3OOH  7300  '


      OPEN(UNIT=kin,FILE='MCM2001/CH3OOH.prn',
     $     STATUS='old')
      do i = 1, 3
         read(kin,*)
      enddo
      n = 35  !33
    
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
	 
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END
* =============================================================================
      SUBROUTINE ro74(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for             =*
*=  OHCH2CHO photolysis:                                                              =*
*=         OHCH2CHO + hv -> OHCH2. + .CHO                                           =*
*=                                                                           =*
*=  Cross section:  Tyndall 99                                                   =*
*=  Quantum yield:  Tyndall 99                                                =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'OHCH2CHO + hv -> OHCH2. + .CHO'
!      jlabel3(j) = 'PHOT  OHCH2CHO  7400  10'
      jlabel3(j) = 'PHOT  OHCH2CHO  7400  '


      OPEN(UNIT=kin,FILE='MCM2001/glycolaldehyde',
     $     STATUS='old')
      do i = 1, 2
         read(kin,*)
      enddo
      n = 133  !131
    
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
	 
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END
* =============================================================================
      SUBROUTINE ro75(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for             =*
*=  OHCH2CHONO2 photolysis:                                                              =*
*=         OHCH2CH2ONO2 + hv -> OHCH2CH2O. + NO2                                          =*
*=                                                                           =*
*=  Cross section: Roberts 89                                                 =*
*=  Quantum yield: Roberts 89                                                =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'OHCH2CH2ONO2 + hv -> OHCH2CH2O. + NO2'
!      jlabel3(j) = 'PHOT  OHCH2CH2ONO2  7500  10'
      jlabel3(j) = 'PHOT  OHCH2CH2ONO2  7500  '


      OPEN(UNIT=kin,FILE='MCM2001/NOE.prn',
     $     STATUS='old')
      do i = 1, 2
         read(kin,*)
      enddo
      n = 12
    
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
	 
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END
* =============================================================================
      SUBROUTINE ro76(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for             =*
*=  OHCH2COCH3 photolysis:                                                              =*
*=         OHCH2COCH3 + hv -> OHCH2. + .COCH3                                          =*
*=                                                                           =*
*=  Cross section:  Orlando 99                                                   =*
*=  Quantum yield:                                                  =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'OHCH2COCH3 + hv -> OHCH2. + .COCH3'
!      jlabel3(j) = 'PHOT  OHCH2COCH3  7600  10'
      jlabel3(j) = 'PHOT  OHCH2COCH3  7600  '


      OPEN(UNIT=kin,FILE='MCM2001/hydroxyacetone.prn',
     $     STATUS='old')
      do i = 1, 2
         read(kin,*)
      enddo
      n = 115  !113
    
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
	 
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END
* =============================================================================
      SUBROUTINE ro77(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for             =*
*=  OHCH2OOH photolysis:                                                              =*
*=         OHCH2OOH + hv -> OHCH2O. + .OH                                           =*
*=                                                                           =*
*=  Cross section:  Bauerle 99                                                   =*
*=  Quantum yield:                                                  =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'OHCH2OOH + hv -> OHCH2O. + .OH'
!      jlabel3(j) = 'PHOT  OHCH2OOH  7700  10'
      jlabel3(j) = 'PHOT  OHCH2OOH  7700  '


      OPEN(UNIT=kin,FILE='MCM2001/HMHP.prn',
     $     STATUS='old')
      do i = 1, 1
         read(kin,*)
      enddo
      n = 34  !32
    
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
	 
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END

* =============================================================================
      SUBROUTINE ro78(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for             =*
*=  CHOCOOH photolysis:                                                              =*
*=         CHOCOOH + hv -> CO2 + H2CO                                           =*
*=                                                                           =*
*=  Cross section:  Back 1985                                                   =*
*=  Quantum yield:  Back 1985                                                =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'CHOCOOH + hv -> CO2 + HCHO'
!      jlabel3(j) = 'PHOT  CHOCOOH  7800  10'
      jlabel3(j) = 'PHOT  CHOCOOH  7800  '


      OPEN(UNIT=kin,FILE='MCM2001/Glyoxylic_1.prn',
     $     STATUS='old')
      do i = 1, 2
         read(kin,*)
      enddo
      n = 188 !186
    
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
	 
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END
* =============================================================================
      SUBROUTINE ro79(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for             =*
*=  CHOCOOH photolysis:                                                              =*
*=         CHOCOOH + hv -> 2 CO + H2O                                           =*
*=                                                                           =*
*=  Cross section:  Back 1985                                                   =*
*=  Quantum yield:  Back 1985                                                =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'CHOCOOH + hv -> 2 CO + H2O'
!      jlabel3(j) = 'PHOT  CHOCOOH  7900  10'
      jlabel3(j) = 'PHOT  CHOCOOH  7900  '


      OPEN(UNIT=kin,FILE='MCM2001/Glyoxylic_2.prn',
     $     STATUS='old')
      do i = 1, 2
         read(kin,*)
      enddo
      n = 188 !186
    
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
	 
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END
* =============================================================================
      SUBROUTINE ro80(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for             =*
*=  COOH-COOH photolysis:                                                              =*
*=         COOH-COOH + hv -> CO2 + HCOOH                                           =*
*=                                                                           =*
*=  Cross section:  Yamamoto 1985                                                   =*
*=  Quantum yield:  Yamamoto 1985                                                =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'COOH-COOH + hv -> CO2 + HCOOH'
!      jlabel3(j) = 'PHOT  COOHCOOH  8000  10'
      jlabel3(j) = 'PHOT  COOHCOOH  8000  '


      OPEN(UNIT=kin,FILE='MCM2001/Oxalic_1.prn',
     $     STATUS='old')
      do i = 1, 2
         read(kin,*)
      enddo
      n = 58  !55
    
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
	 
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END
* =============================================================================
      SUBROUTINE ro81(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for             =*
*=  COOH-COOH photolysis:                                                              =*
*=         COOH-COOH + hv -> CO2 + CO + H2O                                           =*
*=                                                                           =*
*=  Cross section:  Yamamoto 1985                                                   =*
*=  Quantum yield:  Yamamoto 1985                                                =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'COOH-COOH + hv -> CO2 + CO + H2O'
!      jlabel3(j) = 'PHOT  COOHCOOH  8100  10'
      jlabel3(j) = 'PHOT  COOHCOOH  8100  '


      OPEN(UNIT=kin,FILE='MCM2001/Oxalic_2.prn',
     $     STATUS='old')
      do i = 1, 2
         read(kin,*)
      enddo
      n = 58  !55
    
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
	 
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END

* =============================================================================
      SUBROUTINE ro82(nw,wl,wc,nz,tlev,airlev,j,sq,jlabel,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Provide the product (cross section) x (quantum yield) for             =*
*=  CH3COCOOH photolysis:                                                              =*
*=         CH3COCOOH + hv -> CO2 + CH3CHO                                           =*
*=                                                                           =*
*=  Cross section:  Yamamoto 1985                                                   =*
*=  Quantum yield:  adjust to find J=2.6.10E-6 s-1 (Grosjean 83)                                                =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw), wc(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel(kj),jlabel3(kj)
      REAL sq(kj,kz,kw)

* input/output:

      INTEGER j

* data arrays

      INTEGER kdata
      PARAMETER(kdata=580)

      INTEGER i, n
      INTEGER n1
      REAL x1(kdata)
      REAL y1(kdata)
cba ajout d'une table y2 pour les rendements quantiques
      REAL x2(kdata)
      REAL y2(kdata)

* local

      REAL yg(kw), yg1(kw)
      REAL qy1
      REAL sig
      INTEGER ierr
      INTEGER iw

      INTEGER mabs, myld

      j = j+1
      jlabel(j) = 'CH3COCOOH + hv -> CO2 + CH3CHO'
!      jlabel3(j) = 'PHOT  CH3COCOOH  8200  10'
      jlabel3(j) = 'PHOT  CH3COCOOH  8200  '


      OPEN(UNIT=kin,FILE='MCM2001/Pyruvic.prn',
     $     STATUS='old')
      do i = 1, 2
         read(kin,*)
      enddo
      n = 152  !150
    
cba store the number of data
      n1=n

      DO i = 1, n
         READ(kin,*) x1(i), y1(i), y2(i)
         x2(i) = x1(i)
	 
      ENDDO
      CLOSE(kin)

      CALL addpnt(x1,y1,kdata,n,x1(1)*(1.-deltax),0.)
      CALL addpnt(x1,y1,kdata,n,               0.,0.)
      CALL addpnt(x1,y1,kdata,n,x1(n)*(1.+deltax),0.)
      CALL addpnt(x1,y1,kdata,n,           1.e+38,0.)
c      do i=1,n
c        write(*,*) x1(i),y1(i)
c      enddo
      CALL inter2(nw,wl,yg,n,x1,y1,ierr)
      IF (ierr .NE. 0) THEN
          WRITE(*,*) ierr, jlabel(j)
          STOP
      ENDIF

* quantum yields

      CALL addpnt(x2,y2,kdata,n1,x2(1)*(1.-deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,               0.,0.)
      CALL addpnt(x2,y2,kdata,n1,x2(n1)*(1.+deltax),0.)
      CALL addpnt(x2,y2,kdata,n1,           1.e+38,0.)
      CALL inter2(nw,wl,yg1,n1,x2,y2,ierr)
      IF (ierr .NE. 0) THEN
         WRITE(*,*) ierr, jlabel(j)
         STOP
      ENDIF

 
* combine:

      DO iw = 1, nw - 1
         DO i = 1, nz

            sig = yg(iw)

* quantum yields:

            qy1 = yg1(iw)

            sq(j  ,i,iw) = sig * qy1

         ENDDO
      ENDDO

      END



