      SUBROUTINE pchemIN(nw,wl,nz,tlev,airlev,
     $     j2,sq2,jlabel2,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Load various "weighting functions" (products of cross section and        =*
*=  quantum yield at each altitude and for wavelength).  The altitude        =*
*=  dependence is necessary to ensure the consideration of pressure and      =*
*=  temperature dependence of the cross sections or quantum yields.          =*
*=  The actual reading, evaluation and interpolation is done is separate     =*
*=  subroutines for ease of management and manipulation.  Please refer to    =*
*=  the inline documentation of the specific subroutines for detail          =*
*=  information.                                                             =*
*-----------------------------------------------------------------------------*
*=  PARAMETERS:                                                              =*
*=  NW     - INTEGER, number of specified intervals + 1 in working        (I)=*
*=           wavelength grid                                                 =*
*=  WL     - REAL, vector of lower limits of wavelength intervals in      (I)=*
*=           working wavelength grid                                         =*
*=  NZ     - INTEGER, number of altitude levels in working altitude grid  (I)=*
*=  TLEV   - REAL, temperature (K) at each specified altitude level       (I)=*
*=  AIRLEV - REAL, air density (molec/cc) at each altitude level          (I)=*
*=  J2     - INTEGER, counter for number of weighting functions defined  (IO)=*
*=  SQ2    - REAL, cross section x quantum yield (cm^2) for each          (O)=*
*=           photolysis reaction defined, at each defined wavelength and     =*
*=           at each defined altitude level                                  =*
*=  JLABEL2- CHARACTER*40, string identifier for each photolysis reaction (O)=*
*=           defined                                                         =*
*-----------------------------------------------------------------------------*
*=  EDIT HISTORY:                                                            =*
*=  05/98  Original; adapted from the "old" JSPEC1 routine                   =*
*-----------------------------------------------------------------------------*
*= This program is free software;  you can redistribute it and/or modify     =*
*= it under the terms of the GNU General Public License as published by the  =*
*= Free Software Foundation;  either version 2 of the license, or (at your   =*
*= option) any later version.                                                =*
*= The TUV package is distributed in the hope that it will be useful, but    =*
*= WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHANTIBI-  =*
*= LITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public     =*
*= License for more details.                                                 =*
*= To obtain a copy of the GNU General Public License, write to:             =*
*= Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.   =*
*-----------------------------------------------------------------------------*
*= To contact the authors, please mail to:                                   =*
*= Sasha Madronich, NCAR/ACD, P.O.Box 3000, Boulder, CO, 80307-3000, USA  or =*
*= send email to:  sasha@ucar.edu                                            =*
*-----------------------------------------------------------------------------*
*= Copyright (C) 1994,95,96  University Corporation for Atmospheric Research =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel2(kj),jlabel3(kj)
      CHARACTER*50 jlabel(kj)
      REAL sq2(kj,kz,kw)

* input/output:
      INTEGER j2

* local:
      REAL wc(kw), wu(kw)
      INTEGER iw
*_______________________________________________________________________

* complete wavelength grid

      DO 5, iw = 1, nw - 1
         wc(iw) = (wl(iw) + wl(iw+1))/2.
         wu(iw) =  wl(iw+1)
 5    CONTINUE


*____________________________________________________________________________

 
      j2 = 0

C O3 + hv ->  O1D
!      CALL rin2(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)
C O3 + hv ->  O3P
!      CALL rin3(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)
C use TUV values instead of MCM
      CALL r01(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel)
      jlabel2(j2-1) = jlabel(j2-1)(1:40)
      jlabel2(j2)   = jlabel(j2)(1:40)
      jlabel3(j2-1) =  'PHOT  O3  2 '
      jlabel3(j2)   =  'PHOT  O3  3 '

C NO2 + hv -> NO + O(3P)
!      CALL rin4(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)
C use TUV values instead of MCM
      CALL r02(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel)
      jlabel2(j2)   = jlabel(j2)(1:40)
      jlabel3(j2)   =  'PHOT  NO2  4 '

C NO3 + hv -> NO + O2
!      CALL rin5(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)
C NO3 + hv -> NO2 + O(3P)
!      CALL rin6(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)
C use TUV values instead of MCM
      CALL r03(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel)
      jlabel2(j2-1) = jlabel(j2-1)(1:40)
      jlabel2(j2)   = jlabel(j2)(1:40)
      jlabel3(j2-1) =  'PHOT  NO3  5 '
      jlabel3(j2)   =  'PHOT  NO3  6 '

C H2O2 + hv -> 2 OH
!      CALL rin11(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)
C use TUV values instead of MCM
      CALL r08(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel)
      jlabel2(j2)   = jlabel(j2)(1:40)
      jlabel3(j2)   =  'PHOT  H2O2  11 '

C HONO + hv -> NO + OH
      CALL rin12(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)

C HNO3 + hv -> NO2 + OH
      CALL rin13(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)

C HNO4 + hv -> 0.61 NO2 + 0.61 HO2 + 0.39 NO3 + 0.39 OH
      CALL rin14(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)

C HCHO + hv -> 2 HO2 + CO
      CALL rin15(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)
C HCHO + hv -> H2 + CO
      CALL rin16(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)
C TUV values (do not go low enough for OFR)
!      CALL r11(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel)
!      jlabel2(j2-1) = jlabel(j2-1)(1:40)
!      jlabel2(j2)   = jlabel(j2)(1:40)
!      jlabel3(j2-1) =  'PHOT  H2CO  110 '
!      jlabel3(j2)   =  'PHOT  NO3  17 '

C DCB2 + hv -> cf SAPRC99 
!      CALL rin12(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)
      
C DCB3 + hv -> cf SAPRC99 
!      CALL rin13(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)

C BENZAL + hv -> cf SAPRC99 
!      CALL rin14(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)

C CH3ONO + hv -> NO + CH3O
      CALL rin40(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)


****************************************************************

      IF (j2 .GT. kj) STOP '1002'
      RETURN
      END
