      SUBROUTINE pchem4(nw,wl,nz,tlev,airlev,
     $     j2,sq2,jlabel2,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Load various "weighting functions" (products of cross section and        =*
*=  quantum yield at each altitude and for wavelength).  The altitude        =*
*=  dependence is necessary to ensure the consideration of pressure and      =*
*=  temperature dependence of the cross sections or quantum yields.          =*
*=  The actual reading, evaluation and interpolation is done is separate     =*
*=  subroutines for ease of management and manipulation.  Please refer to    =*
*=  the inline documentation of the specific subroutines for detail          =*
*=  information.                                                             =*
*-----------------------------------------------------------------------------*
*=  PARAMETERS:                                                              =*
*=  NW     - INTEGER, number of specified intervals + 1 in working        (I)=*
*=           wavelength grid                                                 =*
*=  WL     - REAL, vector of lower limits of wavelength intervals in      (I)=*
*=           working wavelength grid                                         =*
*=  NZ     - INTEGER, number of altitude levels in working altitude grid  (I)=*
*=  TLEV   - REAL, temperature (K) at each specified altitude level       (I)=*
*=  AIRLEV - REAL, air density (molec/cc) at each altitude level          (I)=*
*=  J2     - INTEGER, counter for number of weighting functions defined  (IO)=*
*=  SQ2    - REAL, cross section x quantum yield (cm^2) for each          (O)=*
*=           photolysis reaction defined, at each defined wavelength and     =*
*=           at each defined altitude level                                  =*
*=  JLABEL2- CHARACTER*40, string identifier for each photolysis reaction (O)=*
*=           defined                                                         =*
*-----------------------------------------------------------------------------*
*=  EDIT HISTORY:                                                            =*
*=  05/98  Original; adapted from the "old" JSPEC1 routine                   =*
*-----------------------------------------------------------------------------*
*= This program is free software;  you can redistribute it and/or modify     =*
*= it under the terms of the GNU General Public License as published by the  =*
*= Free Software Foundation;  either version 2 of the license, or (at your   =*
*= option) any later version.                                                =*
*= The TUV package is distributed in the hope that it will be useful, but    =*
*= WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHANTIBI-  =*
*= LITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public     =*
*= License for more details.                                                 =*
*= To obtain a copy of the GNU General Public License, write to:             =*
*= Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.   =*
*-----------------------------------------------------------------------------*
*= To contact the authors, please mail to:                                   =*
*= Sasha Madronich, NCAR/ACD, P.O.Box 3000, Boulder, CO, 80307-3000, USA  or =*
*= send email to:  sasha@ucar.edu                                            =*
*-----------------------------------------------------------------------------*
*= Copyright (C) 1994,95,96  University Corporation for Atmospheric Research =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel2(kj),jlabel3(kj)
      REAL sq2(kj,kz,kw)

* input/output:
      INTEGER j2

* local:
      REAL wc(kw), wu(kw)
      INTEGER iw
*_______________________________________________________________________

* complete wavelength grid

      DO 5, iw = 1, nw - 1
         wc(iw) = (wl(iw) + wl(iw+1))/2.
         wu(iw) =  wl(iw+1)
 5    CONTINUE

*____________________________________________________________________________

 
      j2 = 0

C 1_C5H11ONO2 + hv -> 1_C5H11H9O. + NO2
      CALL rou1(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)

C 2_C4H9ONO2 + hv -> 2_C4H9O. + NO2
      CALL rou2(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)

C tert_C4H9ONO2 + hv -> tert_C4H9O. + NO2
      CALL rou3(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)

C CH3OONO2 + hv -> products
      CALL rou4(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)

C PAN + hv -> products
      CALL rou5(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)

C n-RCHO (without gamma-H) + hv -> CHO. + R.
      CALL rou6(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)

C RCHO (without gamma-H) + hv -> CHO. + R.
      CALL rou7(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)

C RCHO (without gamma-H) + hv -> products 
      CALL rou8(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)

C RCHO (with gamma-H) + hv -> R. + CHO.  
      CALL rou9(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)

C RCHO (with gamma-H) + hv -> Norrish II 
      CALL rou10(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)

C RCHO (with gamma-H) + hv -> R. + CHO.    
      CALL rou11(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)

C RCHO (with gamma-H) + hv -> Norrish II
      CALL rou12(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)

C RRC=CRCHO structures + hv -> RRC=C(.)R + CHO.
      CALL rou13(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)

C RRC=CRCHO structures + hv -> CO + Crieggee 
      CALL rou14(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)

C RRC=CRCHO structures + hv -> H. + RRC=CRC(.)O   
      CALL rou15(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)

C RCOCHO + hv -> RC(.)O + CHO.  
      CALL rou16(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)

C CH3COCHO + hv -> CO + RCHO   
      CALL rou17(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)

C CH3COCHO + hv -> 2 CO + RH   
      CALL rou18(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)

C EE-2.4 hexadienedial + hv -> 4 different ways
      CALL rou19(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)

C EE-2.4 hexadienedial + hv -> 2 different ways 
      CALL rou20(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)

C OHCH2CHO + hv -> CHO. + RRC(OH). 
      CALL rou21(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)

C C2H5COC2H5 + hv -> RC(.)O + R.
      CALL rou22(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)

C ketone (gamma-H + two primary C in apha) + hv -> R. + RCO. 
      CALL rou23(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)

C ketone (gamma-H + two pimary C in alpha) + hv -> Norrish II 
      CALL rou24(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)

C ketone (no gamma-H+only one primary c in alpha position)+hv -> R.+RCO.
      CALL rou25(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)

C ketone (gammaH and only one primary Calpha)+ hv -> R. + RC(.)O
      CALL rou26(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)

C ketone (with gammaH)+ hv -> products 
      CALL rou27(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)

C ketone (without gamma H) + hv -> products 
      CALL rou28(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)

C ketone + hv -> R. + RC(.)O       
      CALL rou29(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)

C ketone + hv -> products 
      CALL rou30(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)

C CH2=CHCOCH3 + hv -> = + CO 
      CALL rou31(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)

C CH2=CHCOCH3 + hv ->  =. + RC(.)O
      CALL rou32(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)

C CH3COCOCH3 + hv -> 2 CH3CO.  
      CALL rou33(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)

C OHCH2COCH3 + hv -> products 
      CALL rou34(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)

C RC(O)COOH + hv -> RCHO + CO2 
      CALL rou35(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)

C CH3OOH + hv -> CH3O.+ OH.   
      CALL rou36(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)

C HC(O)CR=CRCHO + hv -> 3H-furan-2-one
      CALL rou37(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)

C HC(O)CR=CRCHO + hv -> maleic anhydride + 2 HO2.  
      CALL rou38(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)

C RC(O)CR=CRCHO + hv -> 5methyl-3H-furan-2-one    
      CALL rou39(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)

C RC(O)CR=CRCHO + hv -> maleic anhydride + HO2. + R.
      CALL rou40(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)

C RC(O)CR=CRC(O)R + hv -> 4oxo2pentenal + R.
      CALL rou41(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)

C RC(O)CR=CRC(O)R + hv -> maleic anhydride + R. + R.
      CALL rou42(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)



****************************************************************

      IF (j2 .GT. kj) STOP '1002'
      RETURN
      END
