      SUBROUTINE pchem3(nw,wl,nz,tlev,airlev,
     $     j2,sq2,jlabel2,jlabel3)

*-----------------------------------------------------------------------------*
*=  PURPOSE:                                                                 =*
*=  Load various "weighting functions" (products of cross section and        =*
*=  quantum yield at each altitude and for wavelength).  The altitude        =*
*=  dependence is necessary to ensure the consideration of pressure and      =*
*=  temperature dependence of the cross sections or quantum yields.          =*
*=  The actual reading, evaluation and interpolation is done is separate     =*
*=  subroutines for ease of management and manipulation.  Please refer to    =*
*=  the inline documentation of the specific subroutines for detail          =*
*=  information.                                                             =*
*-----------------------------------------------------------------------------*
*=  PARAMETERS:                                                              =*
*=  NW     - INTEGER, number of specified intervals + 1 in working        (I)=*
*=           wavelength grid                                                 =*
*=  WL     - REAL, vector of lower limits of wavelength intervals in      (I)=*
*=           working wavelength grid                                         =*
*=  NZ     - INTEGER, number of altitude levels in working altitude grid  (I)=*
*=  TLEV   - REAL, temperature (K) at each specified altitude level       (I)=*
*=  AIRLEV - REAL, air density (molec/cc) at each altitude level          (I)=*
*=  J2     - INTEGER, counter for number of weighting functions defined  (IO)=*
*=  SQ2    - REAL, cross section x quantum yield (cm^2) for each          (O)=*
*=           photolysis reaction defined, at each defined wavelength and     =*
*=           at each defined altitude level                                  =*
*=  JLABEL2- CHARACTER*40, string identifier for each photolysis reaction (O)=*
*=           defined                                                         =*
*-----------------------------------------------------------------------------*
*=  EDIT HISTORY:                                                            =*
*=  05/98  Original; adapted from the "old" JSPEC1 routine                   =*
*-----------------------------------------------------------------------------*
*= This program is free software;  you can redistribute it and/or modify     =*
*= it under the terms of the GNU General Public License as published by the  =*
*= Free Software Foundation;  either version 2 of the license, or (at your   =*
*= option) any later version.                                                =*
*= The TUV package is distributed in the hope that it will be useful, but    =*
*= WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHANTIBI-  =*
*= LITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public     =*
*= License for more details.                                                 =*
*= To obtain a copy of the GNU General Public License, write to:             =*
*= Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.   =*
*-----------------------------------------------------------------------------*
*= To contact the authors, please mail to:                                   =*
*= Sasha Madronich, NCAR/ACD, P.O.Box 3000, Boulder, CO, 80307-3000, USA  or =*
*= send email to:  sasha@ucar.edu                                            =*
*-----------------------------------------------------------------------------*
*= Copyright (C) 1994,95,96  University Corporation for Atmospheric Research =*
*-----------------------------------------------------------------------------*

      IMPLICIT NONE
      INCLUDE 'params'

* input

      INTEGER nw
      REAL wl(kw)
      
      INTEGER nz

      REAL tlev(kz)
      REAL airlev(kz)

* weighting functions

      CHARACTER*40 jlabel2(kj),jlabel3(kj)
      REAL sq2(kj,kz,kw)

* input/output:
      INTEGER j2

* local:
      REAL wc(kw), wu(kw)
      INTEGER iw
*_______________________________________________________________________

* complete wavelength grid

      DO 5, iw = 1, nw - 1
         wc(iw) = (wl(iw) + wl(iw+1))/2.
         wu(iw) =  wl(iw+1)
 5    CONTINUE

*____________________________________________________________________________

 
      j2 = 0

C CH3ONO2 + hv ->  CH3O. + NO2
      CALL ro1(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)

C C2H5ONO2 + hv -> C2H5O. + NO2
      CALL ro2(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)

C n_C3H7ONO2 + hv -> n_C3H7O. + NO2
      CALL ro3(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)

C i_C3H7ONO2 + hv -> i_C3H7O. + NO2
      CALL ro4(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)

C 1_C4H9ONO2 + hv -> 1_C4H9O. + NO2
      CALL ro5(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)

C 2_C4H9ONO2 + hv -> 2_C4H9O. + NO2
      CALL ro6(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)

C tert_C4H9ONO2 + hv -> tert_C4H9O. + NO2
      CALL ro7(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)

C 1_C5H11ONO2 + hv -> 1_C5H11H9O. + NO2
      CALL ro8(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)

C 2_C5H11ONO2 + hv -> 2_C5H11H9O. + NO2
      CALL ro9(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)

C 3_C5H11ONO2 + hv -> 3_C5H11H9O. + NO2
      CALL ro10(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)

C 2methyl1propylnitrate + hv -> RO. + NO2
      CALL ro11(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)

C CH3OONO2 + hv -> CH3OO. + NO2
      CALL ro12(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)

C CH3OONO2 + hv -> CH3O. + NO3
      CALL ro13(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)

C PAN + hv -> CH3C(O)OO. + NO2
      CALL ro14(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)

C CH3CHO + hv -> CH3. + CHO.
      CALL ro17(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)

C C2H5CHO + hv -> C2H5. + CHO.
      CALL ro18(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)

C n-C3H7CHO + hv ->  n-C3H7. +  CHO.
      CALL ro19(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)

C n-C3H7CHO + hv -> C2H4 + CH3CHO
      CALL ro20(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)

C  i-C3H7CHO + hv -> C3H7. + CHO. 
      CALL ro21(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)

C 
C      CALL ro22(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)

C nC4H9CHO + hv -> C4H9. +  CHO.
       CALL ro23(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)

C nC4H9CHO + hv ->  CH3CHO + CH2=CHCH3 
      CALL ro24(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)

C iC4H9CHO + hv -> C4H9. + CHO.
      CALL ro25(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)
      
C  iC4H9CHO + hv -> CH3CHO +  CH2=CHCH3        
      CALL ro26(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)

C t-C4H9CHO + hv -> HCO. +  t-C4H9. 
      CALL ro27(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)

C n-C5H11CHO + hv -> HCO. + n-C5H11.
      CALL ro28(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)

C n-C5H11CHO + hv -> CH3CHO + CH2=CHCH2CH3
      CALL ro29(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)

C Acetone + hv -> CH3CO + CH3
      CALL ro30(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)

C CH3COC2H5 + hv -> C2H5. + CH3CO. 
      CALL ro31(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)

C  CH3COC2H5 + hv ->  CH3. + C2H5CO.
      CALL ro32(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)

C CH3COC3H7 + hv -> C3H7. + CH3CO. 
      CALL ro33(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)

C C2H5COC2H5 + hv -> C2H5CO. + C2H5.       
      CALL ro34(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)      

C (CH3)2CHCOCH(CH3)2 + hv -> (CH3)2CHCO(.) + C(.)H(CH3)2
      CALL ro35(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)

C CH3COCH2CH(CH3)2 + hv -> CH3CO. + CH2(.)CH(CH3)2 
      CALL ro36(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)

C CH3COCH2CH(CH3)2 + hv -> CH3COCH3 + CH2=CHCH3 
      CALL ro37(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)      

C CH3COCH2CH2CH(CH3)2 + hv -> CH3CO. + .CH2CH2CH(CH3)2  
      CALL ro38(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)      

C CH3COCH2CH2CH(CH3)2 + hv -> CH3COCH3 + CH2=C(CH3)2
      CALL ro39(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)      

C CH2=CHCHO + hv -> CH2CH=CHCO. + HO2. 
      CALL ro40(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)      

C  CH2=CHCHO + hv -> CH2=CH. + CHO. 
      CALL ro41(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)      

C CH2=CHCHO + hv -> CH3C(.)(.)H + CO
      CALL ro42(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)      

C CH2=C(CH3)CHO + hv -> CH2=C(.)CH3 +CHO. 
      CALL ro43(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)      

C CH2=C(CH3)CHO + hv -> CH3C(.)(.)CH3 + CO 
      CALL ro44(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)      

C CH2=C(CH3)CHO + hv -> CH2=C(CH3)C(.)O
      CALL ro45(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)      

C CH3CH=CHCHO + hv -> CH3CH=CH(.) + CHO.
      CALL ro46(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)      

C CH3CH=CHCHO + hv -> CH2CH=CHC(.)O + H.  
      CALL ro47(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)      

C CH3CH=CHCHO + hv -> CH3CH2CH(.)(.)H + CO 
      CALL ro48(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)      

C CH2=CHCOCH3 + hv -> CH2=CHCH3 + CO 
      CALL ro49(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)      

C CH2=CHCOCH3 + hv -> CH2=CH. + CH3CO. 
      CALL ro50(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)      

C CHOCHO + hv -> H2 + 2CO
      CALL ro51(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)      

C CHOCHO  + hv -> 2 CHO. 
      CALL ro52(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)      

C CHOCHO + hv -> H2CO + CO 
      CALL ro53(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)      

C CH3COCHO + hv -> CHO. + CH3CO. 
      CALL ro54(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)      

C CH3COCHO + hv -> CO + CH3CHO
      CALL ro55(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)      

C CH3COCHO + hv -> 2 CO + CH4
      CALL ro56(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)      

C CH3COCOCH3 + hv -> 2 CH3CO. 
      CALL ro57(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)      

C CHOCH=CHCH=CHCHO + hv ->  CHO. + .CH=CHCH=CHCHO
      CALL ro58(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)      

C CHOCH=CHCH=CHCHO + hv ->  CHOCH=CHCH=CHCO. + HO2. 
      CALL ro59(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)      

C 
C      CALL ro60(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)      

C CHOC(CH3)=CHCH=CHCHO + hv -> CHOC(CH3)=CHCH=CH. + .CHO
      CALL ro61(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)      

C CHOC(CH3)=CHCH=CHCHO + hv -> CHO. + .C(CH3)=CHCH=CHCHO
      CALL ro62(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)      

C CHOC(CH3)=CHCH=CHCHO + hv -> CHOC(CH3)=CHCH=CHCO. + HO2.
      CALL ro63(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)      

C CHOC(CH3)=CHCH=CHCHO + hv -> C(.)OC(CH3)=CHCH=CHCHO + HO2.
      CALL ro64(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)      

C CH3CH(ONO2)CH2(ONO2) + hv -> CH3CH(O.)CH2(ONO2) + NO2
      CALL ro65(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)      

C CH3CH(ONO2)CH2(ONO2) + hv -> CH3CH(ONO2)CH2O. + NO2 
      CALL ro66(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)      

C CH3CH2CH(ONO2)CH2(ONO2) + hv -> CH3CH2CH(O.)CH2(ONO2) + NO2
      CALL ro67(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)      

C CH3CH2CH(ONO2)CH2(ONO2) + hv -> CH3CH2CH(ONO2)CH2O. + NO2 
      CALL ro68(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)      

C CH3CH(ONO2)CH(ONO2)CH3 + hv -> CH3CH(O.)CH(ONO2)CH3 + NO2
      CALL ro69(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)      

C CH2(ONO2)CH(ONO2)CH=CH2 + hv -> CH2(ONO2)CH(O.)CH=CH2 + NO2
      CALL ro70(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)      

C CH2(ONO2)CH(ONO2)CH=CH2 + hv -> CH2(O.)CH(ONO2)CH=CH2 + NO
      CALL ro71(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)      

C CH2(ONO2)CH=CHCH2(ONO2) + hv ->CH2(ONO2)CH=CHCH2O. + NO2
      CALL ro72(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)      

C CH3OOH + hv -> CH3O.+ OH. 
      CALL ro73(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)      

C OHCH2CHO + hv -> OHCH2. + .CHO
      CALL ro74(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)      

C OHCH2CH2ONO2 + hv -> OHCH2CH2O. + NO2 
      CALL ro75(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)      

C OHCH2COCH3 + hv -> OHCH2. + .COCH3
      CALL ro76(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)      

C OHCH2OOH + hv -> OHCH2O. + .OH 
      CALL ro77(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)      

C CHOCOOH + hv -> CO2 + HCHO
      CALL ro78(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)      

C CHOCOOH + hv -> 2 CO + H2O
      CALL ro79(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)      

C COOH-COOH + hv -> CO2 + HCOOH
      CALL ro80(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)      

C COOH-COOH + hv -> CO2 + CO + H2O
      CALL ro81(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)      

C CH3COCOOH + hv -> CO2 + CH3CHO
      CALL ro82(nw,wl,wc,nz,tlev,airlev,j2,sq2,jlabel2,jlabel3)      

****************************************************************

      IF (j2 .GT. kj) STOP '1002'
      RETURN
      END
