#!/bin/bash
#----------------------------
# launch_gen_bundle.bash
#----------------------------
# this script must be launched from the $gecko_wkdir folder
# launch to geyser with arguments:
# inputs: $1 = gecko directory
# $2 = working directory inside mech dir
# $3 = $counter
# $4 = $numpre
# $5 = mechname
# $6 = prevflag

gecko_source=$1
gecko_wkdir=$2

counter=$3
numpre=$4
mech_name=$5
prevflag=$6

ref_dir=${gecko_wkdir}/spinup 

#----------------------------------#
# CHECK IF compiled codes exist
# YES -> link to them
# NO -> compile the generator
# re: compile_gecko.bash
#----------------------------------#

if [ -e ${ref_dir}/cm ] ; then
  ln -s ${ref_dir}/cm ${gecko_wkdir}/cm
else
  mkdir ${gecko_wkdir}/GECKO_CODE
  cp -r ${gecko_source}/* ${gecko_wkdir}/GECKO_CODE
  cd ${gecko_wkdir}/GECKO_CODE
  make clean
  make cm
fi

# the following assumes pre-compiled compteur and findname_cmv exist

ln -s ${gecko_source}/RUN/COMPTEUR/compteur ${gecko_wkdir}/compteur
ln -s ${gecko_source}/RUN/findname_cmv ${gecko_wkdir}/findname_cmv

#----------------------------------#
# link files etc 
# re: generate_scheme_cheyenne.bash
#----------------------------------#

ln -s ${gecko_wkdir}/GECKO_CODE/RUN/cm ${gecko_wkdir}/cm

#----------------------------------#
# generate the scheme
# re: generate_scheme_cheyenne.bash
#----------------------------------#
cd ${gecko_wkdir}

## single-submission way ...
# (edit 3 lines out out for multi-submission)
counter=0
until [ $counter -eq $numpre ]; do
  let counter=$counter+1

#----- either single- or multi-submission
echo starting $counter:$numpre

echo constructing management file
echo " &manage" > manage.input
# flag to read previous output : all except first iteration
if [ $counter -eq 1 ] && [ "$prevflag" != "y" ] ; then
  echo "     prevflag = 0" >> manage.input
else
  echo "     prevflag = 1" >> manage.input
  # make sure existing dict and mech are available
  if [ ! -e existing.dict ] ; then
    if [ ! -e fort.7 ] ; then
      cp fort.7 existing.dict
    else
      echo "no previous dictionary available => exiting"
      exit
    fi
  fi
  if [ ! -e existing.rxns ] ; then
    echo "no previous reaction list available => exiting"
    exit
  fi
# remove 'END' from pre-existing net reaction rate files
  if [ -e ./${mech_name}.kOH ] ; then 
    nend=$(grep -c END ./${mech_name}.kOH | awk '{ VAR += $1} END {print VAR}')
    if [ $nend > 0 ] ; then 
      head -n -1 ./${mech_name}.kOH > tmp.txt 
      mv tmp.txt ./${mech_name}.kOH 
    fi 
  fi

  if [ -e ./${mech_name}.kO3 ] ; then 
    nend=$(grep -c END ./${mech_name}.kO3 | awk '{ VAR += $1} END {print VAR}')
    if [ $nend > 0 ] ; then 
      head -n -1 ./${mech_name}.kO3 > tmp.txt 
      mv tmp.txt ./${mech_name}.kO3 
    fi 
  fi

  if [ -e ./${mech_name}.kNO3 ] ; then 
     nend=$(grep -c END ./${mech_name}.kNO3 | awk '{ VAR += $1} END {print VAR}')
    if [ $nend > 0 ] ; then 
       head -n -1 ./${mech_name}.kNO3 > tmp.txt 
       mv tmp.txt ./${mech_name}.kNO3 
    fi 
  fi

fi

# flag for post-processing : final iteration only
if [ $counter -ne $numpre ] ; then
  echo "     postflag = 0" >> manage.input
else
  echo "     postflag = 1" >> manage.input
fi
echo " /" >> manage.input

# run generator
./cm

if [ $? -eq 0 ] ; then
  echo generator has run successfully
else
  echo Mechanism generation failed
  exit
fi

# create continuation files for next iteration

if [ ! -e existing.rxns ] ; then
  cat fort.21 fort.17 > ${mech_name}.mech
  mv fort.17 existing.rxns
else
  cat existing.rxns fort.17 > tmp.txt ; mv tmp.txt existing.rxns
  cat fort.21 existing.rxns > ${mech_name}.mech
fi
cp fort.7 existing.dict

#== if existing.rxns ends with 'END', strip the last line
#-- (except for the last time around)

if [ $counter -ne $numpre ] ; then
  nend=$(grep -c END ./existing.rxns | awk '{ VAR += $1} END {print VAR}')
  if [ $nend > 0 ] ; then
    head -n -1  ./existing.rxns > tmp.txt
    mv tmp.txt ./existing.rxns
  fi
fi

# accumulate list of lumped species
  if [ -e fort.48 ] ; then
    if [ -e $mech_name.lump ] ; then
      cat $mech_name.lump fort.48 > tmp.txt ; mv tmp.txt $mech_name.lump
    else
      mv fort.48 $mech_name.lump ; fi
  fi

# accumulate net reaction rate lists
  if [ -e fort.70 ] ; then
    if [ -e $mech_name.kO3 ] ; then
      cat $mech_name.kO3 fort.70 > tmp.txt ; mv tmp.txt $mech_name.kO3
    else
      mv fort.70 $mech_name.kO3 ; fi
  fi

  if [ -e fort.71 ] ; then
    if [ -e $mech_name.kNO3 ] ; then
      cat $mech_name.kNO3 fort.71 > tmp.txt ; mv tmp.txt $mech_name.kNO3
    else
      mv fort.71 $mech_name.kNO3 ; fi
  fi

  if [ -e fort.72 ] ; then
    if [ -e $mech_name.kOH ] ; then
      cat $mech_name.kOH fort.72 > tmp.txt ; mv tmp.txt $mech_name.kOH
    else
      mv fort.72 $mech_name.kOH ; fi
  fi

#-- end run loop (single submission: else comment out 3 lines)
  echo done $counter:$numpre
  echo ---------------------------------------
done

# last time around: add 'END' to net reaction rate files
if [ $counter -eq $numpre ] ; then
    echo 'END' >> $mech_name.kOH
    echo 'END' >> $mech_name.kO3
    echo 'END' >> $mech_name.kNO3
fi

#----------------------------------#
# post-process the scheme
# re: postprocess_generator.bash
#----------------------------------#
home_dir=${gecko_source}/..
netcdf_flag="yes"
#----------------------------------#

# supercomputer-specific stuff here
source $home_dir/SCRIPTS/cheyenne_scripting_functions.bash
#--------------------

cd ${gecko_wkdir}
echo Counting RO2s...
./compteur

echo Finding primary species codes...
./findname_cmv > findname_output

echo 'rename files for mechanism ...'

mv difvol.dat $mech_name.difv
mv pnan.dat $mech_name.pnan
mv psim.dat $mech_name.psim
mv dHeatf.dat $mech_name.dHeatf
mv henry.dat $mech_name.Henry
if [ -e existing.log ] ; then
  cat existing.log scheme.log > $mech_name.log
  rm scheme.log
  rm existing.log
else
  mv scheme.log $mech_name.log
fi
mv fort.7 $mech_name.dict

if [ ! -e $mech_name.mech ] ; then
  mv fort.17 $mech_name.mech
fi

if [ -e fort.48 ] ; then
  if [ ! -e $mech_name.lump ] ; then
    sort -u fort.48 > $mech_name.lump
  else
    sort -u fort.48 >> $mech_name.lump
  fi
fi

echo tidy up ...

rm fort.*
rm dummy.*
rm sortlist.*
rm manage.input
rm existing.*

ln -s $mech_name.dict fort.7
ln -s $mech_name.mech fort.17

#==========================================
# RUN AKPARAMETER.H GENERATION
#==========================================

cd ${home_dir}/SCRIPTS
echo -----------------------------------------
echo run akparameter generation
./write_akparameter.bash ${mech_name}

#===========================================
# RUN INTERPRETER SCRIPT in SCRIPTS > $gecko_wkdir
#===========================================

echo ------------------------------------------
echo We are now in directory ...... ; pwd
echo ------------------------------------------

echo run interpreter...
./run_interp_automatic.bash ${mech_name}

cd $home_dir/SCRIPTS

