#!/bin/bash

#PRO diagnostics
#==================================================================
#PURPOSE:
#Process a completed GECKO-A mechanism and delete lines containing
# {string}
#INPUTS:
# - (where {file} is the name of the mechanism)
# - {file}.mech
#OUTPUT:
# - file.mech.new
#RUN LOCATION: dir 'WORK' containing results dir {FILE}
#==================================================================

if [ $# -ne 3 ]; then
  echo We need 3 input parameters
  #exit
  echo "enter home dir path"
  read home_dir
    if [ ${#home_dir} -eq 0 ] ; then echo "no value supplied" ; exit 2 ; fi
  echo "enter working dir path"
  read work_dir
   if [ ${#work_dir} -eq 0 ] ; then echo "no value supplied" ; exit 2 ; fi
  echo "enter mechanism name"
  read mech_name
    if [ ${#mech_name} -eq 0 ] ; then echo "no value supplied" ; exit 2 ; fi
else
  home_dir=$1
  work_dir=$2
  mech_name=$3
fi

echo 'work dir = ' $work_dir

#mechfile=${work_dir}'/test.mech'
mechfile=${work_dir}'/'${mech_name}'.mech'

nlin=`wc -l ${mechfile} | awk '{print $1}'`
string=HCL

sed -i.bak '/'$string'/d' $mechfile
