#!/bin/bash

source cheyenne_scripting_functions.bash


walltime="06:00:00"

if [ ! -e "setup.dat" ] ; then
    echo error, gecko setup file could not be found
    echo file paths must be set in script
    exit
fi
home_dir=`      grep "home_dir"      setup.dat | awk '{print $3}' `
gecko_version=` grep "gecko_version" setup.dat | awk '{print $3}' `
gecko_inp_dir=` grep "gecko_inp_dir" setup.dat | awk '{print $3}' `
scratch_dir=`   grep "scratch_dir"   setup.dat | awk '{print $3}' `
gecko_run_dir=` grep "gecko_run_dir" setup.dat | awk '{print $3}' `
boxmod_version=` grep "boxmod_version" setup.dat | awk '{print $3}' `
boxmod_run_dir=` grep "boxmod_run_dir" setup.dat | awk '{print $3}' `
postproc_version=` grep "postproc_version" setup.dat | awk '{print $3}' `
postproc_run_dir=` grep "postproc_run_dir" setup.dat | awk '{print $3}' `

inpdir="INPUT/ml_library"

boxmod_source=$home_dir/$boxmod_version
if [  ${#inpdir} -eq 0 ] ; then
    inpdir="INPUT"
fi
boxmod_inpdir=$boxmod_source/$inpdir


function replacekeywordwith () {
  file=$1
  keyword=$2
  replace=$3

  sed -i "s/${keyword}/${replace}/g" ${file}
}

function addinitconc () {
  file=$1
  mech=$2

  infofile=scenarios_ml_${mech}.csv
  tail -n +2 ${infofile} > tempfile
  while IFS=';' read -r name formula emission nc code wmol init_conc
  do
    echo REAC G${code} ${init_conc} 0.00E+00 >> ${file}
  done < tempfile

  rm tempfile 
}

function createscriptcallfromexpinfo () {
  expid=$1
  mech=$2
  scenar=$3
  temp=$4
  sza=$5
  seed=$6
  outfile=$7
  nthreads=$8

  # mechanism
  mechname=scenario_${mech}

  # photfile
   photfile=library.phot

  # create confile for spinup
  confile_spinup=init_conc_spinup_standard.key

  # create confile from initial concentrations and scenario
  confile=${scenar}_${mech}

  # create keyfile from temp, sza, seed
  keyfile=${expid}

  cp ${boxmod_inpdir}/indat_standard.key ${boxmod_inpdir}/indat_${keyfile}.key
  echo creating ${keyfile}

  replacekeywordwith ${boxmod_inpdir}/indat_${keyfile}.key seed_keyword ${seed}
  replacekeywordwith ${boxmod_inpdir}/indat_${keyfile}.key sza_keyword ${sza}
  replacekeywordwith ${boxmod_inpdir}/indat_${keyfile}.key temp_keyword ${temp}

    # run the boxmod for the spinup

  confile_spinup=init_conc_spinup_${scenar}.key

  spinup_run_cmd="./run_boxmod_local.bash  -u 1 -f ${inpdir} -c ${confile_spinup} -k ${keyfile} -p ${photfile} -m spinup"

    #run the boxmod

  boxmod_run_cmd="./run_boxmod_local.bash  -f ${inpdir} -c ${confile} -k ${keyfile} -p ${photfile} -m ${mechname}"

  #postproc run
  postproc_cmd="./run_postproc_local.bash -m ${mechname} -k ${keyfile}_${confile} -f postproc_flags_library.input"

  ## add everything to batch file, to be executed in parallel
  echo "${spinup_run_cmd};${boxmod_run_cmd}; ${postproc_cmd}" >> ${outfile}
}


mech_pool=(ARO1 ARO2 OLE1 OLE2 ALK4 ALK5 TERP)
scenar_pool=(remote remotecontinental continental pollutedcontinental urban)
temp_pool=(278 288 298 308)
sza_pool=(23 45 67)
seed_pool=(1e8 1e9 5e9 1e10 5e10)

#debug
#mech_pool=(ARO1)
#scenar_pool=(remote)
#temp_pool=(278)
#sza_pol=(23)
#seed_pool=(1e9)

exp_list_file=exp_list.csv

if [ -e ${exp_list_file} ] ; then
  rm ${exp_list_file}
fi

#echo "id, mech, scenar, temp, sza, seed" > ${exp_list_file}




n=0
# create experiences list
for mech in ${mech_pool[@]}; do
  
  for scenar in ${scenar_pool[@]}; do
  # create init conc file for mechanism and scenar
  confile=init_conc_${scenar}_${mech}.key
  cp ${boxmod_inpdir}/init_conc_${scenar}.key ${boxmod_inpdir}/${confile}
  addinitconc ${boxmod_inpdir}/${confile} ${mech}
    for temp in ${temp_pool[@]}; do
      for sza in ${sza_pool[@]}; do
        for seed in ${seed_pool[@]}; do
        #  echo exp${n},${mech},${scenar},${temp},${sza},${seed} >> ${exp_list_file}

	  expid=${mech}_${scenar}_${temp}_${sza}_${seed}
          createscriptcallfromexpinfo ${expid} ${mech} ${scenar} ${temp} ${sza} ${seed} ${exp_list_file}

          ((n++))
        done
      done
    done
  done
done


#let n_runs_per_batch=($n+$chop_into_how_many_batch_jobs-1)/$chop_into_how_many_batch_jobs

# one batch per mechanism
n_runs_per_batch=300

let "chop_into_how_many_batch_jobs=($n/$n_runs_per_batch)+1"
echo n runs per batch: $n_runs_per_batch
echo chop into ${chop_into_how_many_batch_jobs} jobs

i=0
for ((i_batchjob=0; i_batchjob<$chop_into_how_many_batch_jobs; i_batchjob++)); do
  start_run_id=$(($n_runs_per_batch*$i_batchjob))  
  stop_run_id=$(($n_runs_per_batch*($i_batchjob+1)-1))
  stop_run_id=$(( $n < $stop_run_id ? $n : $stop_run_id ))
  echo batch job id: $i_batchjob
  echo end runs: [$start_run_id, $stop_run_id]
    # ---------------------------------------------
  # grap only the fraction we need for this batch
  # ---------------------------------------------
  awk "NR >= $(($start_run_id+1)) && NR <= $(($stop_run_id+1))" ${exp_list_file} > batchjob_${i_batchjob}_${chop_into_how_many_batch_jobs}.bash
  nthreads=`wc -l batchjob_${i_batchjob}_${chop_into_how_many_batch_jobs}.bash | cut -f 1 -d" "`
  echo $nthreads

  write_cheyenne_multipsim_script \
   run_batchjob_${i_batchjob}_${chop_into_how_many_batch_jobs}.bash \
   batchjob_${i_batchjob}_${chop_into_how_many_batch_jobs} \
   ${walltime} \
   ${nthreads} \
   batchjob_${i_batchjob}_${chop_into_how_many_batch_jobs}.log \
   batchjob_${i_batchjob}_${chop_into_how_many_batch_jobs}.err \
   ./batchjob_${i_batchjob}_${chop_into_how_many_batch_jobs}.bash

  qsub ${home_dir}/GENERATED_SCRIPTS/run_batchjob_${i_batchjob}_${chop_into_how_many_batch_jobs}.bash

  
done

