module machine_learning
! this module produces output needed by machine learning
use conc

subroutine output_environ()

    real, dimension(:,:), allocatable      :: environ_params
    integer, parameter                     :: ind_time = 1, ind_rh = 2, ind_temp = 3, ind_pres = 4, &
    ind_sza = 5, ind_ho = 6, ind_ho2 = 7, ind_no = 8, ind_no2 = 9, ind_coa = 10, ind_o3 = 11, ind_co = 12, &
    ind_ch4 = 13
    character*(header_length)              :: header(ind_ch4)
    integer                                :: itime

    CHARACTER*(10)    :: date,time1,time2
    CALL date_and_time(date,time1)

    allocate(environ_params(ndat, ind_pres))

    do itime = 1, ndat
      environ_params(itime, ind_time) = time(itime)
      environ_params(itime, ind_rh)   = rh(itime)
      environ_params(itime, ind_temp) = temperature(itime)
    enddo

    deallocate(environ_params)
end subroutine output_environ


subroutine output_bins()


end subroutine output_bins


end module machine_learning