      PROGRAM findname_cmv
      IMPLICIT NONE
      INCLUDE 'general.h'

      INTEGER nprecu

      CHARACTER*(lco)  tname
      CHARACTER*(lfo)  tchem
      CHARACTER*(ldi)  line2

      INTEGER          i, found, nc, nca, cnum
      CHARACTER*(12)     format

      CHARACTER*(lfo), ALLOCATABLE ::  chem(:)
      CHARACTER*(lco), ALLOCATABLE   ::  nameoutput(:)

      OPEN(21,FILE='lstprim.out',STATUS='OLD')

      ! count number of precursors in lstprim.out
      i = 0
      DO
         READ(21,*,end = 10)
         i = i+1
      ENDDO
10    nprecu = i

      ALLOCATE(chem(nprecu), nameoutput(nprecu))
      chem = ' '
      nameoutput = ' '


      !properly read precursors
      REWIND(21)
      DO i=1, nprecu
            READ(21,*) chem(i)
            chem(i) = TRIM(chem(i))
      ENDDO
      CLOSE(21)


      WRITE(format, "(A2,i1,A5,i3, A1)") "(A", lco, ",3X,A", lfo, ")"
      !WRITE(6,*) format
      OPEN(22, FILE="fort.7", STATUS='OLD')
      found = 0
      DO
          line2 = ''
          READ(22,'(A150)') line2
          IF(index(line2,"***") .ne. 0) EXIT
          READ(line2, format) tname, tchem
          DO i = 1, nprecu
            IF(TRIM(tchem) .eq. TRIM(chem(i))) THEN
                  nameoutput(i) = trim(tname)
                  found = found + 1
                  EXIT
            ENDIF
          ENDDO
          if (found .eq. nprecu) EXIT
      ENDDO
      CLOSE(22)

      DO i = 1, nprecu
        nc = index(chem(i)," ") -1
        WRITE(6,*) nameoutput(i)(1:LEN_TRIM(nameoutput(i))),": ",
     &             chem(i)(1:LEN_TRIM(chem(i))),": ",cnum(chem(i),nc)
      ENDDO

      DEALLOCATE(chem, nameoutput)

      END PROGRAM findname_cmv

