************************************************************************
* MASTER MECHANISM - ROUTINE NAME :     writopesp                      *
*                                                                      *
* PURPOSE:  -  write required information to re-write the chemistry    * 
* with chemical operators for special species                          *
*                                                                      *
* INPUT                                                                *
*  a1      : comment col. 1  (usually type of reaction)                *
*  a2      : comment col. 2  (usually on/off switch)                   *
*  a3      : comment col. 18 (usually arrow or split counter)          *
*  a4      : comment col. 19 (usually reaction channel letter)         *
*  r(3)    : array of reagents                                         *
*  s(mnp)  : array of stoichiometry coefficients                       *
*  p(mnp)  : array of products                                         *
*  ar1     : first arrhenius coefficient                               *
*  ar2     : second arrhenius coefficient (power in T)                 *
*  ar3     : third arrhenius coefficient (Ea/T)                        *
*  f298    : rate constant at 298 K (for the "full" reaction)          *
*  fratio  : branching ratio for the given rection at 298 K            *
*  idreac  : ID for the type of reaction (thermal, HV, EXTRA, M ...)   *
*  nlab    : label if the reaction is not thermal                      *
*  xlab    : weighting factor for HV reaction                          *
*                                                                      *
* no output                                                            *
************************************************************************
      SUBROUTINE writopesp(a1,a2,a3,a4,r,s,p,ar1,ar2,ar3,
     &                   f298,fratio,idreac,nlab,xlab)
      IMPLICIT NONE      
      INCLUDE 'general.h'

* input
      CHARACTER*1     a1,a2,a3,a4
      CHARACTER*(lco) r(3), p(mnp)
      REAL            s(mnp),ar1,ar2,ar3,f298,fratio
      INTEGER         idreac, nlab
      REAL            xlab
*internal
      INTEGER         i

      IF (idreac.NE.0) THEN
        IF (idreac.EQ.1) THEN
          WRITE(10,'(A15,A1,A6,A4,1X,a5,i5,3X,f4.2,a1)')
     &    '**** INIT HV + ','G',r(1),'*****',' HV /',nlab,xlab,'/'
     	  DO i= 1,mnp
	    IF (p(i).NE.' ') WRITE(10,'(f5.3,2X,A1,A6)') s(i),'G', p(i)
	  ENDDO
          WRITE(10,*)'end'
        ELSE
            WRITE(10,'(A18,A6,A4,1X,A7,i5,a1)')
     &      '****INIT EXTRA + G',r(1),'****','EXTRA /',nlab,'/'
     	  DO i= 1,mnp
	    IF (p(i).NE.' ') WRITE(10,'(f5.3,2X,A1,A6)') s(i),'G', p(i)
	  ENDDO
          WRITE(10,*)'end'
	ENDIF
      ELSE
        IF (r(3).EQ.' ') THEN
	  IF (r(2).EQ.' ') THEN
            WRITE(10,'(A10,A6,A4,1X,ES10.3,1X,f4.1,1X,f7.0)')
     &      '****INIT G',r(1),'****',ar1,ar2,ar3
     	  ELSE
            WRITE(10,'(A10,A6,A3,A6,A4,1X,ES10.3,1X,f4.1,1X,f7.0)')
     &      '****INIT G',r(2),'+ G',r(1),'****',ar1,ar2,ar3
	  ENDIF  
	  DO i= 1,mnp
	    IF (p(i).NE.' ') THEN
	      IF (s(i).LT.0.) THEN
	        WRITE(10,'(f5.2,2X,A1,A6)') s(i), 'G',p(i)
	      ELSE  
	        WRITE(10,'(f5.3,2X,A1,A6)') s(i), 'G',p(i)
	      ENDIF
	    ENDIF  
	  ENDDO
          WRITE(10,*)'end'
        ELSE
	  WRITE(6,*) 'WARNING from writopesp.f'
	  WRITE(6,*) 'Reaction with 3 reactants : ',r(1),r(2),r(3)
	  STOP
	ENDIF	 
      ENDIF
      RETURN	        
      END
