************************************************************************
* MASTER MECHANISM - ROUTINE NAME : sthindrance                             *
*                                                                      *
* PURPOSE :                                                            *
*  Calculates the number of carbon atoms linked to one side of a       *
*     double bond.                                                     *
*  The length of each track starting from the carbon atom is added     *
*   !!  except the track starting with a double bond !!                *
*                                                                      *
*                                                                      *
* INPUT:                                                               *
* - chem         : chemical formula                                    *
* - bond(i,j)    : carbon-carbon bond matrix                           *
* - nca          : number of group                                     *
* - top          : starting node number                                *
*                                                                      *
* OUTPUT:                                                              *
* - sthindrance  : size of the carbon skelton linked to atom top       *
*                !! not counting the double bond !!                    *
************************************************************************

      SUBROUTINE sthindrance_cmv(top, chem, bond, nca, sthindrance)

      IMPLICIT NONE
      INCLUDE 'general.h'
* input
      CHARACTER*(lfo)   :: chem
      INTEGER           :: top
      INTEGER           :: nca
      INTEGER           :: bond(mca,mca)

* output
      INTEGER           :: sthindrance

* internal:
      INTEGER           :: track(mco,mca)
      INTEGER           :: trlen(mco)
      INTEGER           :: ntr
      LOGICAL           :: db_flag
      INTEGER           :: i

      CHARACTER(lsb) :: progname='*sthindrance_cmv*   '
      CHARACTER(ler) :: mesg

      ! check that top is linked to a double bond
      db_flag = .FALSE.
      DO i = 1, nca
        if(bond(top, i) .eq. 2) THEN
          db_flag = .TRUE.
          EXIT
        ENDIF
      ENDDO
      IF(.not. db_flag) THEN ! no double bond found next to top
        mesg ='double bond could not be found next to atom top'
        CALL errexit(progname,mesg,chem)
      ENDIF

      CALL gettrack(bond,top,nca,ntr,track,trlen)

      IF (ntr .eq. 1) THEN ! only one track, it must be the track
      ! starting at the double bond. So nothing to count
        sthindrance = 0
        RETURN
      ENDIF

      sthindrance = 0
      DO i = 1, ntr
        IF (bond(top, track(i, 2)) .eq. 2) THEN
        ! dont count the track starting with a double bond
          CYCLE
        ENDIF
        sthindrance = sthindrance + trlen(i) - 1 ! 01 because we don't count the top node
      ENDDO

      RETURN
      END SUBROUTINE