************************************************************************
* MASTER MECHANISM - ROUTINE NAME  srch                                *
*                                                                      *
* PURPOSE: Binary tree search of the species chem in the list of       *
*          recorded formulae in the dictionary                         *
*                                                                      *
* The value returned is NEGATIVE if chem not found (srch point where   *
* chem must be inserted) and is POSITIVE if chem is found (srch then   *
* gives the position of chem in the array)                             *
*                                                                      *
* INPUT:                                                               *
*  - ic          : number of carbon in chem                            *
*  - max         : number of record in the dict table for ic carbon    *
*  - chem        : formula of the species which is searched in dict    *
*                  must be given                                       *
*  - dict(i,j)   : dictionary line (name + formula + functional        *
*                  group info) of species number j having i carbons    *
*                                                                      *
* OUTPUT:                                                              *
*  - srch        : position in the table                               *
************************************************************************
      INTEGER FUNCTION srch(max,chem,dict)
      IMPLICIT NONE
      INCLUDE 'general.h'

* input:
      INTEGER         max
      CHARACTER*(lfo) chem
      CHARACTER*(ldi) dict(mni)

* output : integer value for srch

* internal:
      INTEGER         jhi, jlo, jold, j

* initialize:
      srch = 0
      jold = 0
      jlo  = 1
      jhi  = max + 1

* search

10    j = (jhi+jlo)/2
      IF (j.EQ.jold) GOTO 40
      jold = j
      IF (chem.GT.dict(j)(10:129)) GOTO 20
      IF (chem.EQ.dict(j)(10:129)) GOTO 30
      jhi  = j
      GO TO 10

20    jlo  = j
      GOTO 10

30    srch = j
      RETURN

40    srch = -j

* end of srch
      RETURN
      END
