************************************************************************
* MASTER MECHANISM - ROUTINE NAME :      rxinit3                       *
*                                                                      *
* PURPOSE:  -  Initializes the reaction line (see also rxwrit3).       *
*                                                                      *
* ON INPUT AND OUTPUT                                                  *
*  A1     : comment col. 1  (usually type of reaction)                 *
*  A2     : comment col. 2  (usually on/off switch)                    *
*  A3     : comment col. 18 (usually arrow or split counter)           *
*  A4     : comment col. 19 (usually reaction channel letter)          *
*  R(3)   : array of reagents                                          *
*  S(20)  : array of stoichiometry coefficients                        *
*  P(20)  : array of products                                          *
*  ar1    : first arrhenius coefficient                                *
*  ar2    : second arrhenius coefficient (power in T)                  *
*  ar3    : third arrhenius coefficient (Ea/T)                         *
*  f298   : rate constant at 298 K (for the "full" reaction)           *
*  fratio : branching ratio for the given rection at 298 K             *
*  idreac : ID for the type of reaction (thermal, HV, EXTRA, M ...)    *
*  nlab   : label if the reaction is not thermal                       *
*  xlab   : weighting factor for HV reaction                           *
*  folow  : low pressure fall off arrhenius coefficient                *
*  fotroe : troe parameter for fall off reaction                       *
***************************************************************************
      SUBROUTINE rxinit3(a1,a2,a3,a4,r,s,p,ar1,ar2,ar3,
     &                   f298,fratio,idreac,nlabel,xlabel,folow,fotroe)
      IMPLICIT NONE
      INCLUDE 'general.h'

* input/output
      CHARACTER*1     a1,a2,a3,a4
      CHARACTER*(lco) r(3), p(mnp)
      INTEGER         idreac, nlabel
      REAL            s(mnp),ar1,ar2,ar3,f298,fratio,xlabel
      REAL            folow(3),fotroe(4) 
* internal
      INTEGER i

      a1 = ' '
      a2 = ' '
      a3 = ' '
      a4 = ' '
      DO i=1,3
         r(i) = ' '
      ENDDO
      DO i=1,mnp
         s(i) = 0.
         p(i) = ' '
      ENDDO
      ar1 = 0.
      ar2 = 0.
      ar3 = 0.
      f298 = 0.
      fratio = 0.

      idreac=0
      nlabel=0
      xlabel=0.
      DO i=1,3
         folow(i)=0.
      ENDDO
      DO i=1,4
         fotroe(i)=0.
      ENDDO

      RETURN
      END
