************************************************************************
* MASTER MECHANISM - ROUTINE NAME : revers                             *
*                                                                      *
*                                                                      *
* PURPOSE: Write the reverse of chemical formula in COPY to output     *
*                                                                      *
*   The chain in input formula is written from right to left.          *
*                                                                      *
*                                                                      *
* INPUT:                                                               *
* - copy         : input chemical formula                              *
*                                                                      *
* OUTPUT:                                                              *
* - copy         : output chemical formula, reversed                   *
************************************************************************
      SUBROUTINE revers(copy,cc)
      IMPLICIT NONE
      INCLUDE 'general.h'

* input:
      CHARACTER*(lfo) copy

* output:
      CHARACTER*(lfo) cc

* internal:
      INTEGER  begin,iend,p,i,lng

      !print*,'*revers*'
* initialize
* ----------
      p = 0
      cc = ' '
      begin = 1
      iend = INDEX(copy,' ') - 1
      lng=iend

* reverse formula
* ---------------
      DO i=lng,1,-1
        IF (copy(i:i).EQ.')') p = p + 1
        IF (copy(i:i).EQ.'(') p = p - 1
        IF (p.EQ.0) THEN
          IF (copy(i:i).EQ.'C'.OR.copy(i:i).EQ.'c') THEN
            IF (copy(i:i+1).NE.'Cl') THEN
              cc(begin:begin+iend-i) = copy(i:iend)
              begin = begin + iend - i + 1
              iend = i - 1
            ENDIF
          ENDIF
          IF (copy(i:i+2).eq.'-O-') THEN
            cc(begin:begin+2)='-O-'
            begin=begin+3
            iend=i-1
          ELSE IF (copy(i:i+3).eq.'-O1-') THEN
            cc(begin:begin+3)='-O1-'
            begin=begin+4
            iend=i-1
          ELSE IF (copy(i:i+3).eq.'-O2-') THEN
            cc(begin:begin+3)='-O2-'
            begin=begin+4
            iend=i-1
          ENDIF
        ENDIF
      ENDDO

      RETURN
      END
