* this subroutine takes the two ends of the linear string formed after
* ring-opening, and joins them at the artificial 'break' in the old ring.
* Also good for rearranging rings after elimination of a branch.
! CREATED: June/July 2005, Julia Lee-TAYLOR, NCAR                 !
*******************************************************************
      SUBROUTINE rejoin(nca,x,y,x1,y1,bond,group)
      IMPLICIT NONE
      INCLUDE "general.h"
      INCLUDE "common.h"

* input:
      INTEGER   nca,x,y
* in/out:
      INTEGER   bond(mca,mca)
      CHARACTER*(lgr) group(mca)
* output:
      INTEGER   x1,y1 ! new identities of x,y
* local:
      INTEGER   i,j,ii,jj,icut
      INTEGER   tbond(mca,mca)
      CHARACTER*(lgr) tgroup(mca)

*-----------------------------------------------
      IF (wtflag.NE.0) WRITE(*,*) '*rejoin*'

* troubleshooting
      !DO i=1,nca
      !  write(6,'(a10,10(i2))'),group(i),(bond(j,i),j=1,nca)
      !ENDDO
      !print*,' '

      IF(x.GT.y)THEN
        icut=x-1
      ELSE
        icut=y-1
      ENDIF
      x1=x-icut
      IF(x1.LE.0) x1=x1+nca
      y1=y-icut
      IF(y1.LE.0) y1=y1+nca

* switch positions of two ends of molecule: stage 1      
      DO i=1,icut
        ii=nca-icut+i
        tgroup(ii)=group(i)
        DO j=1,nca
          tbond(ii,j)=bond(i,j)
        ENDDO
      ENDDO
      DO i=icut+1,nca
        ii=i-icut
        tgroup(ii)=group(i)
        DO j=1,nca
          tbond(ii,j)=bond(i,j)
        ENDDO
      ENDDO

* replace bond matrix with interim solution
      DO i=1,nca
        DO j=1,nca
          bond(i,j)=tbond(i,j)
        ENDDO
      ENDDO

* switch positions of two ends of molecule: stage 2      
      DO i=1,nca
        DO j=1,icut
          jj=nca-icut+j
          tbond(i,jj)=bond(i,j)
        ENDDO
        DO j=icut+1,nca
          jj=j-icut
          tbond(i,jj)=bond(i,j)
        ENDDO
      ENDDO

* replace bond matrix and groups with final solution
      DO i=1,nca
        group(i)=tgroup(i)
        DO j=1,nca
          bond(i,j)=tbond(i,j)
        ENDDO
      ENDDO

* troubleshooting
      !DO i=1,nca
      !  write(6,'(a10,10(i2))'),group(i),(bond(j,i),j=1,nca)
      !ENDDO
      !print*,' '

      RETURN
      END
          
