      SUBROUTINE rdhydrat(filename,nhydratdat,chemhydrat,hydratdat)


      IMPLICIT NONE
      INCLUDE 'general.h'
!INPUT
      CHARACTER*(llin) filename

!OUTPUT
      INTEGER          nhydratdat
      CHARACTER*(lfo)  chemhydrat(mrd)
      REAL             hydratdat(mrd)

!LOCAL
      CHARACTER*(200)  line
      INTEGER          i,j,n1,n2
! Initialize
      nhydratdat= 0
      DO i=1,mrd
        chemhydrat(i)=' '
        hydratdat(i)=0.0
      ENDDO


! open the file
      OPEN(10,FILE=filename, FORM='FORMATTED',STATUS='OLD')


! read the data
      DO 10 j=1,10000
        READ (10,'(a)',end=222) line
        IF (line(1:3).eq.'END') GOTO 20
        IF (line(1:1).eq.'*') GOTO 10

! check that the line is correctly formatted
        n1=index(line,':')
        IF (n1.eq.0) THEN
          WRITE (6,'(a)') '--error--, while reading', filename
          WRITE (6,'(a)') 'in subroutine rdhenry'
          WRITE (6,'(a)') 'character ":" not found in line :'
          WRITE (6,'(a)') line
          STOP
        ENDIF
        n2=index(line,';')
        IF (n2.eq.0) THEN
          WRITE (6,'(a)') '--error--, while reading', filename
          WRITE (6,'(a)') 'in subroutine rdhenry'
          WRITE (6,'(a)') 'character ";" not found in line :'
          WRITE (6,'(a)') line
          STOP
        ENDIF

        nhydratdat=nhydratdat+1
        IF (nhydratdat.gt.mrd) THEN
          WRITE (6,'(a)') '--error--, while reading', filename
          WRITE (6,'(a)') 'in subroutine rdhenry'
          WRITE (6,'(a)') 'ndat is greater than mrd'
          STOP
        ENDIF
        chemhydrat(nhydratdat)=line(1:n1-1)
        READ(line(n1+1:n2-1),*,err=333) hydratdat(nhydratdat)
        !hydratdat(nhydratdat)=line(n1+1:n2-1)

! check that the given species is correctly written        
        CALL stdchm(chemhydrat(nhydratdat))
        
10    CONTINUE

20    CONTINUE
      CLOSE(10)


      do i=1,nhydratdat
        write(89,*) hydratdat(i)
      enddo
! check that the species is only given one time
      DO i=1,nhydratdat-1
        DO j=i+1,nhydratdat
          IF (chemhydrat(i).EQ.chemhydrat(j)) THEN
             WRITE(6,'(a)') '--error--, while reading', filename
             WRITE(6,'(a)') 'in subroutine rdhenry'
             WRITE(6,'(a)') 'the species :',chemhydrat(i)
             WRITE(6,'(a)') 'was found more than 1 time'
             STOP
          ENDIF
        ENDDO
      ENDDO

      RETURN

222   WRITE(6,*) '--error222--, while reading', filename
      WRITE(6,*) '              in subroutine rdhenry'
      WRITE(6,*) '            , keyword END not found'
      STOP
333   WRITE(6,*) '--error333--, at line below while reading', filename
      WRITE(6,*) '              in subroutine rdhenry'
      WRITE(6,*) line
      STOP
      END
