      SUBROUTINE rdhenry(filename,nhenrydat,chemhenry,henrydat,
     &          nhydratdat,hydratdat,chemhydrat)


      IMPLICIT NONE
      INCLUDE 'general.h'

!INPUT
      CHARACTER*(llin) filename
      CHARACTER*(lfo) chemhydrat(mrd)
      INTEGER         nhydratdat
      REAL            hydratdat(mrd)

!OUTPUT
      INTEGER          nhenrydat
      CHARACTER*(lfo)  chemhenry(mrd)
      REAL             henrydat(mrd,3)

!LOCAL
      CHARACTER*(200)  line
      INTEGER          i,j,n1,n2
      INTEGER         nwa
      CHARACTER*(lfo) chemhyd(mhyd,mhiso)
      REAL            yhyd(mhyd,mhiso)
      INTEGER         nhyd(mhyd)
      REAL            khydstar

      CHARACTER(lsb) :: progname='*rdhenry*   '
      CHARACTER(ler) :: mesg

!--------------
! Initialize
!--------------
      nhenrydat = 0
      chemhenry = ' '
      henrydat  = 0.0

! open the file
      OPEN(10,FILE=filename, FORM='FORMATTED',STATUS='OLD')

! read the data
      DO 10 j=1,10000
        READ (10,'(a)',end=222) line
        IF (line(1:3).eq.'END') GOTO 20
        IF (line(1:1).eq.'*') GOTO 10

! check that the line is correctly formatted
        n1=index(line,':')
        IF (n1.eq.0) THEN
          mesg = 'character ":" not found in line :'
          CALL errexit(progname,mesg,line)
        ENDIF

        n2=index(line,';')
        IF (n2.eq.0) THEN
          mesg = 'character ";" not found in line :'
          CALL errexit(progname,mesg,line)
        ENDIF

        nhenrydat=nhenrydat+1
        IF (nhenrydat.gt.mrd) THEN
          mesg = 'ndat is greater than mrd'
          CALL errexit(progname,mesg,line)
        ENDIF

        chemhenry(nhenrydat)=line(1:n1-1)
        READ(line(n1+1:n2-1),*,err=333) (henrydat(nhenrydat,i),i=1,3)

! check that the given species is correctly written        
        CALL stdchm(chemhenry(nhenrydat))
        
! estimate hydration constant in order to calculate intrinsic  HLC*
        IF (chemhenry(nhenrydat)(1:7).ne.'CHO(OH)') THEN        
          CALL get_hydrate(chemhenry(nhenrydat),nwa,nhyd,chemhyd,yhyd,
     &                     khydstar,nhydratdat,hydratdat,chemhydrat)
          henrydat(nhenrydat,1)=henrydat(nhenrydat,1)/(1.+khydstar)
        ENDIF

!convert read henry constant to log(henry)
        henrydat(nhenrydat,1)=log10(henrydat(nhenrydat,1))
       
10    CONTINUE
20    CONTINUE
      CLOSE(10)

!      do i=1,nhenrydat
!        write(89,*) chemhenry(i),henrydat(i,1)
!      enddo

! check that the species is only given once
      DO i=1,nhenrydat-1
        DO j=i+1,nhenrydat
          IF (chemhenry(i).EQ.chemhenry(j)) THEN
            mesg = 'species found more than once in input file'
            CALL errexit(progname,mesg,chemhenry(i))
          ENDIF
        ENDDO
      ENDDO

      RETURN

222   mesg = '--error222--: keyword END not found in input file'
      CALL errexit(progname,mesg,filename)

333   mesg = '--error333--: reading next line from input file'
      CALL errexit(progname,mesg,line)

      END

