!-----------------------------------------------------------------!
! PURPOSE: update rank of nodes in chem. formula by finding and   !
! ranking the product of adjacent primes of input rank            !  
! CREATED: June/July 2005, Julia Lee-TAYLOR, NCAR                 !
!-----------------------------------------------------------------!
      SUBROUTINE primes(nca,bond,rank)
      IMPLICIT NONE
      include 'general.h'

! input: 
      INTEGER    nca
      INTEGER    bond(mca,mca)

! i/o:
      INTEGER    rank(mca)  ! rank of nodes, in order supplied
! output: 
      INTEGER    ppb(mca,mca) ! product of primes of nodes in bond

! internal:
      INTEGER    i,j,maxr,test,ctr
      INTEGER    prim(30)   ! prime numbers
      INTEGER    cprim(mca) ! prime corresponding to node's rank
      INTEGER    pp(mca)    ! product of primes of adjacent nodes
      INTEGER    prank(mca,3) ! rank pairs (node index, input rank, pp)
      DATA prim/  2,  3,  5,  7, 11, 13, 17, 19, 23, 29, 
     &           31, 37, 41, 43, 47, 53, 59, 61, 67, 71, 
     &           73, 79, 83, 89, 97,101,103,107,109,113/

!---------------------------
      !print*,'*primes*'
! re-entry point if iteration required
99    CONTINUE
      !print*,'calculating primes'

! assign primes
      DO i=1,nca
        cprim(i)=prim(rank(i))
        pp(i)=1
      ENDDO

! find product of connected primes for nodes
      DO i=1,nca
        DO j=1,nca
          IF(i.NE.j.AND.bond(i,j).GT.0) pp(i)=pp(i)*cprim(j)
        ENDDO
      ENDDO

!  construct rank vectors for nodes
      maxr = 0
      DO i=1,nca
        prank(i,1) = i
        prank(i,2) = rank(i)
        prank(i,3) = pp(i)
        !print*,prank(i,:)
        maxr = max0(maxr,rank(i))
        rank(i)=0
      ENDDO

      CALL sortrank(nca,prank,rank)

! if rank changed: need to iterate again
      !print*,''
      !print*,'node, new rank' 
      DO i=1,nca
      !  write(6,'(2(4x,i2,2x))'),i,rank(i)
        IF(rank(i).NE.prank(i,2)) GO TO 99
      ENDDO

      !print*,'*end primes*'
      RETURN

      END
