************************************************************************
* MASTER MECHANISM - ROUTINE NAME : prevdict                           *
*                                                                      *
* PURPOSE: - read the species that were generated by a previous run    *
*            of the program (including inorganic, C1 species).         *
*          - initialize the "species" tables (dict, namlst)            *
*                                                                      *
* INPUT:   none                                                        *
*                                                                      *
* OUTPUT:                                                              *
*  - ninorg      : number of inorganic species                         *
*  - nrec        : number of species recorded                          *
*  - nrectot     : total number of records (not including inorganic)   *
*  - dict(j)     : dictionary line (name + formula + functional        *
*                  group info) of species number j                     *
*  - namlst(j)   : name (lco=6 characters) of the species already      *
*                  used  at position number j                          *
*  - inorglst(j) : list of inorganic species - includes the name +     *
*                  formula + functional group info                     *
************************************************************************
      SUBROUTINE prevdict(ninorg,nrec,nrectot,
     &                  dict,namlst,inorglst)
      IMPLICIT NONE
      INCLUDE 'general.h'

* output
      INTEGER         ninorg,nrectot,nrec
      CHARACTER*(ldi) dict(mni)
      CHARACTER*(lco) namlst(mni)
      CHARACTER*(ldi) inorglst(mfn)

*local
      CHARACTER*(ldi) line
      CHARACTER(LEN=3) :: cldi
      INTEGER         i,j
      INTEGER         cnum,onum,nc,nca

* initialize
      nrectot = 0
        nrec = 1
      ninorg = 0
      DO i=1,100
        inorglst(i) = ' '
      ENDDO
      DO i=1,mni
        dict(i)=' '
        namlst(i)=' '
      ENDDO

      dict(1)='####################'
      namlst(1)='######'

      WRITE(cldi,'(i3)') ldi

*  read dictionary: pre-sorted by 100-char chemical formula variable,
*  since it will be searched using a binary tree search 
*  later in the program (see 'srch'):

* !! file existing.dict must be available in directory RUN !!
      OPEN (10,file='existing.dict',
     &         form='FORMATTED', status='OLD')

      DO 10 i=1,mni+1
        READ(10,'(a'//cldi//')',err=999, END=222) line
        IF (line(1:1).EQ.'*') GOTO 15  ! end of file
        !IF (MOD(i,1000).EQ.0) print*,line(1:50)

* get the number of C + '-O-'
        nc = index(line(10:120),' ') - 1
        nca = cnum(line(10:nc),nc)+onum(line(10:nc),nc)

* if carbons, or special species, store data in dict(1,*), namlst(1,*)
        IF (nca.GT.0.OR.line(10:10).EQ.'#') THEN
          nrec = nrec + 1
          IF (nrec.GT.mni) THEN
            WRITE (6,*) 'error in rddict, number of records exceeds mni'
            STOP
          ENDIF  
          nrectot = nrectot + 1
          dict(nrec) = line
          namlst(nrec) = line(1:6)

* if no carbons, store data in inorglst 
        ELSE
          ninorg = ninorg + 1
          inorglst(ninorg) = line
         ENDIF  
10    CONTINUE
      STOP
15    CLOSE(10)
      RETURN

222   WRITE (6,*) '--error222--, while reading existing.dict'
      WRITE (6,*) '              keyword end not found'
      STOP

999   WRITE (6,*) '--error999--, while reading singlec_dic.dat'
      STOP

      END
