!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!                                                          !
! Subroutine to compute rate constant according to         !
! Jenkin 215 (MAGNIFY project)                             !
!                                                          !
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
      SUBROUTINE o3rate(bond,group,nca,conjug,cdtable,cdsub,
     &           ic1,ic2,arrhc)
      IMPLICIT NONE
      INCLUDE 'general.h'
      INCLUDE 'common.h'

! input:
      INTEGER,intent(in)         :: bond(mca,mca)
      CHARACTER*(lgr),intent(in) :: group(mca)
      INTEGER,intent(in)         :: nca, conjug
      INTEGER,intent(in)         :: cdtable(4),cdsub(4)
      INTEGER,intent(in)         :: ic1,ic2
! output
      REAL,intent(out)           :: arrhc(3)
!internal
      INTEGER                    :: i,j,k
      INTEGER                    :: nb
      REAL                       :: mult
      INTEGER                    :: rngflg,rgord
      INTEGER                    :: ring(mca)

!initialize
      arrhc(:) = 0

      IF (conjug.EQ.0) THEN
!!!!!!!!!!!!!!!!!!!
!   monoalkenes   !
!!!!!!!!!!!!!!!!!!!

! assign the rate constant
      nb=cdsub(ic1)+cdsub(ic2)

! ethene
      IF (nb.eq.0) THEN
        arrhc(1)=9.14E-15
        arrhc(3) = 2580
! -CH=CH2
      ELSE IF (nb.eq.1) THEN
        arrhc(1) =2.91E-15
        arrhc(3) = 1690
! -CH=CH- or >C=CH2
      ELSE IF (nb.eq.2) THEN
        IF (cdsub(ic1).eq.1) THEN
          arrhc(1) = 5.34E-15
          arrhc(3) = 1057
        ELSE
          arrhc(1) = 4.00E-15
          arrhc(3) = 1685
        ENDIF
! >C=CH-
      ELSE IF (nb.eq.3) THEN
        arrhc(1) = 7.61E-15
        arrhc(3) = 830
! >C=C<
      ELSE IF (nb .eq.4) THEN
        arrhc(1) = 2.96E-15
        arrhc(3) = 295
      ELSE
        WRITE(6,*) '-error1-- in O3rate, no rate constant found '
        WRITE(6,*) 'o3rate, nb=',nb
        STOP
      ENDIF

      mult = 1.0
      DO i=1,nca
        IF (group(i)(1:2).EQ.'Cd') THEN
          DO j=1,nca
            IF (bond(i,j).EQ.1) THEN
              IF (group(j)(1:4).EQ.'CH3 ') THEN
                mult = 1.0
              ELSE IF (group(j)(1:4).EQ.'CH2 ') THEN
                mult = 1.0
              ELSE IF (group(j)(1:2).EQ.'CH') THEN
                mult = 0.51
              ELSE IF (group(j)(1:1).EQ.'C') THEN
                mult = 0.32
              ENDIF
            ENDIF
          ENDDO
        ENDIF
      ENDDO

      arrhc(1) = arrhc(1) * mult

      mult = 1.0
      CALL findring(cdtable(ic1),cdtable(ic2),nca,bond,rngflg,ring)
      IF (rngflg.EQ.1) THEN
! count ring members
        rgord=0
        DO j=1,nca
          rgord=rgord+ring(j)
        ENDDO
! rings with rgord > 5 have mult=1
        IF (rgord.EQ.5) mult=3.10  ! 5 members
        IF (rgord.EQ.6) mult=0.44  ! 6 members
        IF (rgord.EQ.7) mult=2.00  ! 7 members
        IF (rgord.EQ.8) mult=2.50  ! 8 members
        IF (rgord.EQ.10) mult=0.24  ! 10 members
        arrhc(1) = arrhc(1) * mult
      ENDIF

      ELSE
!!!!!!!!!!!!!!!!!!!
! conjugated polyalkenes
!!!!!!!!!!!!!!!!!!!
! set the rate constant
      arrhc(1) = 10E-15
      nb=cdsub(1)+cdsub(2)+cdsub(3)+cdsub(4)

      IF (nb.EQ.2) arrhc(3) = 1677
      IF (nb.EQ.3) arrhc(3) = 1980

      IF (nb.EQ.4) THEN
        IF ((cdsub(1).EQ.0).AND.(cdsub(4).EQ.0)) arrhc(3) = 1774
        IF ((cdsub(2).EQ.2).AND.(cdsub(3).EQ.1)) arrhc(3) = 1439
        IF ((cdsub(2).EQ.1).AND.(cdsub(3).EQ.2).AND.(cdsub(4).EQ.1))
     &     arrhc(3) = 1458
        IF ((cdsub(1).EQ.0).AND.(cdsub(2).EQ.1).AND.(cdsub(3).EQ.1)
     &     .AND.(cdsub(4).EQ.2)) arrhc(3) = 1458
        IF ((cdsub(1).EQ.1).AND.(cdsub(2).EQ.1).AND.(cdsub(3).EQ.1)
     &     .AND.(cdsub(4).EQ.1)) arrhc(3) = 1008
      ENDIF

      IF (nb.EQ.5) THEN
        IF ((cdsub(1).EQ.0).OR.(cdsub(4).EQ.0)) arrhc(3) = 1214
        IF ((cdsub(1).NE.0).AND.(cdsub(4).NE.0)) arrhc(3) = 686
      ENDIF

      IF (nb.EQ.6) arrhc(3) = 359


      mult = 1.0
      CALL findring(cdtable(ic1),cdtable(ic2),nca,bond,rngflg,ring)
      IF (rngflg.EQ.1) THEN
! count ring members
        rgord=0
        DO j=1,nca
          rgord=rgord+ring(j)
        ENDDO
! rings with rgord
        IF (rgord.EQ.6) mult=4.50  ! 6 members
        IF (rgord.EQ.7) mult=0.44  ! 7 members
        IF (rgord.EQ.8) mult=0.06  ! 8 members
        arrhc(1) = arrhc(1) * mult
      ENDIF

      ENDIF

      END
