************************************************************************
* MASTER MECHANISM - ROUTINE NAME : no3add_c2                          *
*                                                                      *
*                                                                      *
* PURPOSE :                                                            *
*   This subroutine compute the reaction rate for NO3 addition to      *
*   >C=C-C=O bond (case 2). The -CO-C=C-C=C-CO- structure is not       *
*   taken into account by this routine (see case 3).                   *
*                                                                      *
*                                                                      *
* INPUT:                                                               *
* - chem         : chemical formula                                    *
* - group(i)     : groups at position (carbon) i                       *
* - bond(i,j)    : carbon-carbon bond matrix of chem                   *
* - ncd          : number of "Cd" carbon in chem                       *
* - conjug       : =1 if conjugated Cd (C=C-C=C), otherwise =0         *
* - cdtable(i)   : carbon number bearing a "Cd"                        *
* - cdsub(i)     : number of -C- substitutents (including -CO-) bonded *
*                  to the Cd corresponding to cdtable(i)               *
* - cdcarbo(i)   : number of -CO- substitutents bonded to the Cd       *
*                  corresponding to cdtable(i)                         *
*                                                                      *
* INPUT/OUTPUT                                                         *
* - nr           : number of reaction channel associated with chem     *
* - flag(i)      : flag for active channel i                           *
* - rno3(i,3)    : reaction rate (298 K) for channel i                 *
* - pchem(i)     : the main organic product of reaction channel i      *
* - coprod(i,j)  : coproducts of reaction channel i                    *
*                                                                      *
************************************************************************
      SUBROUTINE no3add_c2(chem,bond,group,
     &                     ncd,conjug,cdtable,cdsub,cdcarbo,
     &                     nr,flag,rno3,pchem,coprod,flag_del,
     &                    pchem_del,coprod_del,sc_del)
      IMPLICIT NONE
      INCLUDE 'general.h'

* input:
      CHARACTER*(lfo) chem
      INTEGER         bond(mca,mca)
      CHARACTER*(lgr) group(mca)
      INTEGER         ncd, conjug
      INTEGER         cdtable(4),cdsub(4)
      INTEGER         cdcarbo(4,2)

* input/output
      INTEGER         nr, flag(mnr)
      CHARACTER*(lfo) pchem(mnr)
      REAL            rno3(mnr)
      CHARACTER*(lco) coprod(mnr,mca)

* internal
      INTEGER         i,j,k,nc
      INTEGER         Ci,Cf
      INTEGER         tbond(mca,mca),nring
      CHARACTER*(lgr) tgroup(mca), pold, pnew
      CHARACTER*(lfo) tempgr
      CHARACTER*(lco) tprod(mca)
      REAL            kstruct
      REAL            fract(4)
      REAL            rat(2)
      REAL            fac
      INTEGER         nbcarb,nbcarbi,nbcarbf
      INTEGER         posf, posi
      INTEGER         ratei,ratej
      CHARACTER*(lfo) rdckprod(mca),pchem_del(mnr)
      CHARACTER*(lco) rdcktprod(mca,mca)
      INTEGER         nip,flag_del(mnr)
      CHARACTER*(lco) coprod_del(mnr,mca)
      REAL            sc(mca),sc_del(mnr,mca)
      REAL            arrhc(3)
      
      CHARACTER(lsb) :: progname='no3add_c2'
      CHARACTER(ler) :: mesg

* -----------
* Initialize
* -----------
      tgroup=group
      tbond=bond

*********************************************************************
* One double bond structures with carbonyl                         *
*********************************************************************
* In cdtable, 1-2 and 3-4 indexes of cdtable are double bonded. Note
* that only one single bond must be "active" in this subroutine and 
* either cdtable(1-2) or cdtable(3-4) must be 0.
* find Ci and Cf such as Cdf=Cdi-C=O and count total number of 
* carbonyls bonded to the double bond
       DO i=1,3,2
        nbcarbi=0
        nbcarbf=0
        IF (cdtable(i).ne.0) THEN
          IF ( (cdcarbo(i,1).ne.0).AND.(cdcarbo(i+1,1).eq.0) ) THEN
            Ci=cdtable(i)
            Cf=cdtable(i+1)
            posi=i
            posf=i+1
            DO j=1,2
              IF (cdcarbo(posi,j).ne.0) nbcarbi=nbcarbi+1
              IF (cdcarbo(posf,j).ne.0) nbcarbf=nbcarbf+1
            ENDDO
            GOTO 63
          ELSE IF ((cdcarbo(i+1,1).ne.0).AND.(cdcarbo(i,1).eq.0))THEN
            Ci=cdtable(i+1)
            Cf=cdtable(i)
            posi=i+1
            posf=i
            DO j=1,2
              IF (cdcarbo(posi,j).ne.0) nbcarbi=nbcarbi+1
              IF (cdcarbo(posf,j).ne.0) nbcarbf=nbcarbf+1
            ENDDO
            GOTO 63
* patch added to remove the problem of reaction depending on whether
* chem is written up side down or the opposite. More work needed to
* clean that
          ELSE IF ((cdcarbo(i,1).ne.0).AND.(cdcarbo(i+1,1).ne.0)) THEN
            IF (group(cdtable(i))(1:4).eq.'CdH2') THEN
              ratei=0
            ELSE IF (group(cdtable(i))(1:3).eq.'CdH') THEN
              ratei=1
            ELSE 
              ratei=2
            ENDIF

            IF (group(cdtable(i+1))(1:4).eq.'CdH2') THEN
              ratej=0
            ELSE IF (group(cdtable(i+1))(1:3).eq.'CdH') THEN
              ratej=1
            ELSE
              ratej=2
            ENDIF

            IF (ratei.ge.ratej) THEN
              Ci=cdtable(i)
              Cf=cdtable(i+1)
              posi=i
              posf=i+1
              DO j=1,2
                IF (cdcarbo(posi,j).ne.0) nbcarbi=nbcarbi+1
                IF (cdcarbo(posf,j).ne.0) nbcarbf=nbcarbf+1
              ENDDO
            GOTO 63
            ELSE
              Ci=cdtable(i+1)
              Cf=cdtable(i)
              posi=i+1
              posf=i
              DO j=1,2
                IF (cdcarbo(posi,j).ne.0) nbcarbi=nbcarbi+1
                IF (cdcarbo(posf,j).ne.0) nbcarbf=nbcarbf+1
              ENDDO
              GOTO 63 
            ENDIF            
            
          ENDIF
        ENDIF
      ENDDO
63    CONTINUE

* double bond with carbonyl : k = kstruct*fac               
*                               
* RCH=CHCHO kstruct  = 2.11E-15 
* CH2=CRCHO kstruct  = 1.6 E-15 
* RCH=CRCHO kstruct  = 7.6 E-14 
* RRC=CHCHO kstruct  = 1.07E-13 
* RRC=CRCHO kstruct  = 2.30E-13 
* R = CHO or COR   fac = 0.01   
* R = -C=C-C=O     fac = 0.073  

* set rate and branching ratio (r(1) is NO3 addition at Ci ; r(2) is 
* NO3 addition at Cf)

* CH2=CR-CO- or CH2=CH-CO- structures. For acrolein, reaction is 
* assumed to proceed only by H-atom abstraction from -CHO 
      IF (group(Cf)(1:4).eq.'CdH2') THEN
        IF (group(Ci)(1:3).eq.'CdH') THEN
          kstruct = 1.2E-16
          rat(1)=0.
          rat(2)=1.
        ELSE
          kstruct = 1.6E-15
          rat(1)=0.
          rat(2)=1.
        ENDIF

* -CH=CR-CO- or -CH=CH-CO- structures        
      ELSE IF (group(Cf)(1:3).eq.'CdH') THEN
        IF (group(Ci)(1:3).eq.'CdH') THEN 
          kstruct = 2.11E-15
          rat(1)=0.5
          rat(2)=0.5
        ELSE
          kstruct= 7.6E-14
          rat(1)=0.
          rat(2)=1.
        ENDIF

* >C=CR-CO- or >C=CH-CO- structures
      ELSE IF (group(Cf)(1:2).eq.'Cd') THEN
         IF (group(Ci)(1:3).eq.'CdH') THEN 
           kstruct = 1.07E-13
           rat(1)=0.
           rat(2)=1.
         ELSE 
           kstruct = 2.3E-13
           rat(1)=0.5
           rat(2)=0.5
         ENDIF
      ENDIF

* correct kstruct as a function of the functional group on Ci and Cf
      fac=1.
      DO k=1,nbcarbf
        fac=fac*0.01
      ENDDO
      IF (nbcarbi.eq.2) fac=fac*0.01

! estimate rate constant
      CALL raddno3(tbond,tgroup,Ci,Cf,arrhc)

* make the two NO3 additions to the >C=C<. 
* Ci and Cf are swapped between j=1 and j=2.

      DO j=1,2

        nr = nr + 1
        IF (nr.GT.mnr) THEN
          mesg = 'too many reactions created for species'
          CALL errexit(progname,mesg,chem)
        ENDIF
        flag(nr) = 1

* assign rate constant for ONO2 addition in Ci position
c        rno3(nr)=kstruct*fac*rat(j)
        rno3(nr) = arrhc(1)*rat(j)

* convert Cf to single bond carbon
        tbond(Cf,Ci)=1
        tbond(Ci,Cf)=1
        pold = 'Cd'
        pnew = 'C'
        CALL swap(group(Cf),pold,tgroup(Cf),pnew)

* convert Ci to single bond carbon
        pold = 'Cd'
        pnew = 'C'         
        CALL swap(group(Ci),pold,tgroup(Ci),pnew)

* add NO3 to Ci carbon and add radical dot to Cf
        nc = INDEX(tgroup(Ci),' ')
        tgroup(Ci)(nc:nc+5) = '(ONO2)'
        nc = INDEX(tgroup(Cf),' ')
        tgroup(Cf)(nc:nc) = '.'

* rebuild, check, and find coproducts:
        CALL rebond(tbond,tgroup,tempgr,nring)
c        CALL radchk(tempgr,pchem(nr),tprod)
        CALL radchk(tempgr,rdckprod,rdcktprod,nip,sc)
        pchem(nr) = rdckprod(1)
	IF (nip.NE.1) THEN
          flag_del(nr) = 1
          sc_del(nr,1) = sc(1)
          sc_del(nr,2) = sc(2)
          pchem_del(nr) = rdckprod(2)
          CALL stdchm(pchem_del(nr))
          coprod_del(nr,:) = rdcktprod(2,:)
        ENDIF
        coprod(nr,:) = rdcktprod(1,:)

* rename
        CALL stdchm(pchem(nr))

* reset:
        tgroup(Ci) = group(Ci)
        tgroup(Cf) = group(Cf)
        tbond(Ci,Cf) = bond(Ci,Cf)
        tbond(Cf,Ci) = bond(Cf,Ci)
                 
* Convert Ci to Cf and Cf to Ci to form the other radical          
        k=Ci
        Ci=Cf
        Cf=k

      ENDDO

      END
