**************************************************************************
* compute nitrate yield                                                  *
*                                                                        *
* Expression used to compute the nitrate yield is the one provided by    *
* Carter, 1999 for the SAPRC99 scheme. Nitrate yield is the expression   *
* for unsubstitued secondary RO2. For substitued RO2 and for primary and * 
* tertiary RO2, the carbon number is an effective carbon number (which   *
* is defined in the calling program).                                    *
*   INPUT :                                                              *
*       xc    : number of "effective" carbon                             *
*       itype : type of peroxy radical (not used in the current version) *
*       tflg  : flag, if equal 1 use standart condition,                 *
*                     if equal 0 use pressure and temperature given      *
*                     in input                                           *
*       temp  : temperature                                              *
*       tbm   : third boby concentration (M)                             *
*                                                                        *
* Update of the DATA (feb 2015) on the basis of Arey 2001 :              *
* J. Phys. Chem. A 2001, 105, 1020-1027                                  *
* Janet Arey, Sara M. Aschmann, Eric S. C. Kwok, and Roger Atkinson      *
*                                                                        *
**************************************************************************
      REAL FUNCTION nityield(xc,itype,tflg,temp,tbm)
      IMPLICIT NONE

* input
      REAL    xc
      INTEGER itype
      INTEGER tflg
      REAL    temp, tbm

* internal
      REAL f, alpha, beta, r_inf, xm_0, xm_inf
      REAL r0,ri,z,rapk
      REAL t,xm

      DATA f /0.410/, alpha /2E-22/, beta /1/, r_inf /0.430/
      DATA xm_0 /0/, xm_inf /8/


      nityield = 0.
      IF (tflg.EQ.1) THEN
         xm = 2.46E+19
         t = 298.
      ELSE
         t = temp
         xm =tbm
      ENDIF

* compute nitrate yield
            
      r0=alpha*exp(beta*xc)*(t/300.)**(-xm_0)
      ri=r_inf*(t/300.)**(-xm_inf)
      Z=1.+(log10(r0*xm/ri))**2.
      Z=1./Z
      rapk=( (r0*xm)/(1.+(r0*xm/ri)) )*(F**Z)
      nityield = rapk/(1+rapk)

      RETURN
      END
