****************************************************************************
*                                                                          *
* Estimate the boiling points with the nannoolal method (2004)             *
*                                                                          *
****************************************************************************
      SUBROUTINE nannoolal_pvap(chem,T,Tb,Nangroup,dB,logPvap)
      IMPLICIT NONE
      INCLUDE 'general.h'
   
* input:
      CHARACTER*(lfo) chem
      REAL            T,Tb,Nangroup(219)

* output
      REAL            logPvap

* internal
      INTEGER         i,j,k
      INTEGER         nca           ! number of nodes
      REAL            contrib(219),Trb,GI,dB
      INTEGER         ic, ih, in, io, ir,is, ifl, ibr, icl
      INTEGER         nbatom,nc
      REAL            sum,sum1,sum2

      REAL            :: deltaHvap,temp
      

************
      DO i=1,219
        contrib(i)=0.
      ENDDO
******  contribution values ***      
      contrib(1)=13.31
      contrib(2)=91.8
      contrib(3)=50.19
      contrib(4)=54.660
      contrib(5)=45.74
      contrib(6)=-31.75
      contrib(7)=37.85
      contrib(8)=96.14
      contrib(9)=22.26
      contrib(10)=32.82
      contrib(11)=4.85
      contrib(12)=23.64
      contrib(13)=49.82
      contrib(14)=-3.7
      contrib(15)=32.72
      contrib(16)=69.88
      contrib(17)=41.55
      contrib(18)=43.72
      contrib(19)=79.54
      contrib(20)=51.29
      contrib(21)=42.09
      contrib(22)=57
      contrib(23)=142.11
      contrib(24)=45.97
      contrib(25)=93.67
      contrib(26)=67.81
      contrib(27)=55.93
      contrib(28)=46.04
      contrib(29)=84.92
      contrib(30)=104.93
      contrib(31)=-40.18
      contrib(32)=134.35
      contrib(33)=719.37
      contrib(34)=758.42
      contrib(35)=700.72
      contrib(36)=756.08
      contrib(37)=441.84
      contrib(38)=108.5
      contrib(39)=286.97
      contrib(40)=251.92
      contrib(41)=361.78
      contrib(42)=193.77
      contrib(43)=-102.73
      contrib(44)=1074.1
      contrib(45)=355.74
      contrib(46)=350.52
      contrib(47)=292.8
      contrib(48)=269.25
      contrib(49)=736.95
      contrib(50)=1216.07
      contrib(51)=255.85
      contrib(52)=252.91
      contrib(53)=123.21
      contrib(54)=127.34
      contrib(55)=222.28
      contrib(56)=20.16
      contrib(57)=226.19
      contrib(58)=86.46
      contrib(59)=224.22
      contrib(60)=134.94
      contrib(61)=34.25
      contrib(62)=97.42
      contrib(63)=206.67
      contrib(64)=128.02
      contrib(65)=48.88
      contrib(66)=375.05
      contrib(67)=126.33
      contrib(68)=375.82
      contrib(69)=238.21
      contrib(70)=2.9
      contrib(71)=9.36
      contrib(72)=603.53
      contrib(73)=662.06
      contrib(74)=510.97
      contrib(75)=1317.44
      contrib(76)=681.35
      contrib(77)=564.11
      contrib(78)=391.37
      contrib(79)=318.24
      contrib(80)=435.84
      contrib(81)=218.6
      contrib(82)=381.59
      contrib(83)=80.27
      contrib(84)=231.39
      contrib(85)=186.92
      contrib(86)=48.5
      contrib(87)=168.3
      contrib(88)=108.53
      contrib(89)=218.72
      contrib(90)=183.11
      contrib(91)=1178.2
      contrib(92)=158.33
      contrib(93)=-47.34
      contrib(94)=186.8
      contrib(95)=392.2
      contrib(96)=595.18
      contrib(97)=268.71
      contrib(98)=183.35
      contrib(99)=612.95
      contrib(100)=258.99
      contrib(101)=-316.44
      contrib(102)=64.06
      contrib(103)=660.22
      contrib(104)=554.79
      contrib(105)=420.76
      contrib(106)=0
      contrib(107)=-237.21
      contrib(108)=0
      contrib(109)=0
      contrib(110)=37.06
      contrib(111)=319.49
      contrib(112)=0
      contrib(113)=118.84
      contrib(114)=0
      contrib(115)=305.13
      contrib(116)=191.51
      contrib(117)=423.53
      contrib(118)=0
      contrib(119)=34.35
      contrib(120)=2.5
      contrib(121)=-83.33
      contrib(122)=-64.49
      contrib(123)=-125.92
      contrib(124)=-47.3
      contrib(125)=33.98
      contrib(126)=-7.1
      contrib(127)=-45.05
      contrib(128)=-3.2
      contrib(129)=0
      contrib(130)=-20.67
      contrib(131)=-36.32
      contrib(132)=-1.2
      contrib(133)=123.74
      contrib(134)=-15.97
      contrib(135)=-561.5153
      contrib(136)=1067.6660
      contrib(137)=42.4825
      contrib(140)=-799.5332
      contrib(141)=-618.2760
      contrib(142)=-1797.6930
      contrib(143)=-1181.5990
      contrib(145)=1431.2430
      contrib(146)=1132.0400
      contrib(148)=-97.6205
      contrib(151)=-751.6676
      contrib(152)=548.4352
      contrib(157)=1085.8320
      contrib(158)=-206.7811
      contrib(159)=-198.2791
      contrib(160)=-1676.4770
      contrib(162)=1659.0340
      contrib(165)=-307.1018
      contrib(166)=65.4421
      contrib(170)=240.3037
      contrib(172)=-2601.7090
      contrib(175)=-787.8563
      contrib(176)=-3929.1300
      contrib(178)=144.6074
      contrib(179)=1118.9580
      contrib(180)=-225.7802
      contrib(181)=1981.2980
      contrib(182)=362.7540
      contrib(183)=-1425.0170
      contrib(185)=743.3353
      contrib(187)=-3748.8180
      contrib(189)=920.3138
      contrib(190)=1594.1640
      contrib(192)=108.1305
      contrib(193)=1590.3210
      contrib(194)=-1270.0830
      contrib(201)=946.7309
      contrib(204)=705.3049
      contrib(205)=838.3372
      contrib(206)=-1501.3550
      contrib(208)=675.0414
      contrib(209)=994.4996
      contrib(210)=135.5896
      contrib(212)=-29.6785
** PAN = 7 + 38 + 72
c      contrib(213)=749.88
** PAN : compernolle 2010
      contrib(213)=519.03
** OOH = -O- + OH
      contrib(214)=888.42 ! compernolle
c      contrib(214)=809.22 ! 36 + 38  
c      contrib(215)=866.92 ! 35 + 38
c      contrib(216)=827.86 ! 34 + 38
c      contrib(217)=550.34 ! 33 + 38
c      contrib(218)=864.58 ! 37 + 38
** CO(OOH) : compernolle 2010
      contrib(219)=926.02

* initialize
      logPvap = 0.

****  revoir !!
      IF (Nangroup(118).NE.0) THEN
        Nangroup(134)=Nangroup(118)
        Nangroup(118)=0
      ENDIF
      
      nc  = INDEX(chem,' ') - 1
      CALL number(chem,nc,ic,ih,in,io,ir,is,ifl,ibr,icl)
      nbatom=ic+in+io+ir+is+ifl+ibr+icl

**********************************************************
*                     compute GI                         *
**********************************************************
      sum1=0.
      sum2=0
      DO i=135,212
        IF (Nangroup(i).GT.0) THEN
	  sum1=sum1+Nangroup(i)
	  sum2=sum2+Nangroup(i)*contrib(i)*0.001
	ENDIF
      ENDDO
      sum1=sum1-1

      IF (sum1.LT.1) THEN
        GI=0.
      ELSE
        GI=(1./nbatom)*(sum2/sum1)
      ENDIF
      
**********************************************************
*                     compute Pvap                       *
**********************************************************
      Trb=T/Tb
      
      sum=0.
      DO i=1,134
        IF (Nangroup(i).NE.0) THEN
          sum=sum+Nangroup(i)*contrib(i)*0.001
        ENDIF
      ENDDO
      DO i=213,219
        IF (Nangroup(i).NE.0) THEN
          sum=sum+Nangroup(i)*contrib(i)*0.001
        ENDIF
      ENDDO
      
      dB=(sum + GI) - 0.176055
      logPvap = (4.1012+dB)*((Trb-1.)/(Trb-(1./8.)))
      
      temp=298.
      deltaHvap=56*(4.1012+dB)*8.314*Tb*2.303
     &               /((Tb/temp)-8.)**2.

c      WRITE(6,*) 'log(Pvap)=',logPvap


**********************************************************
*                     check errors                       *
**********************************************************
      IF (logPvap.GT.10) THEN
        WRITE(41,*) 'chem=',chem(1:50)
        DO i=1,219
          IF (Nangroup(i).NE.0) THEN
            WRITE(41,*) 'Nangroup(',i,')=',Nangroup(i)
          ENDIF
        ENDDO        
        WRITE(41,*) 'T=',T
        WRITE(41,*) 'Tb=',Tb
        WRITE(41,*) 'sum2=',sum2
        WRITE(41,*) 'm=',sum1+1
        WRITE(41,*) 'nbatom=',nbatom
        WRITE(41,*) 'GI=',GI
        WRITE(41,*) 'dB=',dB
        STOP  
      ENDIF      

**************
      END
