*     NAMEBEN is used exclusively in HEAT (to name bsongrp groups)
*     BASE, point, and the I*'s are input, bengrp is output
*******************************************************************************
      SUBROUTINE nameben(base,point,ic,icdot,io,ico,icodot,
     &                   icd,init,ialko,ipero,bengrp)
      IMPLICIT NONE
      INCLUDE 'general.h'

* input
      CHARACTER*3  base
      INTEGER      point,ic,icdot,io,ico,icodot,icd,init,ialko,ipero
* output
      CHARACTER*(lgb) bengrp
* internal
      INTEGER      i


* initialize:
      bengrp = ' '

* form bsongrp groups : start with the base:
      bengrp = BASE
      bengrp(point:point) = '_'
      point=point+1

* first (CO*)
      IF (icodot.NE.0) THEN
         DO i=1,icodot
           bengrp(point:) = '(CO*)'
           point = point + 5
         ENDDO 
      ENDIF

* then (C):
      IF (ic.NE.0) THEN
         DO i=1,ic
           bengrp(point:) = '(C)'
           point = point + 3
         ENDDO 
      ENDIF

* then (C*):
      IF (icdot.NE.0) THEN
         DO i=1,icdot
           bengrp(point:) = '(C*)'
           point = point + 4
         ENDDO 
      ENDIF

* then (Cd):
      IF (icd.NE.0) THEN
         DO i=1,icd
           bengrp(point:) = '(Cd)'
           point = point + 4
         ENDDO 
      ENDIF

* then (CO):
      IF (ico.NE.0) THEN
         DO i=1,ico
           bengrp(point:) = '(CO)'
           point = point + 4
         ENDDO 
      ENDIF

* then (O):
      IF (io.NE.0) THEN
         DO i=1,io
           bengrp(point:) = '(O)'
           point = point + 3
         ENDDO 
      ENDIF

* then (OO*):
      IF (ipero.NE.0) THEN
         DO i=1,ipero
           bengrp(point:) = '(OO*)'
           point = point + 5
         ENDDO 
      ENDIF

* then (O*):
      IF (ialko.NE.0) THEN
         DO i=1,ialko
           bengrp(point:) = '(O*)'
           point = point + 4
         ENDDO 
      ENDIF

* then (ONO2):
      IF (init.NE.0) THEN
         DO i=1,init
           bengrp(point:) = '(ONO2)'
           point = point + 6
         ENDDO 
      ENDIF

      RETURN

      END



***********************************************************************
***********************************************************************
      SUBROUTINE getben(bengrp,nbson,bsongrp,bsonval,value,check)
      IMPLICIT NONE
      INCLUDE 'general.h'

* input 
      INTEGER         nbson
      CHARACTER*(lgb) bsongrp(mbg)
      REAL            bsonval(mbg)
      CHARACTER*(lgb) bengrp

* output 
      REAL            value
      INTEGER         check

* internal
      INTEGER         i

      value=0.
      check=1
      DO i=1,nbson
        IF (bengrp.eq.bsongrp(i)) THEN
          check=0
          value=bsonval(i)
          RETURN
        ENDIF
      ENDDO

      END
