***************************************************************************
      SUBROUTINE multip(tchem,prod,coprod)
      IMPLICIT NONE
      INCLUDE 'general.h'
      INCLUDE 'organic.h'
      INCLUDE 'common.h'

* input/output
      CHARACTER*(lfo),INTENT(inout)  :: tchem
* output
      CHARACTER*(lfo),INTENT(out) :: prod
      CHARACTER*(lco),INTENT(out) :: coprod(mca)

* internal variables:
      INTEGER          :: cnum,onum,nc,nca,np,j1,j2,k,keep
      INTEGER          :: icl,ibr,ipo,itype
      INTEGER          :: i,j,nh
      CHARACTER*(lgr)  :: tgroup(mca), tempkg, pold, pnew
      INTEGER          :: tbond(mca,mca)
      INTEGER          :: dbflg,nring
      INTEGER          :: rjg(mri,2)
!$    INTEGER         omp_get_thread_num
      CHARACTER(lsb) :: progname='*multip*   '
      CHARACTER(ler) :: mesg


      IF (wtflag.NE.0) WRITE(6,*)progname//': input : '
!$   &    ,omp_get_thread_num()
     &    ,tchem

* initialize:
      np = 0
      prod = ' '
      coprod(:) = ' '

* re-entry point and condition
1000  CONTINUE
      j1=0
      j2=0

      nc = INDEX(tchem,' ') - 1
      nca = cnum(tchem,nc)+onum(tchem,nc)
      IF (nca.EQ.1) GO TO 900

      CALL grbond(tchem,nc,tgroup,tbond,dbflg,nring)
      IF(nring.GT.0) CALL rjgrm(nring,tgroup,rjg)

* find group which contains '.' (if none, escape)
      DO i=1,nca
        IF (INDEX(tgroup(i),'.').NE.0) j1 = i
      ENDDO
      IF(j1.EQ.0) GO TO 900

* ----------------------------------------
* treat alkoxy and peroxy  non 'Cd' carbon
* ----------------------------------------

      IF (tgroup(j1)(1:2).NE.'Cd') THEN

* plain alkoxy exits routine: alkoxy with 'CO(O.)' group continues
         IF (INDEX(tgroup(j1),alkoxy).NE.0) THEN
            IF(tgroup(j1)(1:2).NE.carbonyl) GO TO 900
         ENDIF

* peroxy (but not criegge: that's treated later)
         IF ( (INDEX(tgroup(j1),alkyl_peroxy).NE.0) .AND.
     &        (INDEX(tgroup(j1),criegee).EQ.0) ) THEN

* identify type of RO2:
* itype 1 : linear primary RO2
* itype 2 : branched primary RO2
* itype 3 : alpha or beta O substitued primary RO2
* itype 4 : CH3CH(OO.)CH3
* itype 5 : secondary RO2 (C>3)
* itype 6 : alpha or beta O substitued secondary RO2
* itype 7 : Tertiary RO2
* itype 8 : alpha or beta O substitued tertiary RO2
* itype 9 : peroxy acyl

* count for RO2 class (primary, secondary, ...), branched
* structure in beta, polar subtitution in alpha or beta
           icl=0
           ibr=0
           ipo=0
           DO i=1, mca
             IF (tbond(j1,i).ne.0) THEN
               icl=icl+1
               DO j=1, mca
                IF ( (tbond(i,j).ne.0).AND.(j.ne.j1) ) ibr=ibr+1
               ENDDO
               IF (INDEX(tgroup(i),'O').NE.0) ipo=1
               IF (INDEX(tgroup(i),'N').NE.0) ipo=1
             ENDIF
           ENDDO
* assign the type. Note that substitution at the carbon bearing
* the peroxy group is not tested above. This is done below if
* the number of H is not the number expected.
           itype=0
           IF (icl.EQ.1) THEN
             itype=1
             IF (INDEX(tgroup(j1),'CH2').EQ.0) itype=3
             IF (ibr.gt.1) itype=2
             IF (ipo.ne.0) itype=3
           ELSE IF (icl.EQ.2) THEN
             itype = 4
             IF (INDEX(tgroup(j1),'CH').EQ.0) itype=6
             IF (nca.gt.3) itype=5
             IF (ipo.ne.0) itype=6
           ELSE IF (icl.EQ.3) THEN
             itype = 7
             IF (ipo.ne.0) itype=8
           ENDIF

* overwrite if acyl_peroxy radical
           IF (INDEX(tgroup(j1),acyl_peroxy).NE.0)  THEN

* if next to an -O- center, eliminate CO2, and remove -O- center
             DO i=1,mca
               IF (tbond(i,j1).EQ.3)  THEN
                 tgroup(j1) = ' '
                 np = np + 1
                 coprod(np) = 'CO2   '
                 tbond(j1,i) = 0
                 tbond(i,j1) = 0
                 DO j=1,mca
                   IF ((tbond(i,j).EQ.3).AND.(j.NE.j1)) THEN
                     nc = INDEX(tgroup(j),' ')
                     tgroup(j)(nc:nc) = '.'
                     tgroup(i) = ' '
                     tbond(j,i) = 0
                     tbond(i,j) = 0
* JMLT, Oct'15: if next node is ALSO an -O- center, convert it to (O.)
* substituent (NB: this code is from Paris and differs slightly from
* JMLT original version. It has an extra 'IF' test.)
                     IF (tgroup(j)(1:4).EQ.'-O-.') THEN
                       DO k=1,nca
                         IF ((tbond(k,j).NE.0).AND.(k.NE.i)) THEN
                           nc = INDEX(tgroup(k),' ')
                           tgroup(k)(nc:nc+3) = '(O.)'
                           tgroup(j) = ' '
                           tbond(j,k) = 0
                           tbond(k,j) = 0
                         ENDIF
                       ENDDO
                     ENDIF
                   ENDIF
                 ENDDO
                 IF (wtflag.NE.0) WRITE(6,*)'rebond 1'
                 CALL rebond(tbond,tgroup,tchem,nring)
                 IF (INDEX(tchem,'.').NE.0) GO TO 1000
!                 GOTO 1000
               ENDIF
             ENDDO

             itype=9
           ENDIF

* April 2015, Renee McVay
* C(OOH)(OO.) => O2 + C.(OOH)
* overwrite if C(OOH)(OO.)
           IF (INDEX(tgroup(j1),'(OOH)').NE.0)  THEN
!             WRITE(6,'(a)') tchem
             nc = INDEX(tgroup(j1),'(OO.)')
             nh = INDEX(tgroup(j1),' ')
             tgroup(j1) = tgroup(j1)(1:nc-1) // '.' //
     &          tgroup(j1)(nc+5:nh) // ' ' !Remove peroxy radical
            ! tgroup(j1) = 'C.H(OOH)'
             IF (wtflag.NE.0) WRITE(6,*)'rebond 2'
             CALL rebond(tbond,tgroup,tchem,nring)
             IF (INDEX(tchem,'.').NE.0) GO TO 1000
!             GOTO 1000
           ENDIF

* check that a type was assigned to the RO2
      IF (wtflag.NE.0) WRITE(6,*)'output from multip: itype:',itype
           IF (itype.eq.0) THEN
             WRITE(6,'(a)') '--warning, (stop) in multip'
             WRITE(6,'(a)') 'the following species has no type'
             WRITE(6,'(a)') '(e.g. primary, secondary, ...)'
             WRITE(6,'(a)') tchem
             STOP
           ENDIF

* give group name
           np=np+1

******************************************************************
* REDUCE number of PEROXY TYPES                                  *
* To use less than 9 types of peroxy, replace some type by other *
* reactivity type                                                *
******************************************************************
* We keep 4 types of peroxy :
* - primary with the reactivity of branched primary
* - secondary and substituted tertiary with reactivity of
* linear secondary
* - linear tertiary
* - acyl peroxys
           IF (per3_typefg.NE.0) THEN
             IF (itype.EQ.1) itype = 2
             IF (itype.EQ.3) itype = 2
             IF (itype.EQ.4) itype = 7
             IF (itype.EQ.6) itype = 5
             IF (itype.EQ.8) itype = 7
           ENDIF
******************************************************************
*           IF (itype.EQ.1) coprod(np) = 'XP1O2'
*           IF (itype.EQ.2) coprod(np) = 'XP2O2'
*           IF (itype.EQ.3) coprod(np) = 'XP3O2'
*           IF (itype.EQ.4) coprod(np) = 'XS1O2'
*           IF (itype.EQ.5) coprod(np) = 'XS2O2'
*           IF (itype.EQ.6) coprod(np) = 'XS3O2'
*           IF (itype.EQ.7) coprod(np) = 'XT1O2'
*           IF (itype.EQ.8) coprod(np) = 'XT2O2'
*           IF (itype.EQ.9) coprod(np) = 'XACO3'
******************************************************************

           CALL stdchm(tchem)

           GO TO 900
         ENDIF
      ENDIF

* radical on double-TBOND carbon TGROUP:
* ----------------------------------------

      IF (tgroup(j1)(1:2) .EQ. 'Cd') THEN

* find partner double-TBOND carbon:
         DO i=1,mca
           IF (tbond(i,j1).EQ.2) j2 = i
         ENDDO

* check if J2 has **another** double TBOND e.g. Cd=Cd=Cd
* if yes, will want to keep double TBOND notation for J2
         keep = 0
         DO i=1,mca
           IF (tbond(i,j2).EQ.2 .AND. i.NE.j1) keep = 1
         ENDDO

* two radicals on carbon e.g. CdH2=Cd..  -->  CdH2=Cd.(OO.)
         IF (tgroup(j1)(1:5).EQ. 'Cd.. ') tgroup(j1) = 'Cd.(OO.)'

* criegee radicals on double-TBOND carbons:
*  R2Cd=Cd.(OO.)  -->  RCOR + CO
         IF (INDEX(tgroup(j1),criegee).NE.0) THEN
            np = np + 1
            coprod(np) = 'CO   '
            tgroup(j1) = ' '
            tbond(j1,j2) = 0
            tbond(j2,j1) = 0
            IF (keep.EQ.1) THEN
               tgroup(j2) = ketene
                 IF (wtflag.NE.0) WRITE(6,*)'rebond 3'
               CALL rebond(tbond,tgroup,tchem,nring)
            ELSE
               IF (tgroup(j2)(1:4).EQ.'CdH2') THEN
                  np = np + 1
                  tchem = ' '
                  coprod(np) = 'CH2O '
               ELSE IF(tgroup(j2)(1:3).EQ.'CdH') THEN
                  pold = 'CdH'
                  pnew = aldehyde
                  CALL swap(tgroup(j2),pold,tempkg,pnew)
                  tgroup(j2) = tempkg
                 IF (wtflag.NE.0) WRITE(6,*)'rebond 4'
                  CALL rebond(tbond,tgroup,tchem,nring)
               ELSE IF(tgroup(j2)(1:3).EQ.ketene) THEN
                  np = np + 1
                  tchem = ' '
                  coprod(np) = 'CO2  '
               ELSE IF(tgroup(j2)(1:2).EQ.'Cd') THEN
                  pold = 'Cd'
                  pnew = carbonyl
                  CALL swap(tgroup(j2),pold,tempkg,pnew)
                  tgroup(j2) = tempkg
                 IF (wtflag.NE.0) WRITE(6,*)'rebond 5'
                  CALL rebond(tbond,tgroup,tchem,nring)
               ELSE IF(tgroup(j2)(1:2).NE.'Cd') THEN
                  WRITE(6,'(a)') '--error--'
                  WRITE(6,'(a)') 'from MASTER MECHANISM ROUTINE:multip'
                  WRITE(6,'(a)') 'molecule could not be identified'
                  WRITE(6,'(a)') tchem
                  STOP
               ENDIF
            ENDIF

* vinyl-peroxy  Cd=Cd(OO.)  -->  C(O.)-CO
         ELSE IF (INDEX(tgroup(j1),alkyl_peroxy).NE.0) THEN
            tbond(j1,j2) = 1
            tbond(j2,j1) = 1
            IF(tgroup(j1)(1:3).EQ.'CdH') THEN
               tgroup(j1) = aldehyde
            ELSE
               pold = alkyl_peroxy
               pnew = ' '
               CALL swap(tgroup(j1),pold,tempkg,pnew)
               POLD = 'Cd'
               pnew = carbonyl
               CALL swap(tempkg,pold,tgroup(j1),pnew)
            ENDIF
            IF (keep.EQ. 0) THEN
               pold = 'Cd'
               pnew = 'C'
               CALL swap(tgroup(j2),pold,tempkg,pnew)
               tgroup(j2) = tempkg
            ENDIF
            nc = INDEX(tgroup(j2),' ')
            tgroup(j2)(nc:nc+3) = alkoxy
            IF (wtflag.NE.0) WRITE(6,*)'rebond 6'
            CALL rebond(tbond,tgroup,tchem,nring)

* vinyl-oxy radicals  Cd=Cd(O.)  -->  C.-CO
         ELSE IF(INDEX(tgroup(j1),alkoxy).NE.0) THEN
            tbond(j1,j2) = 1
            tbond(j2,j1) = 1
            IF (tgroup(j1)(1:3).EQ.'CdH') THEN
               tgroup(j1) = aldehyde
            ELSE
               pold = alkoxy
               pnew = ' '
               CALL swap(tgroup(j1),pold,tempkg,pnew)
               POLD = 'Cd'
               PNEW = carbonyl
               CALL swap(tempkg,pold,tgroup(j1),pnew)
            ENDIF
            IF (keep.EQ.0) THEN
               pold = 'Cd'
               pnew = 'C'
               CALL swap(tgroup(j2),pold,tempkg,pnew)
               tgroup(j2) = tempkg
            ENDIF
            nc = INDEX(tgroup(j2),' ')
            tgroup(j2)(NC:NC) = '.'
            IF (wtflag.NE.0) WRITE(6,*)'rebond 7'
            CALL rebond(tbond,tgroup,tchem,nring)

* vinyl radicals:
         ELSE IF (tgroup(j1)(1:4).EQ.'CdH.') THEN
            tgroup(j1) = 'CdH(OO.)'
            IF (wtflag.NE.0) WRITE(6,*)'rebond 8'
            CALL rebond(tbond,tgroup,tchem,nring)
         ELSE IF (tgroup(j1)(1:4).EQ.'Cd. ') THEN
            tgroup(j1) = 'Cd(OO.)'
            IF (wtflag.NE.0) WRITE(6,*)'rebond 9'
            CALL rebond(tbond,tgroup,tchem,nring)
         ELSE IF (tgroup(j1)(1:2) .EQ. 'Cd') THEN
            IF (INDEX(tgroup(j1),hydroxy).NE.0) THEN
               tgroup(j1) = ketene
               np = np + 1
               coprod(np) = 'HO2  '
            ELSE IF (INDEX(tgroup(j1),hydro_peroxide).NE.0) THEN
               tgroup(j1) = ketene
               np = np + 1
               coprod(np) = 'HO   '
            ELSE IF (INDEX(tgroup(j1),nitrate).NE.0) THEN
               tgroup(j1) = ketene
               np = np + 1
               coprod(np) = 'NO2  '
            ELSE IF (INDEX(tgroup(j1),'Cd(NO2).').NE.0) THEN
               tgroup(j1)='Cd(NO2)(OO.)'
            ENDIF
            IF (wtflag.NE.0) WRITE(6,*)'rebond 10'
            CALL rebond(tbond,tgroup,tchem,nring)
         ENDIF

* ----------------------------------------
* radical on carbonyl-carbon TGROUP:
* ----------------------------------------

      ELSE IF (tgroup(j1)(1:2).EQ.carbonyl) THEN

* cannot be criegee:
         IF (INDEX(tgroup(j1),criegee).NE.0) THEN
            WRITE(6,'(a)') '--error--2'
            WRITE(6,'(a)') 'from MASTER MECHANISM ROUTINE:multip'
            WRITE(6,'(a)') 'molecule could not be identified'
            WRITE(6,'(a)') tchem
            STOP
         ENDIF
* acyl oxy radicals fragment:
* break off CO2:    C-C-CO(O.)  -->  C-C.  +  CO2
         IF (tgroup(j1)(1:6).EQ.acyl_oxy) THEN
            tgroup(j1) = ' '
            np = np + 1
            coprod(np) = 'CO2  '
            DO i=1,mca
              IF (tbond(j1,i).EQ.1) THEN
                j2 = i
                GO TO 35
              ENDIF
* R-C-O-CO(O.) --> R-C(O.) + CO2
              IF (tbond(j1,i).EQ.3) THEN
                tgroup(j1) = ' '
                tbond(i,j1) = 0
                tbond(j1,i) = 0
                DO j= 1,mca
                  IF ((tbond(i,j).EQ.3).AND.(j.NE.j1)) THEN
                    tgroup(i) = ' '
                    tbond(i,j) = 0
                    tbond(j,i) = 0
                    nc = INDEX(tgroup(j),' ')
                    tgroup(j)(nc:nc+3) = '(O.)'
* JMLT, Nov'15: R-C-O--O-CO(O.) --> R-C(OO.) + CO2
* 1st step was: R-C-O--O-CO(O.) --> R-C-O-(O.) [group j = -O-(O.) ]
* now 2nd step: R-C-O-(O.)      --> R-C(OO.)   [group k = C(OO.) ]
                     DO k=1,mca
                       IF ((tbond(j,k).EQ.3).AND.(k.NE.i)) THEN
                         nc = INDEX(tgroup(k),' ')
                         tgroup(k)(nc:nc+4) = '(OO.)'
                         tgroup(j) = ' '
                         tbond(j,k) = 0
                         tbond(k,j) = 0
* case of CHO-O--O-C(O.)< : fragments to >C=O + CO + HO2
* case of CO(OH)-O--O-C(O.)< : fragments to >C=O + CO2 + HO2
                         IF(tgroup(k)(1:3).EQ.'CHO')THEN
                           tgroup(k)=' '
                           np = np + 1
                           coprod(np) = 'CO   '
                           np = np + 1
                           coprod(np) = 'HO2  '
                         ELSE IF(tgroup(k)(1:6).EQ.'CO(OH)')THEN
                           tgroup(k)=' '
                           np = np + 1
                           coprod(np) = 'CO2   '
                           np = np + 1
                           coprod(np) = 'HO2  '
                         ENDIF
                       ENDIF
                     ENDDO
                    IF (wtflag.NE.0) WRITE(6,*)'rebond 11'
                    CALL rebond(tbond,tgroup,tchem,nring)
                    GOTO 36
                  ENDIF
                ENDDO
              ENDIF
            ENDDO
35          CONTINUE
              nc = INDEX(tgroup(j2),' ')
              tgroup(j2)(nc:nc) = '.'
              tbond(j1,j2) = 0
              tbond(j2,j1) = 0
              IF (wtflag.NE.0) WRITE(6,*)'rebond 12'
              CALL rebond(tbond,tgroup,tchem,nring)
36          CONTINUE
* acyl radicals:
* if next to another CO, break off CO:   C-CO-CO.  -->  C-CO.  +  CO
* otherwise add O2:  C-C-CO  -->  C-C-CO(OO.)
         ELSE IF (tgroup(j1)(1:3).EQ.acyl) THEN
            DO i=1,mca
               IF (tbond(j1,i) .NE.0) THEN
                  j2 = i
                  GO TO 45
               ENDIF
            ENDDO
45          CONTINUE
            IF (tgroup(j2)(1:2).EQ.carbonyl) THEN
               tgroup(j1) = ' '
               np = np + 1
               coprod(np) = 'CO   '
               tbond(j1,j2) = 0
               tbond(j2,j1) = 0
               nc = INDEX(tgroup(j2),' ')
               tgroup(j2)(nc:nc) = '.'
              IF (wtflag.NE.0) WRITE(6,*)'rebond 13'
               CALL rebond(tbond,tgroup,tchem,nring)
            ELSE
               tgroup(j1) = acyl_peroxy
              IF (wtflag.NE.0) WRITE(6,*)'rebond 14'
               CALL rebond(tbond,tgroup,tchem,nring)
            ENDIF
         ENDIF
* ----------------------------------------
* radical on alkyl carbon : criegge
* ----------------------------------------

      ELSE IF (INDEX(tgroup(j1),criegee).NE.0) THEN

* functional TGROUPs on criegee carbon:
         IF (INDEX(tgroup(j1),hydro_peroxide).NE.0) THEN
            tgroup(j1) = acyl_peroxy
            np = np + 1
            coprod(np) = 'HO   '
              IF (wtflag.NE.0) WRITE(6,*)'rebond 15'
            CALL rebond(tbond,tgroup,tchem,nring)
         ELSE IF (INDEX(tgroup(j1),hydroxy).NE.0) THEN
            tgroup(j1) = acyl_oxy
            np = np + 1
            coprod(np) = 'HO   '
              IF (wtflag.NE.0) WRITE(6,*)'rebond 16'
            CALL rebond(tbond,tgroup,tchem,nring)
         ELSE IF (INDEX(tgroup(j1),nitrate).NE.0) THEN
            tgroup(j1) = acyl_peroxy
            np = np + 1
            coprod(np) = 'NO2  '
              IF (wtflag.NE.0) WRITE(6,*)'rebond 17'
            CALL rebond(tbond,tgroup,tchem,nring)
         ELSE IF ( (INDEX(tgroup(j1),nitrate).EQ.0) .AND.
     &             (INDEX(tgroup(j1),hydroxy).EQ.0) .AND.
     &             (INDEX(tgroup(j1),hydro_peroxide).EQ.0) ) THEN
            GOTO 900
         ENDIF

* ----------------------------------------
* radical on alkyl carbon : di-radical
* ----------------------------------------

      ELSE IF(INDEX(tgroup(j1),'..').NE.0) THEN

         pold = '..'
         pnew = criegee
         CALL swap(tgroup(j1),pold,tempkg,pnew)
         tgroup(j1) = tempkg
         IF (wtflag.NE.0) WRITE(6,*)'rebond 18'
         CALL rebond(tbond,tgroup,tchem,nring)

* ----------------------------------------
* radical on alkyl carbon : primary alkyl
* ----------------------------------------

      ELSE IF (INDEX(tgroup(j1),primary).NE.0) THEN

         tgroup(j1) = p_peroxy
         IF (wtflag.NE.0) WRITE(6,*)'rebond 19'
         CALL rebond(tbond,tgroup,tchem,nring)

* -----------------------------------------
* radical on alkyl carbon : secondary alkyl
* -----------------------------------------

      ELSE IF (INDEX(tgroup(j1),secondary).NE.0) THEN

         IF (INDEX(tgroup(j1),hydro_peroxide).NE.0) THEN
            tgroup(j1) = aldehyde
            np = np + 1
            coprod(np) = 'HO   '
            IF (wtflag.NE.0) WRITE(6,*)'rebond 20'
            CALL rebond(tbond,tgroup,tchem,nring)
         ELSE IF (INDEX(tgroup(j1),hydroxy).NE.0) THEN
            tgroup(j1) = aldehyde
            np = np + 1
            coprod(np) = 'HO2  '
            IF (wtflag.NE.0) WRITE(6,*)'rebond 21'
            CALL rebond(tbond,tgroup,tchem,nring)
         ELSE IF (INDEX(tgroup(j1),nitrate).NE.0) THEN
            tgroup(j1) = aldehyde
            np = np + 1
            coprod(np) = 'NO2  '
            IF (wtflag.NE.0) WRITE(6,*)'rebond 22'
            IF (wtflag.NE.0) WRITE(6,*)tchem
            CALL rebond(tbond,tgroup,tchem,nring)
            IF (wtflag.NE.0) WRITE(6,*)tchem
         ELSE IF (INDEX(tgroup(j1),nitro).NE.0) THEN
           IF (tgroup(j1).EQ.'CH(NO2).') THEN
             tgroup(j1)='CH(NO2)(OO.)'
             IF (wtflag.NE.0) WRITE(6,*)'rebond 22b'
             CALL rebond(tbond,tgroup,tchem,nring)
           ENDIF
         ELSE IF ( (INDEX(tgroup(j1),hydro_peroxide).EQ.0) .AND.
     +             (INDEX(tgroup(j1),hydroxy).EQ.0) .AND.
     +             (INDEX(tgroup(j1),nitro).EQ.0) .AND.
     +             (INDEX(tgroup(j1),nitrate).EQ.0) ) THEN
            tgroup(j1) = s_peroxy
            IF (wtflag.NE.0) WRITE(6,*)'rebond 23'
            CALL rebond(tbond,tgroup,tchem,nring)
         ENDIF

* -----------------------------------------
* radical on alkyl carbon : tertiary alkyl
* -----------------------------------------

      ELSE IF ( (INDEX(tgroup(j1),'Cd'    ).EQ.0) .AND.
     &          (INDEX(tgroup(j1),'CO'    ).EQ.0) .AND.
     &          (INDEX(tgroup(j1),'.(OO.)').EQ.0) .AND.
     &          (INDEX(tgroup(j1),'..'    ).EQ.0) .AND.
     &          (INDEX(tgroup(j1),'CH'    ).EQ.0) ) THEN

         IF (INDEX(tgroup(j1),hydro_peroxide).NE.0) THEN
            pold = '.'
            pnew = ' '
            CALL swap(tgroup(j1),pold,tempkg,pnew)
            tgroup(j1) = tempkg
            pold = 'C'
            pnew = carbonyl
            CALL swap(tgroup(j1),pold,tempkg,pnew)
            tgroup(j1) = tempkg
            pold = hydro_peroxide
            pnew = ' '
            CALL swap(tgroup(j1),pold,tempkg,pnew)
            tgroup(j1) = tempkg
            np = np + 1
            coprod(np) = 'HO   '
            IF (wtflag.NE.0) WRITE(6,*)'rebond 24'
            CALL rebond(tbond,tgroup,tchem,nring)
         ELSE IF ((INDEX(tgroup(j1),hydroxy).NE.0).AND.
     &            (INDEX(tgroup(j1),nitrate).NE.0))THEN
            pold = '.'
            pnew = ' '
            CALL swap(tgroup(j1),pold,tempkg,pnew)
            tgroup(j1) = tempkg
            pold = '(ONO2)'
            pnew = ' '
            CALL swap(tgroup(j1),pold,tempkg,pnew)
            tgroup(j1) = tempkg
            pold = 'C'
            pnew = 'CO'
            CALL swap(tgroup(j1),pold,tempkg,pnew)
            tgroup(j1) = tempkg
            np = np + 1
            coprod(np) = 'NO2  '
            IF (wtflag.NE.0) WRITE(6,*)'rebond 25'
            CALL rebond(tbond,tgroup,tchem,nring)
         ELSE IF (INDEX(tgroup(j1),hydroxy).NE.0) THEN
            pold = '.'
            pnew = ' '
            CALL swap(tgroup(j1),pold,tempkg,pnew)
            tgroup(j1) = tempkg
            pold = 'C'
            pnew = carbonyl
            CALL swap(tgroup(j1),pold,tempkg,pnew)
            tgroup(j1) = tempkg
            pold = hydroxy
            pnew = ' '
            CALL swap(tgroup(j1),pold,tempkg,pnew)
            tgroup(j1) = tempkg
            np = np + 1
            coprod(np) = 'HO2  '
            IF (wtflag.NE.0) WRITE(6,*)'rebond 26'
            CALL rebond(tbond,tgroup,tchem,nring)
         ELSE IF (INDEX(tgroup(j1),nitrate).NE.0) THEN
            pold = '.'
            pnew = ' '
            CALL swap(tgroup(j1),pold,tempkg,pnew)
            tgroup(j1) = tempkg
            pold = 'C'
            pnew = carbonyl
            CALL swap(tgroup(j1),pold,tempkg,pnew)
            tgroup(j1) = tempkg
            pold = '(ONO2)'
            pnew = ' '
            CALL swap(tgroup(j1),pold,tempkg,pnew)
            tgroup(j1) = tempkg
            np = np + 1
            coprod(np) = 'NO2  '
            IF (wtflag.NE.0) WRITE(6,*)'rebond 27'
            CALL rebond(tbond,tgroup,tchem,nring)
         ELSE
         !   tgroup(j1) = t_peroxy
            pold = '.'
            pnew='(OO.)'
            CALL swap(tgroup(j1),pold,tempkg,pnew)
            tgroup(j1) = tempkg
            IF (wtflag.NE.0) WRITE(6,*)'rebond 28'
            CALL rebond(tbond,tgroup,tchem,nring)
         ENDIF
      ENDIF

      IF (INDEX(tchem,'.').NE.0) GO TO 1000
900   CONTINUE
      prod = tchem
      IF (wtflag.NE.0) WRITE(6,*)'output from multip: prod :',prod
      IF (wtflag.NE.0.AND.np.GT.1) 
     &               WRITE(6,*)'output from multip: coprods:',coprod(:)

!! DEBUG !!
!          write(*,*)'Press Enter to continue'
!          read(*,*)
!! END DEBUG !!

      RETURN

      END
