        SUBROUTINE molarw_number_withexceptions(chem,weight, flg,
     &            nc,ic,ih,in,io,ir,is,ifl,ibr,icl)
      IMPLICIT NONE
      INCLUDE 'general.h'

* input:
      CHARACTER*(lfo) chem
      INTEGER         nc

* output:
      REAL            weight
      ! flg distinguishes species with non-chemical formulas
      ! or formulas that won't work in grbond.f
      LOGICAL         flg
      INTEGER  ic, ih, in, io, ir,is, ifl, ibr, icl


      weight = 1.
      ic = 0
      ih = 0
      in = 0
      io = 0
      ir = 0
      is = 0
      ifl = 0
      ibr = 0
      icl = 0
      flg = .FALSE.

      IF (chem(1:3) .eq. "CH4") THEN
        weight = 16.04
        ic = 1
        ih = 4
        flg = .TRUE.
      ELSEIF (chem(1:3) .eq. "CO ") THEN
        weight = 28.01
        ic = 1
        io = 1
        flg = .TRUE.
      ELSEIF (chem(1:3) .eq. "CO2") THEN
        weight = 44.01
        ic = 1
        io = 2
        flg = .TRUE.
      ELSEIF (chem(1:5) .eq. "CH2OO") THEN
        weight = 46.01
        ic = 1
        io = 2
        ih = 2
        flg = .TRUE.
      ELSEIF (chem(1:6) .eq. "ethyne") THEN
        weight = 26.038
        ic = 2
        io = 0
        ih = 3
        flg = .TRUE.
      ELSEIF (chem(1:7) .eq. "propyne") THEN
        weight = 40.965
        ic = 3
        io = 0
        ih = 4
        flg = .TRUE.
      ELSEIF (chem(1:5) .eq. "GLYOO") THEN
        weight = 74.0355
        ic = 2
        io = 2
        ih = 3
        flg = .TRUE.
      ELSEIF (chem(1:5) .eq. "MGLOO") THEN
        weight = 88.062
        ic = 3
        io = 3
        ih = 4
        flg = .TRUE.
      ELSEIF (chem(1:6) .eq. "EGLYOO") THEN
        weight = 102.089
        ic = 4
        io = 2
        ih = 6
        flg = .TRUE.
      ELSEIF (chem(1:5) .eq. "PGLOO" .OR.
     $        chem(1:6) .eq. "IPGLOO") THEN
        weight = 116.116
        ic = 5
        io = 3
        ih = 8
        flg = .TRUE.
      ELSEIF (chem(1:8) .eq. "BZFUONOO") THEN
        weight = 132.071
        ic = 4
        io = 4
        ih = 5
        flg = .TRUE.
      ELSEIF (chem(1:8) .eq. "TLFUONOO") THEN
        weight = 146.098
        ic = 5
        io = 5
        ih = 6
        flg = .TRUE.
      ELSEIF(chem(1:7) .eq. "CATECOO") THEN
        weight = 158.1088
        ic = 6
        ih = 6
        io = 5
        flg = .TRUE.
      ELSEIF(chem(1:8) .eq. "MCATECOO") THEN
        weight = 172.
        ic = 7
        ih = 8
        io = 5
        flg = .TRUE.
      ELSEIF(chem(1:9) .eq. "OXCATECOO" .or.
     &       chem(1:9) .eq. "MXCATECOO" .or.
     &       chem(1:9) .eq. "PXCATECOO" .or.
     &       chem(1:8) .eq. "ECATECOO" ) THEN
        weight = 186.1620
        ic = 8
        ih = 10
        io = 5
        flg = .TRUE.
      ELSEIF(chem(1:8) .eq. "PCATECOO"  .or.
     &       chem(1:9) .eq. "IPCATECOO" .or.
     &       chem(1:9) .eq. "OTCATECOO" .or.
     &       chem(1:9) .eq. "MTCATECOO" .or.
     &       chem(1:9) .eq. "PTCATECOO" .or.
     &       chem(1:9) .eq. "T123CTCOO" .or.
     &       chem(1:9) .eq. "T124CTCOO" ) THEN
        weight = 200.1886
        ic = 9
        ih = 12
        io = 5
        flg = .TRUE.
      ELSEIF(chem(1:6) .eq. "PHCHOO") THEN
        weight = 122.1213
        ic = 7
        ih = 6
        io = 2
        flg = .TRUE.
      ELSEIF (chem(1:18) .eq. "CH3C.(OO.)CH2-O-OH") THEN
        weight = 106.
        ic = 3
        ih = 6
        io = 4
        flg = .TRUE.
      ELSEIF (chem(1:17) .eq. "CH3C.(OO.)CO-O-OH") THEN
        weight = 120.
        ic = 3
        ih = 4
        io = 5
        flg = .TRUE.
      ELSEIF (chem(1:8) .eq. "CISOPAO2" .or.
     &        chem(1:8) .eq. "CISOPCO2" .or.
     &        chem(1:7) .eq. "ISOPAO2" .or.
     &        chem(1:7) .eq. "ISOPCO2") THEN
        weight = 117.1232
        ic = 5
        ih = 9
        io = 3
        flg = .TRUE.
      ELSEIF (chem(1:7) .eq. "CISOPAO" .or.
     &        chem(1:7) .eq. "CISOPCO" .or.
     &        chem(1:6) .eq. "ISOPAO" .or.
     &        chem(1:6) .eq. "ISOPCO") THEN
        weight = 101.1238
        ic = 5
        ih = 9
        io = 2
        flg = .TRUE.
      ELSEIF (chem(1:6) .eq. "CISOPA" .or.
     &        chem(1:6) .eq. "CISOPC" .or.
     &        chem(1:6) .eq. "TISOPA" .or.
     &        chem(1:6) .eq. "TISOPC") THEN
        weight = 85.1244
        ic = 5
        ih = 9
        io = 1
        flg = .TRUE.
      ELSEIF (chem(1:37) .eq. "CH3Cd(CH3)=CdHCH2CH2Cd(=CdH2)CdH=CdH2")
     &  THEN
        weight = 136.24
        ic = 10
        ih = 16
        flg = .TRUE.
      ELSEIF (chem(1:36) .eq. "CH3Cd(CH3)=CdHCH2CdH=Cd(CH3)CdH=CdH2")
     & THEN
        weight = 136.24
        ic = 10
        ih = 16
        flg = .TRUE.
      ELSEIF (chem(1:8) .eq. "CMYRCAO2" .or.
     &        chem(1:8) .eq. "CMYRCCO2" .or.
     &        chem(1:7) .eq. "MYRCAO2" .or.
     &        chem(1:7) .eq. "MYRCCO2" )THEN
        weight = 169
        ic = 10
        ih = 17
        io = 2
        flg = .TRUE.
      ELSEIF (chem(1:7) .eq. "CMYRCAO" .or.
     &        chem(1:7) .eq. "CMYRCCO" .or.
     &        chem(1:6) .eq. "MYRCAO" .or.
     &        chem(1:6) .eq. "MYRCCO" ) THEN
        weight = 153
        ic = 10
        ih = 17
        io = 1
        flg = .TRUE.
      ELSEIF (chem(1:6) .eq. "CMYRCA" .or.
     &        chem(1:6) .eq. "CMYRCC" .or.
     &        chem(1:6) .eq. "TMYRCA" .or.
     &        chem(1:6) .eq. "TMYRCC") THEN
        weight = 137.
        ic = 10
        ih = 17
        flg = .TRUE.
      ELSEIF (chem(1:6) .eq. 'BIOG1C' .or.
     &        chem(1:6) .eq. 'BIOG2C' .or.
     &        chem(1:6) .eq. 'BIOG3C' .or.
     &        chem(1:6) .eq. 'BIOG4C') THEN
        weight = 250.
        flg = .TRUE.
      ELSEIF (chem(1:6) .eq. 'BIOG1O' .or.
     &        chem(1:6) .eq. 'BIOG2O' .or.
     &        chem(1:6) .eq. 'BIOG3O' .or.
     &        chem(1:6) .eq. 'BIOG4O') THEN
        weight = 250.
        flg = .TRUE.
      ELSEIF(chem(1:10) .eq. "lostcarbon") THEN
        flg = .TRUE.
      ENDIF

      if (flg) THEN
        return
      else
        CALL molarw(chem, weight)
        CALL number(chem,nc,ic,ih,in,io,ir,is,ifl,ibr,icl)
        RETURN
      ENDIF

      END SUBROUTINE


