************************************************************************
* MASTER MECHANISM - ROUTINE NAME  number                              *
*                                                                      *
* PURPOSE: compute the molecular weight of the species provided as     *
*          input                                                       *
*                                                                      *
* INPUT:                                                               *
*  - chem        : formula of the species                              *
*                                                                      *
* OUTPUT:                                                              *
* - weight       : molecular weight                                    *
*                                                                      *
************************************************************************
      SUBROUTINE molarw(chem,weight)
      IMPLICIT NONE
      INCLUDE 'general.h'

* input:
      CHARACTER*(lfo) chem

* output:
      REAL            weight

* internal:
      INTEGER  ic, ih, in, io, ir,is, ifl, ibr, icl
      INTEGER  nc


      nc=INDEX(chem,' ')
      CALL number(chem,nc,ic,ih,in,io,ir,is,ifl,ibr,icl)
   
! conventional atomic weights from IUPAC periodic table of the elements
! https://www.iupac.org/cms/wp-content/uploads/2015/07/IUPAC_Periodic_Table-28Nov16.jpg
      weight = ic*12.0106 + ih*1.007975 + in*14.006855 + 
     &         io*15.9994 + is*32.0675 +
     &         ifl*18.998 + ibr*79.904 + icl*35.45

      RETURN
      END
