************************************************************************
* MASTER MECHANISM - ROUTINE NAME : mkbrcopy                           *
*                                                                      *
*                                                                      *
* PURPOSE: THIS ROUTINE IS VERY SIMILAR TO MKCOPY. Main difference     *
*          is that mkcopy is called to write copies of the "full"      *
*          molecule while mkbrcopy is called to write copies of a      *
*          given branh of the molecule only.                           *
*          mkbrcopy makes a copy of a branch according to the          *
*          longest tree. On each call of mkcopy, the group ig          *
*          is written in "copy". At the same time and according to     *
*          the bond-matrix, all groups which have a bond to ig         *
*          (except the bond of longest tree), are attached to it       *
*          (in parentheses). These attached must not have more than 1C *
*                                                                      *
* INPUT:                                                               *
* - lobond(i,j)  : logical carbon-carbon bond matrix                   *
* - group(i)     : group at position (carbon) i                        *
* - rank(i)      : rank (priority) of group i (low = more important)   *
* - ig           : is next group to be written to the copy             *
* - pg and ng    : previous and next group of ig in the longest tree   *
* - nca          : total number of group in the molecule               *
*                                                                      *
* INPUT/OUTPUT:                                                        *
* - ptr1         : pointer in "copy", where to put next group          *
* - copy         : chemical formula under that is curently written     *
*                                                                      *
************************************************************************
      SUBROUTINE mkbrcopy(lobond,group,nca,rank,ig,pg,ng,ptr1,brcopy)
      IMPLICIT NONE
      INCLUDE 'general.h'

* input
      LOGICAL         lobond(mca,mca)
      CHARACTER*(lgr) group(mca)
      INTEGER         rank(mca)
      INTEGER         nca,ig,pg,ng

* on input/output:
      CHARACTER*(lfo) brcopy
      INTEGER         ptr1

* internal:
      INTEGER ptr2,i,j,k,l,ita,ia1,ia2,nsor

      !print*,'*mkbrcopy*'
* ------------------------------------------------------
* WRITE GROUP IG TO BRCOPY
* ------------------------------------------------------

      ptr2 = ptr1 + INDEX(group(ig),' ') - 2
      brcopy(ptr1:ptr2) = group(ig)
      ptr1 = ptr2 + 1               

* ------------------------------------------------------
* LOOK FOR ALL ATTACHED GROUPS TO GROUP IG, NOT PG OR NG
* ------------------------------------------------------

* search and write the attached group to IG in "alpha" position
      ita=0
      ia1=0
      ia2=0
      DO 10 i=1,nca
        IF (lobond(ig,i)) THEN
          IF ( (i.NE.pg) .AND. (i.NE.ng) ) THEN
            ita=ita+1
            IF (ita.eq.1) ia1=i
            IF (ita.eq.2) ia2=i

* search the attached group to IG in "beta" position. If any then
* error (or change the program) - this position can only be occupied
* for molecule having at least 12 groups (ie C12)
            DO 20 j=1,nca
              IF (lobond(i,j)) THEN
                IF (j.NE.ig) THEN
                  WRITE (6,*) '--error--,in mkbrcopy'
                  WRITE (6,*) 'the branch has a'
                  WRITE (6,*) 'group (C) in beta'
                  WRITE (6,*) 'position of the closest'
                  WRITE (6,*) 'C in the main (longest)'
                  WRITE (6,*) 'branch'
                  STOP
                ENDIF
              ENDIF
20          CONTINUE
          ENDIF
        ENDIF
* end of loop with attached groups to group IG.
10    CONTINUE

* ------------------------------------------------------
* CHECK THE VARIOUS POSSIBLE CASES
* ------------------------------------------------------

* 3 cases must be considered
* - case 1 : no alpha group => return
* - case 2 : only 1 alpha group => write it and return
* - case 3 : 2 alpha group => evaluate priority and write in sorted way

* CASE 1 (no alpha group)
* ------
       IF (ita.EQ.0) RETURN

* CASE 2 (1 alpha group)
* ------
       IF (ita.EQ.1) THEN
         ptr2 = INDEX(group(ia1),' ') - 1
         ptr2 = ptr1 + ptr2
         brcopy(ptr1:ptr1)   = '('
         brcopy(ptr1+1:ptr2) = group(ia1)
         ptr1 = ptr2 + 1
         brcopy(ptr1:ptr1) = ')'
         ptr1 = ptr1 + 1
         RETURN
       ENDIF

* CASE 3 (2 alpha groups)
* ------
       IF (ita.EQ.2) THEN
          IF(rank(ia2).GE.rank(ia1))THEN
            nsor=ia1
          ELSE
            nsor=ia2
          ENDIF
* write the group having the lowest priority first
         IF (nsor.EQ.2) THEN
           ptr2 = INDEX(group(ia1),' ') - 1
           ptr2 = ptr1 + ptr2
           brcopy(ptr1:ptr1)   = '('
           brcopy(ptr1+1:ptr2) = group(ia1)
           ptr1 = ptr2 + 1
           brcopy(ptr1:ptr1) = ')'
           ptr1 = ptr1 + 1

           ptr2 = INDEX(group(ia2),' ') - 1
           ptr2 = ptr1 + ptr2
           brcopy(ptr1:ptr1)   = '('
           brcopy(ptr1+1:ptr2) = group(ia2)
           ptr1 = ptr2 + 1
           brcopy(ptr1:ptr1) = ')'
           ptr1 = ptr1 + 1
           RETURN

         ELSE

           ptr2 = INDEX(group(ia2),' ') - 1
           ptr2 = ptr1 + ptr2
           brcopy(ptr1:ptr1)   = '('
           brcopy(ptr1+1:ptr2) = group(ia2)
           ptr1 = ptr2 + 1
           brcopy(ptr1:ptr1) = ')'
           ptr1 = ptr1 + 1

           ptr2 = INDEX(group(ia1),' ') - 1
           ptr2 = ptr1 + ptr2
           brcopy(ptr1:ptr1)   = '('
           brcopy(ptr1+1:ptr2) = group(ia1)
           ptr1 = ptr2 + 1
           brcopy(ptr1:ptr1) = ')'
           ptr1 = ptr1 + 1
           RETURN

         ENDIF
       ENDIF

* more than 2 groups: error
* -------------------------
       IF (ita.GT.2) THEN
           WRITE (6,*) '--error--,in mkbrcopy'
           WRITE (6,*) 'the number of methyl group'
           WRITE (6,*) 'is greater than 2'
           STOP
       ENDIF

* end of mkcopy
        RETURN
        END

