!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! This subroutine count the occurence of some structural parameter in  ! 
! the molecule provided as input. Data are stored in "tabinfo"         ! 
! in which the meaning of the indexes are :                            ! 
! tabinfo(1) : number of group in chem                                 ! 
! tabinfo(2) : number of CH3                                           ! 
! tabinfo(3) : number of CH2                                           ! 
! tabinfo(4) : number of CH                                            ! 
! tabinfo(5) : number of C                                             ! 
! tabinfo(6) : number of primary node (ending position)                ! 
! tabinfo(7) : number of secondary node                                ! 
! tabinfo(8) : number of tertiary node (branching position)            ! 
! tabinfo(9) : number of quaternary node (2 branching )                ! 
! tabinfo(10): number of -CO-CO- conjugaisons                          ! 
! tabinfo(11): number of 1-2 interactions                              ! 
! tabinfo(12): number of 1-3 interactions                              ! 
! tabinfo(13): number of 1-4 interactions                              ! 
! tabinfo(14): number of -CO-CO- at a terminal end the chain           ! 
! tabinfo(15): number of -CH2CH3                                       ! 
! tabinfo(16): number of -CH2CH2CH3                                    ! 
! tabinfo(17): number of -CH2CH2CH2CH3                                 ! 
! tabinfo(18): number of -CO-CHO                                       ! 
! tabinfo(19): number of -CO-CO(OONO2)                                 ! 
! tabinfo(20): number of -CO-CO(OH)                                    ! 
! tabinfo(21): number of -CO-CO(OOH)                                   ! 
!                                                                      ! 
! INPUT :                                                              ! 
!  - chem : the formula of the species                                 ! 
!  - mcri : maximum number of criteria that can be used to             ! 
!           discriminate among the various isomers                     ! 
!                                                                      ! 
! OUTPUT :                                                             ! 
!  - tabinfo : see above                                               ! 
!                                                                      ! 
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
      SUBROUTINE interacgrp(chem,tabinfo,mcri)
      IMPLICIT NONE
      INCLUDE 'general.h'

! maximum number of criteria used to discriminate isomers
      INTEGER mcri

! Input      
      CHARACTER*(lfo) chem
c      INTEGER         mcri

! Output      
      INTEGER         tabinfo(mcri)

! Local
      INTEGER         nc, ng, i, j, k, l
      INTEGER         tabgrp(mca)
      INTEGER         tabnit(mca)
      CHARACTER*(lgr) group(mca)
      INTEGER         bond(mca,mca), dbflg, nring
      CHARACTER*1     nodetype(mca)
      INTEGER         memo1,memo2
      INTEGER         rjg(mri,2)
      INTEGER         isum

      
! INITIALIZE SOME PARAMETERS
! --------------------------
      DO i=1,mcri
        tabinfo(i)=0
      ENDDO
      DO i=1,mca
        tabgrp(i)=1
        tabnit(i)=0
        nodetype(i)=' '
      ENDDO

! build the group and bond matrix for chem      
      nc=index(chem,' ')
      CALL grbond(chem,nc,group,bond,dbflg,nring)
      DO i=1,mca
        bond(i,i)=0
      ENDDO

! IF RINGS EXIST remove ring-join characters from groups,
      IF (nring.GT.0) THEN
        CALL rjgrm(nring,group,rjg)
      ENDIF

! count the number of group in chem
      ng=0
      DO  i=1,mca
        IF (group(i)(1:1).NE.' ') ng = ng + 1
      ENDDO 

      tabinfo(1)=ng

! -----------------------------------------
! GET SOME INFO FOR EACH NODE              
! -----------------------------------------

! get the type of nodes in groups
      DO i=1,ng
        IF (group(i)(1:2).eq.'CO') THEN
          nodetype(i)='y'
        ELSE IF (group(i)(1:3).eq.'CHO') THEN
          nodetype(i)='y'
        ElSE IF (group(i)(1:1).eq.'c') THEN
          nodetype(i)='r'
        ELSE IF (group(i)(1:3).eq.'-O-') THEN
          nodetype(i)='o'
        ELSE 
          nodetype(i)='n'
        ENDIF 
      ENDDO

! count the number of aliphatic groups (store info in cell 2-5)
*---------------------------------------------------------------------
      DO i=1,ng
        IF (group(i)(1:4).eq.'CH3 ') THEN
          tabgrp(i)=0
          tabinfo(2)=tabinfo(2)+1
        ENDIF
        IF (group(i)(1:4).eq.'CH2 ') THEN
          tabgrp(i)=0
          tabinfo(3)=tabinfo(3)+1
        ENDIF
        IF (group(i)(1:3).eq.'CH ')  THEN
          tabgrp(i)=0
          tabinfo(4)=tabinfo(4)+1
        ENDIF
        IF (group(i)(1:2).eq.'C ') THEN
          tabgrp(i)=0
          tabinfo(5)=tabinfo(5)+1
        ENDIF
        IF (INDEX(group(i),'(ONO2)').ne.0) THEN
          tabnit(i)=1
c          IF (INDEX(group(i),'CH2(ONO2)').ne.0) THEN
c            tabinfo(24)=tabinfo(24)+1
c	  ENDIF 
        ENDIF
      ENDDO

! count the branching (i.e whether prim, sec ...) (info in cell 6-9)
! ---------------------------------------------------------------------
      DO i=1,ng
        isum=0
        DO j=1,ng 
          IF (bond(i,j).ne.0) THEN
            isum=isum+1
          ENDIF  
        ENDDO
        IF (isum.eq.1) tabinfo(6)=tabinfo(6)+1
        IF (isum.eq.2) tabinfo(7)=tabinfo(7)+1
        IF (isum.eq.3) tabinfo(8)=tabinfo(8)+1
        IF (isum.eq.4) tabinfo(9)=tabinfo(9)+1
      ENDDO


! count the number of conjugated COCO groups (store info in cell 8-12)
! ---------------------------------------------------------------------
      DO i=1,ng-1
        IF (nodetype(i).eq.'y') THEN
          DO j=i+1,ng
            IF (bond(i,j).ne.0) THEN
              IF (nodetype(j).eq.'y') THEN
               tabinfo(10)=tabinfo(10)+1
               IF (group(j).eq.'CHO ') tabinfo(18)=tabinfo(18)+1
               IF (group(j).eq.'CO(OONO2) ') tabinfo(19)=tabinfo(19)+1
               IF (group(j).eq.'CO(OH) ') tabinfo(20)=tabinfo(20)+1
               IF (group(j).eq.'CO(OOH) ') tabinfo(21)=tabinfo(21)+1
              ENDIF
            ENDIF
          ENDDO
        ENDIF
      ENDDO
      tabinfo(14)=tabinfo(18)+tabinfo(19)+tabinfo(20)+tabinfo(21)

! tabinfo(1) : number of group in chem                                 ! 
! tabinfo(2) : number of CH3                                           ! 
! tabinfo(3) : number of CH2                                           ! 
! tabinfo(4) : number of CH                                            ! 
! tabinfo(5) : number of C                                             ! 
! tabinfo(6) : number of primary node (ending position)                ! 
! tabinfo(7) : number of secondary node                                ! 
! tabinfo(8) : number of tertiary node (branching position)            ! 
! tabinfo(9) : number of quaternary node (2 branching )                ! 
! tabinfo(10): number of -CO-CO- conjugaisons                          ! 
! tabinfo(11): number of 1-2 interactions                              ! 
! tabinfo(12): number of 1-3 interactions                              ! 
! tabinfo(13): number of 1-4 interactions                              ! 
! tabinfo(14): number of -CO-CO- at a terminal end the chain           ! 
! tabinfo(15): number of -CH2CH3                                       ! 
! tabinfo(16): number of -CH2CH2CH3                                    ! 
! tabinfo(17): number of -CH2CH2CH2CH3                                 ! 
! tabinfo(18): number of -CO-CHO                                       ! 
! tabinfo(19): number of -CO-CO(OONO2)                                 ! 
! tabinfo(20): number of -CO-CO(OH)                                    ! 
! tabinfo(21): number of -CO-CO(OOH)                                   ! 


! count the length of non substitued chain
*---------------------------------------------------------------------
      IF (INDEX(chem,'CH2CH3').NE.0) tabinfo(15)=tabinfo(15)+1       
      IF (INDEX(chem,'CH3CH2').NE.0) tabinfo(15)=tabinfo(15)+1       
      IF (INDEX(chem,'CH2CH2CH3').NE.0) tabinfo(16)=tabinfo(16)+1       
      IF (INDEX(chem,'CH3CH2CH2').NE.0) tabinfo(16)=tabinfo(16)+1       
      IF (INDEX(chem,'CH2CH2CH2CH3').NE.0) tabinfo(17)=tabinfo(17)+1    
      IF (INDEX(chem,'CH3CH2CH2CH2').NE.0) tabinfo(17)=tabinfo(17)+1
    

! count the number of 1-2, 1-3 and 1-4 interaction
! (store info in cell 5 to 7)
! --------------------------------------------------
      DO i=1,ng
        memo1=0
        memo2=0
        IF (tabgrp(i).ne.0) THEN
          DO j=1,ng
            IF (bond(i,j).ne.0) THEN
              IF (tabgrp(j).ne.0) THEN
                 tabinfo(11)=tabinfo(11)+1
                 IF ((tabnit(i).ne.0).or.(tabnit(j).ne.0)) THEN
c                 IF (tabnit(i).ne.0) THEN
                   tabinfo(22)=tabinfo(22)+1
                 ENDIF
c		 IF ((tabnit(i).ne.0).or.(group(j)(1:3).eq.'CO ')) THEN
c		 IF ((tabnit(i).ne.0).and.(group(j)(1:3).eq.'CO ')) THEN
c                   tabinfo(23)=tabinfo(23)+1
c		 ENDIF
c		 IF (group(i)(1:3).eq.'CO ') THEN
c                   tabinfo(24)=tabinfo(24)+1
c		 ENDIF
c		 IF ((tabnit(i).ne.0).and.(tabnit(j).ne.0)) THEN
c                   tabinfo(24)=tabinfo(24)+1
c		 ENDIF
              ENDIF

              DO k=1,ng    ! loop for 1-3 interactions
                IF ((bond(j,k).ne.0).and.(k.ne.i)) THEN
                  IF (tabgrp(k).ne.0) THEN
                     IF ((group(i)(1:3).eq.'-O-').or.
     &                    (group(k)(1:3).eq.'-O-')) THEN 
                       tabinfo(11)=tabinfo(11)+1
                     ELSE
                       tabinfo(12)=tabinfo(12)+1
                     ENDIF
                   ENDIF

                   DO l=1,ng  ! loop for 1-4 interactions
                     IF ((bond(k,l).ne.0).and.(l.ne.j)) THEN
                       IF (tabgrp(l).ne.0) THEN
                         IF ((group(i)(1:3).eq.'-O-').or.
     &                       (group(l)(1:3).eq.'-O-')) THEN 
                             tabinfo(12)=tabinfo(12)+1
                         ELSE
                           IF ((i.ne.memo1).and.(l.ne.memo2)) THEN !for ring
                             tabinfo(13)=tabinfo(13)+1
                             memo1=i
                             memo2=l
                           ENDIF
                         ENDIF
                       ENDIF
                     ENDIF
                   ENDDO

                 ENDIF
               ENDDO
            ENDIF
          ENDDO
          tabgrp(i)=0
        ENDIF
      ENDDO

      END 
