************************************************************************
* MASTER MECHANISM - ROUTINE NAME : hoadd_c6                           *
*                                                                      *
*                                                                      *
* PURPOSE :                                                            *
*   This subroutine computes the reaction rate for OH addition to      *
*   >C=C=O bond (ketene) (case 6) only.                                *
*                                                                      *
*   The method uses the OH rate of Hatakeyama (1985),                  *
*         Rate constants and mechanism for reactions of ketenes with   *
*         OH radicals in air at 299±2K, Hatakeyama, S., Honda, S.,     *
*         Washida, N., & Akimoto, H., Bull. Chem. Soc. Japan, 58(8),   *
*         2157-2162, 10.1246/bcsj.58.2157, 1985.                       *
*                                                                      *
* INPUT:                                                               *
* - chem         : chemical formula                                    *
* - group(i)     : groups at position (carbon) i                       *
* - bond(i,j)    : carbon-carbon bond matrix of chem                   *
* - ncd          : number of "Cd" carbon in chem                       *
*                                                                      *
* INPUT/OUTPUT                                                         *
* - nr           : number of reaction channel associated with chem     *
* - flag(i)      : flag for active channel i                           *
* - tarrhc(i,3)  : arrhenius coefficient for channel i                 *
* - pchem(i)     : main organic product of reaction channel i          *
* - coprod(i,j)  : coproducts j of revation channel i                  *
*                                                                      *
*************************************************************************
      SUBROUTINE hoadd_c6(chem,bond,group, ncd,
     &                    nr,flag,tarrhc,pchem,coprod)

      IMPLICIT NONE
      INCLUDE 'general.h'
      INCLUDE 'common.h'
      INCLUDE 'organic.h'

* input:
      CHARACTER*(lfo) chem
      INTEGER         bond(mca,mca)
      CHARACTER*(lgr) group(mca)
      INTEGER         ncd 

* input/output
      INTEGER         nr, flag(mnr)
      REAL            tarrhc(mnr,3)
      CHARACTER*(lfo) pchem(mnr)
      CHARACTER*(lco) coprod(mnr,mca)

* internal
      INTEGER         i,j,k,nc,nring,ialpha
      INTEGER         tbond(mca,mca)
      CHARACTER*(lgr) tgroup(mca), pold, pnew
      CHARACTER*(lfo) tempkc
      CHARACTER*(lco) tprod(mca)
      REAL            w1,w2
      CHARACTER*(lfo) rdckprod(mca)
      CHARACTER*(lco) rdcktprod(mca,mca)
      INTEGER         nip
      REAL            sc(mca)

      CHARACTER(lsb) :: progname='*ho_rad2*'
      CHARACTER(ler) :: mesg

* write info for finding bugs
      IF (wtflag.NE.0) WRITE(*,*) progname,': input : ',chem

* Initialize
* -----------
      tgroup=group
      tbond=bond

*********************************************************************
* add OH only at carbonyl group
*********************************************************************

      DO i=1,mca
        IF(INDEX(group(i),'CdO').NE.0)THEN

          nr = nr + 1
          IF (nr.GT.mnr) THEN
            mesg = 'too many reactions created for species'
            CALL errexit(progname,mesg,chem)
          ENDIF
          flag(nr) = 1

          pold = 'CdO'
          pnew = acyl
          CALL swap (group(i),pold,tgroup(i),pnew)
          DO j=1,mca
            IF(bond(i,j).EQ.2)THEN
              tbond(i,j) = 1
              tbond(j,i) = 1
              IF(INDEX(group(j),'Cd').NE.0) THEN
                k=INDEX(group(j),' ')
                tgroup(j)(2:k-1)=group(j)(3:k)
              ELSE
                mesg = 'molecule could not be identified:'
                CALL errexit(progname,mesg,chem)
              ENDIF
              k=INDEX(tgroup(j),' ')
              tgroup(j)(k:k+3)='(OH)'
            ENDIF
          ENDDO

* rebuild, check, and find co-products:
          CALL rebond(tbond,tgroup,tempkc,nring)
          CALL radchk(tempkc,rdckprod,rdcktprod,nip,sc)
          pchem(nr) = rdckprod(1)
          IF (nip.NE.1) WRITE(6,*) '2 produits ho_rad2.f 5'
          coprod(nr,:) = rdcktprod(1,:)
* rename
          CALL stdchm(pchem(nr))
* reset groups:
          tgroup(i) = group(i)

* set rate constants based on CdH2=CdO
          tarrhc(nr,1)=1.79E-11  ! Hatakeyama (1985)
          tarrhc(nr,2)=0.
          tarrhc(nr,3)=0.

        ENDIF
      ENDDO


610   CONTINUE
      END


