!***********************************************************************
! This subroutine count the number of -C(X)-CO(OH) structure, where X
! is an halogen 
!***********************************************************************
      SUBROUTINE haloic(ng,group,bond,haloica)
      IMPLICIT NONE
      INCLUDE 'general.h'
      
! input 
      INTEGER         ng
      CHARACTER*(lgr) group(mca)
      INTEGER         bond(mca,mca)

! output
      INTEGER haloica
      
! local
      INTEGER tempoh15
      INTEGER i,k

! initialize
      haloica=0

! start loop - search for carboxylic group
      DO i=1,ng
        IF (INDEX(group(i),'CO(OH)').ne.0) THEN 
          tempoh15=0

! --------------------------------------
! CHECK FIRST FOR ALIPHATIC -OH GROUP
! --------------------------------------

! H-bond with a functional group on the alpha carbon
          DO k=1,ng
            IF (bond(i,k).ne.0) THEN
              IF (INDEX(group(k),'(F)').NE.0) THEN
                tempoh15=tempoh15+1
              ENDIF
              IF (INDEX(group(k),'(Cl)').NE.0) THEN
                tempoh15=tempoh15+1
              ENDIF
              IF (INDEX(group(k),'(Br)').NE.0) THEN
                tempoh15=tempoh15+1
              ENDIF
              IF (INDEX(group(k),'(I)').NE.0) THEN
                tempoh15=tempoh15+1
              ENDIF
        ENDIF
          ENDDO

! increment is maximum 1 per CO(OH) (a given OH can only be involded in a
! single bond)
          IF (tempoh15.gt.0) THEN
            haloica=haloica+1
          ENDIF
        ENDIF   
      ENDDO

! return
      END
