      SUBROUTINE gas2aero(lrea,chem,name,Tb,dB,mweight)
      INCLUDE 'general.h'

      CHARACTER*(lfo),INTENT(in) :: chem
      CHARACTER*(lco),INTENT(in) :: name
      INTEGER,INTENT(in)         :: lrea
      REAL,INTENT(in)            :: Tb,dB
      REAL,INTENT(in)            :: mweight

      CHARACTER*1     :: a1,a2,a3,a4
      CHARACTER*(lco) :: r(3), p(mnp),namlst(mni)
      REAL            :: s(mnp),ar1,ar2,ar3,f298,fratio
      INTEGER         :: idreac, nlab
      INTEGER         :: nc,ic,in,io,ir,is,ifl,ibr,icl
      REAL            :: xlab,folow(3),fotroe(4)
      REAL            :: auxinfo(9)
      REAL            :: vdmol ! diffusion volumn of molecule
      CHARACTER*1     :: charfrom,charto

! atomic diffusion volumes for C,H,O,N units=(none): 
! Reference: Reid, Prausnitzs & Poling, The properties of liquids 
! and gases, McGraw-Hill inc., New York (1987)
      REAL,PARAMETER :: vdatom(4) =[15.9,2.31,6.11,4.54]

!------------------------------------------------------------------
! initialize (most not used here)
      CALL rxinit3(a1,a2,a3,a4,r,s,p,ar1,ar2,ar3,
     &             f298,fratio,idreac,nlab,xlab,folow,fotroe)
      auxinfo(:)=0.

! calculate vdmol for chem
      nc = INDEX(chem,' ') - 1
      CALL number(chem,nc,ic,ih,in,io,ir,is,ifl,ibr,icl)

      vdmol = 0.0
      vdmol = ic*vdatom(1) + ih*vdatom(2) + io*vdatom(3) + in*vdatom(4)

! if chem = aromatic or heteroyclic ring, subtract 18.3
      IF((nring.GT.0).AND.
     &   (INDEX(chem,'c').GT.0.OR.INDEX(chem,'-O').GT.0)) 
     &    vdmol = vdmol - 18.3

! ---- from gas to aerosol
      r(1)= name
      p(1)= name
      s(1) = 1.
      r(2)= 'AIN '
      ar1 = 1.0
      ar2 = 0.
      ar3 = 0.
      idreac=1
      charfrom='G'
      charto='A'
!      auxinfo(1)=Tb
!      auxinfo(2)=dB
!      auxinfo(3)=vdmol
      CALL rxwrit_dyn(lrea,r,s,p,ar1,ar2,ar3,
     &                idreac,auxinfo,charfrom,charto)

! ---- from aerosol to gas
      r(1)= name
      p(1)= name
      s(1) = 1.
      r(2)= 'AOU '
      ar1 = 1.0
      ar2 = 0.
      ar3 = 0.
      idreac=2
      charfrom='A'
      charto='G'
      auxinfo(1)=Tb
      auxinfo(2)=dB
      auxinfo(3)=vdmol
      WRITE(75,*) name,vdmol
      CALL rxwrit_dyn(lrea,r,s,p,ar1,ar2,ar3,
     &                idreac,auxinfo,charfrom,charto)

      END
