************************************************************************
* MASTER MECHANISM - ROUTINE NAME : findtree                           *
*                                                                      *
*                                                                      *
* PURPOSE : Set up the tree of the C-C and C-O-C bond starting at      *
*           node (top). Adapted from subroutine lntree.                *
*                                                                      *
* INPUT:                                                               *
* - con(i,j)    : node connection matrix (after artificial ring-break) *
* - top         : 1st group (C) => starting point                      *
* - sec         : 2nd group (C) => node just after top in the skeleton *
* - nca          : number of groups                                     *
*                                                                      *
* OUTPUT:                                                              *
* - parent(i)   : node one step back from node(i)                      *
* - child(i,3)  : all nodes one step forward from node(i)              *
*                                                                      *
************************************************************************
      SUBROUTINE findtree(con,top,sec,nca,parent,child)
      IMPLICIT NONE
      INCLUDE 'general.h'

* input/output:
      INTEGER  top,sec,nca
      INTEGER  con(mca,mca)
      INTEGER  parent(mca),child(mca,3)

* internal:
      INTEGER  left(mca),right(mca),center(mca)
      INTEGER  ptr,knt,nknt
      INTEGER  i,j,k,iend
      LOGICAL  tcon(mca,mca)

      !print*,'*findtree*'

* -----------
* initialize
* -----------
      ptr = 0
      left(:) = 0
      right(:) = 0
      center(:) = 0
      parent(:) = 0

* make a logical bond matrix (tcon only used to find parent and child)
      DO i=1,nca
        DO j=1,nca
          IF (con(i,j).eq.0) THEN
            tcon(i,j) = .false.
          ELSE
            tcon(i,j) = .true.
          ENDIF
        ENDDO
      ENDDO

      left(top)      = sec
      parent(sec)    = top
      tcon(top,sec) = .false.
      tcon(sec,top) = .false.

* ---------------------------------------
* get the relationships (parent/children)
* ---------------------------------------

      DO k=1,nca
        nknt = 0
        DO i=1,nca
          knt = 0
          DO j=1,nca
            IF (tcon(i,j)) THEN
              knt = knt + 1
              ptr = j
            ENDIF
          ENDDO
          nknt = nknt + knt

* look for ith carbon with only one node, where parents do not
* exist: (ith carbon = child,jth carbon = parent)
          IF (knt.EQ.1) THEN
            IF ( (parent(i).EQ.0).and.(i.NE.top) ) THEN
              parent(i) = ptr
              tcon(i,ptr) = .false.
              tcon(ptr,i) = .false.
              IF(left(ptr).EQ.0) THEN
                left(ptr) = i
              ELSE IF(right(ptr).EQ.0) THEN
                right(ptr) = i
              ELSE IF(center(ptr).EQ.0) THEN
                center(ptr) = i
              ELSE

* if all children taken, error in bond-matrix:
                DO j=1,nca
                  WRITE(6,*) (con(j,iend),iend=1,nca)
                ENDDO
                WRITE(6,'(a)') '--error--'
                WRITE(6,'(a)') 'from GECKO-A ROUTINE: findtree'
                WRITE(6,'(a)') 'no path possible, error in bonding'
                STOP
              ENDIF
            ENDIF
          ENDIF
        ENDDO
* do loop until bond-matrix is (0).
        IF (nknt.EQ.0) GOTO 35
      ENDDO
35    CONTINUE

! define 'children'      
      !print*,'i,parent(i),left(i),right(i),center(i)'
      DO i=1,nca
        child(i,1)=left(i)
        child(i,2)=right(i)
        child(i,3)=center(i)
        !print*,i,parent(i),(child(i,j),j=1,3)
      ENDDO

      !print*,'*end findtree*'

      RETURN
      END
