!-----------------------------------------------------------------!
! PURPOSE: ascertain whether a given bond is part of any ring     !
! CREATED: June/July 2005, Julia Lee-TAYLOR, NCAR                 !
!-----------------------------------------------------------------!
      SUBROUTINE findring(i1,i2,nca,bond,rngflg,ring)
      IMPLICIT NONE
      include 'general.h'

! input: 
      INTEGER,INTENT(in)  :: i1,i2,nca
      INTEGER,INTENT(in)  :: bond(mca,mca)

! output:
      INTEGER,INTENT(out) :: rngflg       ! 0 = 'no', 1 = 'yes'
      INTEGER,INTENT(out) :: ring(mca)    ! =1 if node participates in current ring

! internal:
      INTEGER             :: i,j,k,m,n        ! current, next, previous nodes
      INTEGER             :: track(mco,mca)
      INTEGER             :: trlen(mco)
      INTEGER             :: ntr

! -----------------------------------------------------
!      print*,'*findring*'
      rngflg=0
      ring(:)=0

      DO m=1,nca-1
        DO n=m+1,nca
          IF (bond(m,n).NE.0) THEN
* find tracks starting at m
            CALL gettrack(bond,m,nca,ntr,track,trlen)
* search in the tracks if node n is found (at least in beta)
            DO i=1,ntr
              DO j=3,trlen(i)
                IF (track(i,j).eq.n) THEN
                  IF (((m.EQ.i1).AND.(n.EQ.i2)).OR.
     &                ((m.EQ.i2).AND.(n.EQ.i1))) THEN
                    rngflg=1
                  ENDIF
                  ring(track(i,1:j))=1
                ENDIF
              ENDDO
            ENDDO
          ENDIF
        ENDDO
      ENDDO
     
      END
