!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! MASTER MECHANISM - ROUTINE NAME : decomp_ro                             !
!                                                                         !
!                                                                         !
! PURPOSE :                                                               !
!  Find rate constants for alkoxy radical decomposition based on          !
!  Vereecken and Peeters 2009.                                            !
!                                                                         !
! INPUT:                                                                  !
! - tgroup(i)     : groups at position (carbon) i                         !
! - tbond(i,j)    : carbon-carbon bond matrix of chem                     !
! - irad          : group bearing the alkoxy radical                      !
! - imol          : group bearing the leaving radical                     !
!                                                                         !
! OUTPUT                                                                  !
! - Eb     : barrier height (kcal.mol-1) for alkoxy radical decomposition !
!                                                                         !
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
      SUBROUTINE decomp_ro(bond,group,ia,ib,Eb,nring)
      IMPLICIT NONE
      INCLUDE 'general.h'
      INCLUDE 'common.h'

! input
      INTEGER         bond(mca,mca)
      CHARACTER*(lgr) group(mca)
      INTEGER         ia,ib
      INTEGER         nring

! output
      REAL            Eb
! internal:
      CHARACTER*(lgr) ::  tgroup(mca),neigh(mca,4)
      INTEGER    ::  tbond(mca,mca)
      INTEGER    ::  i,j,k
      INTEGER    ::  begrg,endrg
      INTEGER    ::  ring(mca)            ! rg index for nodes, current ring (0=no, 1=yes)
      INTEGER    ::  indexrg(mca)         ! rg index for nodes, any ring (0=no, 1=yes)
      INTEGER    ::  rngflg               ! 0 = 'no ring', 1 = 'yes ring'
      INTEGER    ::  rjg(mri,2)           ! ring-join group pairs
      INTEGER    ::  nca                  ! number of nodes
      INTEGER    ::  nc, ibeg, eflg
      INTEGER    ::  lring(2)
      INTEGER    ::  track(mco,mca)
      INTEGER    ::  trlen(mco)
      INTEGER    ::  ntr,maxln

      IF(wtflag.NE.0) PRINT*,"*decomp_ro*"
! -----------
! initialize
! -----------
      nca =0
      lring=0
      ring=0

      tgroup = group
      tbond = bond
! JLMT, Apr 2017: decomp_ro now being called with undecomposed bond
! matrix "bond", to allow findring to work.
! "tbond" is matrix after bond-breaking.
      tbond(ia,ib)=0
      tbond(ib,ia)=0

! count the number of nodes
      DO i=1,mca
        IF (tgroup(i)(1:1).NE.' ') nca=nca+1
      ENDDO

      Eb= 17.9

! IF RINGS EXIST, THEN FIND THE NODES THAT BELONG TO THE RINGS
! --------------------------------------------------------------
! check if ring opening required [if bond(ia,ib) is in a ring]
      IF(nring.GT.0)THEN
        CALL findring(ia,ib,nca,bond,rngflg,ring)

! if ia-ib bond is not part of a cycle, check if ia or ib is a member of a cycle
        IF (rngflg.EQ.0) THEN
          DO i=1,nca
            IF ((tbond(i,ia).EQ.0).OR.(i.EQ.ib)) CYCLE
            CALL findring(i,ia,nca,tbond,rngflg,ring)
            IF (rngflg.EQ.1) GOTO 100
          ENDDO

          DO i=1,nca
            IF ((tbond(i,ib).EQ.0).OR.(i.EQ.ia)) CYCLE
            CALL findring(i,ib,nca,tbond,rngflg,ring)
            IF (rngflg.EQ.1) GOTO 100
          ENDDO 

100       CONTINUE
          rngflg=0   ! reset rngflg to 0 as ia-ib not part of a cycle
        ENDIF

      ENDIF

      IF (nring.GT.0) THEN
      DO i=1,nca
        k=1
        CALL gettrack(tbond,i,nca,ntr,track,trlen)
        DO j=1,ntr
          IF ((trlen(j).GT.2).AND.
     &        (tbond(i,track(j,trlen(j))).GT.0)) THEN
            IF (trlen(j).NE.lring(k)) THEN 
              lring(k)=trlen(j)
              k=k+1
              IF (k.EQ.nring) GOTO 123  ! to be updated for species having 3 cycles
            ENDIF
          ENDIF
        ENDDO
      ENDDO
      ENDIF

123   CONTINUE      

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! check substituents on the carbon bearing the alkoxy radical !
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!      
      IF (tgroup(ia)(1:6).EQ.'CO(O.)')   Eb=Eb-12.7
      IF (INDEX(tgroup(ia),'(OH)').NE.0)  Eb=Eb-8.9
      IF (INDEX(tgroup(ia),'(OOH)').NE.0) Eb=Eb-8.9
      IF (INDEX(tgroup(ia),'(NO2)').NE.0) Eb=Eb-2.2
      IF (INDEX(tgroup(ia),'(ONO)').NE.0) Eb=Eb-4.2
      IF (INDEX(tgroup(ia),'(ONO2)').NE.0) Eb=Eb-3.8

      DO j=1,nca
        IF ((tbond(ia,j).NE.0).AND.(j.NE.ib)) THEN                      
          IF (tgroup(j)(1:3).EQ.'-O-')  THEN
            DO k=1,nca
              IF ((tbond(k,j).NE.0).AND.(k.NE.ia)) THEN
                IF (tgroup(k)(1:3).EQ.'-O-') THEN
                  Eb=Eb - 6.4  ! alpha-O-O-R
                ELSE
                  Eb=Eb - 9.2  ! alpha-O-R
                ENDIF
              ENDIF
            ENDDO
          ENDIF       
        ENDIF   
      ENDDO


      DO 124 j=1,nca
        IF (ring(j).EQ.1) GOTO 124  ! if the carbon belong to a cycle, its contribution is included in cyclics factors
        IF ((tbond(ia,j).EQ.2).AND.(j.NE.ib)) THEN                      
          IF (tgroup(ia)(1:2).EQ.'Cd') Eb=Eb + 21.5    ! alpha=C
        ELSE IF ((tbond(ia,j).EQ.1).AND.(j.NE.ib)) THEN                 
          IF (tgroup(j)(1:2).EQ.'Cd')   Eb=Eb - 4.9    ! alpha-C=C
c          IF (tgroup(j)(1:4).EQ.'CH3 ') Eb=Eb - 2.3   ! alpha-alkyl
c          IF (tgroup(j)(1:4).EQ.'CH2 ') Eb=Eb - 2.3   ! alpha-alkyl
          IF (tgroup(j)(1:2).EQ.'CH')   Eb=Eb - 2.3    ! alpha-alkyl
          IF (tgroup(j)(1:2).EQ.'C ')   Eb=Eb - 2.3    ! alpha-alkyl
          IF (tgroup(j)(1:3).EQ.'C(O')   Eb=Eb - 2.3    ! alpha-alkyl

! correction factor if there is only one substituent to the alpha carbon
          IF (tgroup(j)(1:4).EQ.'CHO ') THEN
            IF (tgroup(ia)(1:6).EQ.'CH(O.)') THEN 
              Eb=Eb - 0.7 + 2.3                        ! R1-CH(O.)CHO
c            ELSE  
c              Eb=Eb - 2.3                              ! R1-C(O.)R2-CHO
            ENDIF
          ENDIF
          IF (tgroup(j)(1:8).EQ.'CH2(OOH)') THEN
            IF (tgroup(ia)(1:6).EQ.'CH(O.)') THEN 
              Eb=Eb - 0.7 + 2.3                        ! R1-CH(O.)CH2(OOH)
c            ELSE   
c              Eb=Eb - 2.3                              ! R1-C(O.)R2CH2(OOH)
            ENDIF
          ENDIF
          IF (tgroup(j)(1:3).EQ.'CO ') THEN
            IF (tgroup(ia)(1:6).EQ.'CH(O.)') THEN 
              Eb=Eb - 0.7                              ! R1-CH(O.)CO-R2
            ELSE  
              Eb=Eb - 2.3                              ! R1-C(O.)R3CO-R2
            ENDIF
          ENDIF
          DO k=1,nca
            IF ((tbond(k,j).NE.0).AND.(k.NE.ia)) THEN
              IF ((tgroup(j)(1:4).EQ.'CH2 ').AND.
     &            (tgroup(k)(1:3).EQ.'-O-')) THEN
                Eb=Eb - 0.7 + 2.3                      ! alpha-CH2-O-R
              ENDIF
            ENDIF
          ENDDO
        ENDIF

124   CONTINUE

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! check substituents on the leaving carbon !
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
      IF (tgroup(ib)(1:3).EQ.'CO ')        Eb=Eb-8.5
      IF (tgroup(ib)(1:4).EQ.'CHO ')       Eb=Eb-8.5
      IF (INDEX(tgroup(ib),'(OH)').NE.0)   Eb=Eb-7.5
      IF (INDEX(tgroup(ib),'(OOH)').NE.0)  Eb=Eb-9.3
      IF (INDEX(tgroup(ib),'(NO)').NE.0)   Eb=Eb-16.0
      IF (INDEX(tgroup(ib),'(NO2)').NE.0)  Eb=Eb+0.4
      IF (INDEX(tgroup(ib),'(ONO)').NE.0)  Eb=Eb-6.0
      IF (INDEX(tgroup(ib),'(ONO2)').NE.0) Eb=Eb-2.8

      DO j=1,nca
        IF ((tbond(ib,j).NE.0).AND.(j.NE.ia)) THEN                      
          IF (tgroup(j)(1:3).EQ.'-O-')  THEN
            DO k=1,nca
              IF ((tbond(k,j).NE.0).AND.(k.NE.ib)) THEN
                IF (tgroup(k)(1:3).EQ.'-O-') THEN
                  Eb=Eb - 7.2  ! alpha-O-O-R
                ELSE
                  Eb=Eb - 9.1  ! alpha-O-R
                ENDIF
              ENDIF
            ENDDO
          ENDIF  
        ENDIF
      ENDDO        

      DO 126 j=1,nca
        IF (ring(j).EQ.1) GOTO 126  ! if the carbon belong to a cycle, its contribution is included in cyclics factors
        IF ((tbond(ib,j).EQ.2).AND.(j.NE.ia)) THEN                      
          IF (tgroup(ib)(1:2).EQ.'Cd') Eb=Eb + 5  ! alpha=C
        ELSE IF ((tbond(ib,j).EQ.1).AND.(j.NE.ia)) THEN                 
          IF (tgroup(j)(1:2).EQ.'Cd')   Eb=Eb - 9.6  ! beta-C=C
c          IF (tgroup(j)(1:4).EQ.'CH3 ') Eb=Eb - 3.4  ! beta-alkyl
c          IF (tgroup(j)(1:4).EQ.'CH2 ') Eb=Eb - 3.4  ! beta-alkyl
          IF (tgroup(j)(1:2).EQ.'CH')   Eb=Eb - 3.4  ! beta-alkyl
          IF (tgroup(j)(1:2).EQ.'C ')   Eb=Eb - 3.4  ! beta-alkyl
          IF (tgroup(j)(1:3).EQ.'C(O')   Eb=Eb - 3.4  ! beta-alkyl
        ENDIF

126   CONTINUE

!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! CORRECTIONS DUE TO RINGS !
!!!!!!!!!!!!!!!!!!!!!!!!!!!!
      IF (rngflg.EQ.0) THEN
        IF (ring(ia).EQ.1) Eb=Eb - 2.0
        DO j=1,nring
          IF ((ring(ib).EQ.1).AND.(lring(j).EQ.3)) 
     &        Eb=Eb + 2.4
          IF ((ring(ib).EQ.1).AND.(lring(j).EQ.4)) 
     &        Eb=Eb - 4.2
          IF ((ring(ib).EQ.1).AND.(lring(j).EQ.5)) 
     &        Eb=Eb - 7.0
          IF ((ring(ib).EQ.1).AND.(lring(j).GE.6)) 
     &        Eb=Eb - 7.0
        ENDDO
      ELSE IF (rngflg.EQ.1) THEN
        DO j=1,nring
          IF (lring(j).EQ.3) Eb=Eb - 24.6
          IF (lring(j).EQ.4) Eb=Eb - 17.1
          IF (lring(j).EQ.5) Eb=Eb - 8.7
          IF (lring(j).GE.6) Eb=Eb - 6.3
        ENDDO
      ENDIF

! correction for Eb<7kcal.mol-1
      IF (Eb.LT.7.0) Eb=19*exp(-((Eb-22)*(Eb-22))/225)

! Eb/R  : Eb in cal.mol-1 and R in Kcal.mol-1
      Eb=(Eb*1000.)/1.9872    

      END




