!**************************************************************
!  HEADER INFORMATION: common.h
!  BROADLY USED VARIABLES :
!**************************************************************
! SET INTEGER FLAGS (1 or 0)
!------------------------------------------------------------------
! flag to write information during the generation of the scheme
      INTEGER :: wtflag ! =0
      INTEGER :: wtopeflag! = 0
! flag to consider only 3 types of peroxys for recombinaison reactions
      INTEGER :: per3_typefg
! flag to use a previously output dictionary as input
      INTEGER :: prevflag
! flag to run post-processing on completed mechanism
      INTEGER :: postflag
! flag to stop execution if routine errexit invoked
      INTEGER :: kill_fg

!---------------------  REDUCTION ---------------------------------
! flag to consider only reaction with NOx for peroxys and acylperoxys
      INTEGER :: high_NOxfg != 0
      INTEGER :: zero_NOXfg! = 0
! flag to allow substitution by isomers (1) or not (0)
      INTEGER :: iflag! = 0

! flag to activate aerosol partioning
      INTEGER :: aeropart_fg
!flag to activate wall partioning
      INTEGER :: wallpart_fg

!-----------------------   SAR   ----------------------------------
! flag to select the vapour pressure estimation method :
! 1 = JR-MY; 2 = nannoolal; 3 = SIMPOL-1
      INTEGER :: pvap_fg! = 2
! flag to select the alkoxy decomposition estimation method :
! 1 = Atkinson 2007; 2 = Vereecken 2009;
      INTEGER :: kdissfg! = 2
      INTEGER :: kisomfg! = 2
! flag to select the oh add on alkene constant rate estimation method :
! 1 = Peeters 1997; 2 = Ziemann 2009, 3 = Magnify : Mike Jenkin SAR;
      INTEGER :: hoadd_c1_fg! = 3
! flag to select criegee intermediates decomposition estimation method
! 1 = Old version; 2 = New Version, CMV 2016
      INTEGER :: criegee_fg
! flag to select stable criegee intermediates bimolecular reactions
! 1 = Old version; 2 = New Version, CMV 2016
      INTEGER :: stab_criegee_fg
! flag to select new calculation of ro2+ho2 rate constant and branching ratios
! 1 = Old version; 2 = new version, CMV 2018, following Wennberg et al 2018
      INTEGER :: ro2ho2_fg

!------------------------------------------------------------------
! temporary value for Z-E conformation of -CH=CH- alkenes
      REAL   :: z_conformer_prop ! = 0.5

!-----------------------  CHEMICAL PATHWAYS-------------------------
! flag to activate DHF formation : 1=DHF running
      INTEGER :: flgdhf
! flag to activate auto-oxidation of peroxy radicals
      INTEGER :: autoox_fg
! flag to activate dimerisation
      INTEGER :: dimer_fg
! flag to activate isoprene soa formation parameterization (Marais et al., 2016)
      INTEGER :: isopsoa_fg
! flag to activate photolysis of hydroperoxides in aerosol phase
      INTEGER :: aerophot_fg
! flag to include OFR-spcific reactions
      INTEGER :: OFR_fg
!------------------------------------------------------------------
! flag to select the dynamic or thermodynamic mass transfer method :
! 1 = thermo; 2 = dynamic;
      INTEGER :: masstransfg! = 2

! flag to generate spinup mechanism (i.e. no organic chemistry generation)
      INTEGER :: spinup_fg

!------------------------------------------------------------------
! flag to select use a spinup/background mechanism found in ../DATA/spinup_mch.dat :
      INTEGER :: spinup_mech

      COMMON        wtflag, wtopeflag
      COMMON        per3_typefg, prevflag, postflag
      COMMON        high_NOxfg
      COMMON        zero_NOXfg
      COMMON        iflag
      COMMON        pvap_fg
      COMMON        kdissfg
      COMMON        kisomfg
      COMMON        hoadd_c1_fg
      COMMON        flgdhf
      COMMON        autoox_fg
      COMMON        dimer_fg
      COMMON        masstransfg
      COMMON        spinup_fg
      COMMON        spinup_mech
      COMMON        wallpart_fg
      COMMON        aeropart_fg
      COMMON        criegee_fg
      COMMON        stab_criegee_fg
      COMMON        z_conformer_prop
      COMMON        ro2ho2_fg
      COMMON        isopsoa_fg
      COMMON        aerophot_fg
      COMMON        OFR_fg
      COMMON        kill_fg

!------------------------------------------------------------------
!
! number of species in : dict,chmlst,namlst,dbrch
      INTEGER         nrec,nrectot

! table of inorganic species potentially produced
      INTEGER         ninorg
      CHARACTER*(ldi) inorglst(mfn)

! special species
      INTEGER         nspsp
      LOGICAL         lospsp(mfn)
      CHARACTER*(ldi) dictsp(mfn)


! table of species having a special name
      COMMON          nspsp,lospsp,dictsp

      COMMON          nrectot,nrec
      COMMON          inorglst,ninorg

!********************************!
      INTEGER         iflost
      INTEGER xxc,xxh,xxn,xxo,xxr,xxs,xxfl,xxbr,xxcl
      COMMON          iflost
      COMMON          xxc,xxh,xxn,xxo,xxr,xxs,xxfl,xxbr,xxcl


