!-----------------------------------------------------------------!
! PURPOSE: Find artificial breakpoints for cyclic molecule without!
!          rearranging: includes multi-ring compounds.            !
!-----------------------------------------------------------------!
      SUBROUTINE closring(nring,nca,group,bond,rjg)
      IMPLICIT NONE
      include 'general.h'

! input: 
      INTEGER,INTENT(in)  :: nca,nring
      INTEGER,INTENT(in)  :: bond(mca,mca)
! i/o:
      CHARACTER*(lgr),INTENT(inout) :: group(mca)
! output: 
      INTEGER,INTENT(out) ::    rjg(mri,2) ! ring-join group pairs

! internal:
      INTEGER    :: i,j,k,n,rngflg
      INTEGER    :: rgpath(mca)
      INTEGER    :: tbond(mca,mca)

!---------------------------
      !print*,'*closring*'
! initialise,  remove ring-joining chars from groups, should any exist
      CALL rjgrm(nring,group,rjg)
      rjg(:,:)=0
      n=0
      tbond(:,:)=bond(:,:)

! troubleshooting
      !DO j=1,nca
      !  write(6,'(a12,14(i2))')group(j),(tbond(i,j),i=1,nca)
      !ENDDO

! crawl bond matrix to find rings
      DO 10 i=1,nca-1
        DO j=nca,i+2,-1
          IF(bond(i,j).GT.0)THEN
            CALL findring(i,j,nca,tbond,rngflg,rgpath)
            IF(rngflg.EQ.1) THEN ! connection is on a ring
              n=n+1
              IF(n.GT.nring)THEN
                print*,"ERROR in closring: too many rings found!"
                print*,n,nring
                WRITE(99,*)'closring',group(j) !STOP
              ENDIF
              rjg(n,1) = i
              rjg(n,2) = j
              tbond(i,j)=0
              tbond(j,i)=0
              GOTO 10
            ENDIF
          ENDIF
        ENDDO  ! j
 10   CONTINUE  ! i
 20   CONTINUE

      RETURN
      END
