************************************************************************
* MASTER MECHANISM - ROUTINE NAME :      chcksp                        *
*                                                                      *
* PURPOSE:  -  check if the species makes sense in the generator       *
*                                                                      *
* INPUT                                                                *
*  - ninorg      : number of inorganic species                         *
*  - inorglst(j) : list of inorganic species - include the name +      *
*                  formula + functional group info                     *
*  - nrec        : number of species recorded                          *
*  - dict(j)     : dictionary line (name + formula + functional        *
*                  group info) of species number j                     *
* - nspsp       : total number of "special" species (e.g. furan)       *
* - dictsp(i)   : list of the "known" special species                  *
*                                                                      *
* INPUT/OUTPUT :                                                       *
*  - chem        : the formula to be checked                           *
*                                                                      *
* First the formula is checked for a keyword (EXTRA, HV). If not,      *
* formula is checked for "regular" organic molecule (must start        *
* C c or =Cd1). If these tests fail then the formula must be an        *
* inorganic species. The program stops if the species is not OK.       *
************************************************************************
      SUBROUTINE chcksp(ninorg,inorglst,
     &                  nrec,dict,
     &                  nspsp,dictsp,
     &                  chem)
      IMPLICIT NONE
      INCLUDE 'general.h'

* input
      INTEGER,INTENT(in)         ::  ninorg
      CHARACTER*(ldi),INTENT(in) ::  inorglst(mfn)
      INTEGER,INTENT(in)         ::  nrec
      CHARACTER*(ldi),INTENT(in) ::  dict(mni)
      INTEGER,INTENT(in)         ::  nspsp
      CHARACTER*(ldi),INTENT(in) ::  dictsp(mfn)

* output
      CHARACTER*(lfo),INTENT(out) :: chem

* internal
      LOGICAL         :: locheck
      INTEGER         :: i, nca, cnum, n1,dicptr, srch
      CHARACTER(50)   :: filename

* initialize
      n1=INDEX(chem,' ')-1
      filename = "mcm.3.3.1_mxyl_furan_dic.dat"

* check if the species is a keyword
      IF (chem(1:6).eq.'EXTRA ') RETURN
      IF (chem(1:3).eq.'HV ') RETURN
      IF (chem(1:4).eq.'PERO') RETURN
      IF (chem(1:6).eq.'MEPERO') RETURN
      IF (chem(1:7).eq.'NOTHING') RETURN
      IF (chem(1:7).eq.'OXYGEN ') RETURN
      IF (chem(1:7).eq.'ISOM   ') RETURN

* check if the species is a special species
      IF (chem(1:1).EQ.'#') THEN
         DO i=1,nspsp
           IF (dictsp(i)(10:131).eq.chem) RETURN
         ENDDO
         WRITE(6,*) '--error-- in the routine chcksp.'
         WRITE(6,*) 'chemical name starting with # not found '
         WRITE(6,*) 'in the "dictsp" table (see '
     &               //filename//') :'
         WRITE(6,*) chem(1:60)
         WRITE(99,*) 'chcksp',chem !STOP
         STOP
* check if the species start with a C. If the species is a C1, then
* the species must already be in the dictionary, otherwise check the
* name using stdchm
      ELSE IF ((chem(1:1).EQ.'C').OR.
     &         (chem(1:1).EQ.'c').OR.
     &         (chem(1:4).EQ.'=Cd1').OR.
     &         (chem(1:4).EQ.'-O1-')) THEN
         nca=cnum(chem,n1)
         IF (nca.eq.1) THEN
           dicptr = srch(nrec,chem,dict)
           IF (dicptr.gt.0) RETURN
           WRITE(6,*) '--error-- in the routine chcksp.'
           WRITE(6,*) 'species holding 1 C not found in the '
           WRITE(6,*) 'dictionary (see "singlec_dic.dat") :'
           WRITE(6,*) chem(1:60)
           WRITE(99,*) 'chcksp',chem !STOP
         ELSE
           CALL stdchm(chem)
         ENDIF

* If the test above failed, then the species must be inorganic
      ELSE
         DO i=1,ninorg
           IF (chem.EQ.inorglst(i)(10:129)) RETURN
         ENDDO
         write(6,*)'ninorg=',ninorg
         DO i=1,ninorg
           write(6,*) inorglst(i)(1:40)
         ENDDO
         write(6,*)'ninorg=',ninorg
         WRITE(6,*) '--error-- in the routine chcksp.'
         WRITE(6,*) 'species not found in the '
         WRITE(6,*) 'inorganic dictionary (see "singlec_dic.dat") :'
         WRITE(6,*) chem(1:60)
         WRITE(99,*) 'chcksp',chem !STOP
      ENDIF

      END
