!***********************************************************************
! This subroutine count the number of -CO-C(X) -and CO-C-C(X) structures, 
! where X is an oxygenated group (carbonyl,alkohol, nitro, hydroperoxide, ether) 
!
! Input :
!   - ng : number of groups.
!   - group : groups in the considered species.
!   - bond : bond matrix.
!
! output :
!   - caoxa : number of -CO-C(X) 
!   - caoxb : number of -CO-C-C(X) 
! 
!***********************************************************************
      SUBROUTINE caox(ng,group,bond,caoxa,caoxb)
      IMPLICIT NONE
      INCLUDE 'general.h'
      
! input 
      INTEGER,INTENT(in)         :: ng
      CHARACTER*(lgr),INTENT(in) :: group(mca)
      INTEGER,INTENT(in)         :: bond(mca,mca)

! output
      REAL,INTENT(out)           :: caoxa,caoxb
      
! local
      INTEGER tempoh15, tempoh16
      INTEGER i,k,l,m
      REAL    ncoco15,ncoco16

! initialize
      caoxa=0.
      caoxb=0.
      ncoco15=0.
      ncoco16=0.
      
! start loop - search for carbonyl
      DO i=1,ng
        IF ((group(i)(1:2).eq.'CO').OR.
     &      (group(i)(1:3).eq.'CHO')) THEN
          tempoh15=0
          tempoh16=0

! look for group on alpha position 
          DO k=1,ng
            IF (bond(i,k).ne.0) THEN
              IF (INDEX(group(k),'(NO2)').NE.0) THEN
c                tempoh16=tempoh16+1  ! counted as 1-6 in H bounding frame
                tempoh15=tempoh15+1
              ENDIF
              IF (group(k)(1:2).eq.'CO') THEN
                tempoh15=tempoh15+1
                ncoco15=ncoco15+1
              ENDIF
              IF (INDEX(group(k),'(OH)').NE.0) THEN
                tempoh15=tempoh15+1
              ENDIF
              IF (INDEX(group(k),'CHO').NE.0) THEN
                tempoh15=tempoh15+1
                ncoco15=ncoco15+1
              ENDIF
              IF (INDEX(group(k),'(OOH)').NE.0) THEN
                tempoh15=tempoh15+1
              ENDIF 

! look for group on beta position 
              DO 354 l=1,ng
                IF ((group(i)(1:1).eq.'c') .AND. 
     &              (group(l)(1:1).eq.'c') ) GOTO 354
                IF ((bond(k,l).ne.0).and.(l.ne.i)) THEN
                  IF (INDEX(group(l),'(NO2)').NE.0) THEN
                    tempoh16=tempoh16+1
c                   tempoh15=tempoh15+1
                  ENDIF
                  IF (group(l)(1:2).eq.'CO') THEN 
                    tempoh16=tempoh16+1
                    ncoco16=ncoco16+1
                  ENDIF
                  IF (group(l)(1:3).eq.'-O-') THEN 
                    tempoh15=tempoh15+1
                  ENDIF
                  IF (INDEX(group(l),'(OH)').NE.0) THEN
                    tempoh16=tempoh16+1
                  ENDIF
                  IF (INDEX(group(l),'(OOH)').NE.0) THEN
                    tempoh16=tempoh16+1
                  ENDIF
                  IF (INDEX(group(l),'CHO').NE.0) THEN
                    tempoh16=tempoh16+1
                    ncoco16=ncoco16+1
                  ENDIF

                  DO m=1,ng     ! check for ether on position gamma
                    IF ((bond(l,m).ne.0).and.(m.ne.k)) THEN
                      IF (group(m)(1:3).eq.'-O-') THEN 
                        tempoh16=tempoh16+1
                      ENDIF
                    ENDIF
                  ENDDO

                ENDIF
354           CONTINUE

            ENDIF
          ENDDO

          IF (tempoh15.gt.0) THEN
            caoxa=caoxa+1.
          ENDIF
          IF (tempoh16.gt.0) THEN
            caoxb=caoxb+1.
          ENDIF

        ENDIF
      ENDDO

! correct the value for dicarbonyl (otherwise counted twice)
      IF (ncoco15.gt.1) THEN
        ncoco15=ncoco15/2.
        caoxa=caoxa-ncoco15
      ENDIF
      IF (ncoco16.gt.1) THEN
        ncoco16=ncoco16/2.
        caoxb=caoxb-ncoco16
      ENDIF

! return
      END
