*  This subroutine fragments the substitued alkenes such as
* >Cd=Cd(OH)- or >Cd=Cd(OOH)- or >Cd=Cd(ONO2)- which come from Norrish
* II (alkenes photolysis), or from fragmentation after oxidation of
* conjugated alkenes.
* We consider that these alkenes are energy-rich and decompose to :
*  >Cd=Cd(OH)-    -> >CH-CO- 
*  >Cd=Cd(OOH)-   -> >C(.)-CO- + OH.
*  >Cd=Cd(ONO2)-  -> >C(.)-CO- + NO2
* Each Cd can't support more than one group like OH, OOH or ONO2
* If there is more than one group on the double bond, treat first the
* -OH next the -OOH and at last the -ONO2
***************************************************************************
      SUBROUTINE alkcheck(pchem,prod)
      IMPLICIT NONE
      INCLUDE 'general.h'
      INCLUDE 'common.h'
      INCLUDE 'organic.h'
* input/output
      CHARACTER*(lfo),INTENT(inout) :: pchem
* output
      CHARACTER*(lco),INTENT(out)   :: prod

* internal
      INTEGER            ::  bond(mca,mca),dbflg,nc,nring
      CHARACTER*(lgr)    ::  group(mca),pold,pnew,tgroup(mca)
      CHARACTER*(lfo)    ::  tempkc
      INTEGER            ::  i,j
      INTEGER            ::  rjg(mri,2) ! ring-join group pairs

      CHARACTER(lsb) :: progname='*alkcheck*'
      CHARACTER(ler) :: mesg

*********************************************************************
      IF(wtflag.NE.0) WRITE(*,*)progname,': input  : ',pchem

      prod=' '

      IF (INDEX(pchem,'.').NE.0) RETURN

      nc = INDEX(pchem,' ') - 1
      CALL grbond(pchem,nc,group,bond,dbflg,nring)

      CALL rjgrm(nring,group,rjg)

      DO i=1,mca
        IF (INDEX(group(i),'Cd').ne.0) THEN
          
          IF (INDEX(group(i),'(OH)').ne.0) THEN
            pold='(OH)'
            pnew='O'
            CALL swap(group(i),pold,tgroup(i),pnew)
            group(i)=tgroup(i)
            pold='Cd'
            pnew='C'
            CALL swap(group(i),pold,tgroup(i),pnew)
            group(i)=tgroup(i)
            DO j=1,mca
              IF (bond(i,j).eq.2) THEN
                bond(i,j)=1
                bond(j,i)=1
                IF (group(j)(1:4).EQ.'CdH2') THEN
                  pold='CdH2'
                  pnew='CH3'
                ELSE IF (group(j)(1:3).EQ.'CdH') THEN        
                  pold='CdH'
                  pnew='CH2'
                ELSE IF (group(j)(1:2).EQ.'Cd') THEN        
                  pold='Cd'
                  pnew='CH'
                ENDIF        
              CALL swap(group(j),pold,tgroup(j),pnew)
              group(j)=tgroup(j)
              CALL rebond(bond,group,tempkc,nring)
              pchem=tempkc
              CALL stdchm (pchem)
              ENDIF
            ENDDO  
            GOTO 100

!          ELSE IF (INDEX(group(i),'(OOH)').ne.0) THEN
!            pold='(OOH)'
!            pnew='(O.)'
!            CALL swap(group(i),pold,tgroup(i),pnew)
!            group(i)=tgroup(i)
!            CALL rebond(bond,group,tempkc,nring)
!            pchem=tempkc
!            CALL stdchm (pchem)
!            prod='HO'
!            GOTO 100

          ELSE IF (INDEX(group(i),'(ONO2)').ne.0) THEN
            pold='(ONO2)'
            pnew='(O.)'
            CALL swap(group(i),pold,tgroup(i),pnew)
            group(i)=tgroup(i)
            CALL rebond(bond,group,tempkc,nring)
            pchem=tempkc
            CALL stdchm (pchem)
            prod='NO2'
            GOTO 100  
          ENDIF
        ENDIF
      ENDDO
100   CONTINUE

      IF(wtflag.NE.0) WRITE(*,*)progname,': output : ',pchem

      RETURN
      END
