## NOTE ## check OBJ/lib.makefile to make sure it has same flags ##

#!! use gfortran on supercomputers
#------------------------------------ 

#FC = gfortran
#OMPFLAGS =
#BOXFLAGS =-O3 -finit-real=zero -mcmodel=medium -fdefault-real-8 -ffpe-trap=invalid,zero,overflow
#FFLAGS = $(OMPFLAGS) $(BOXFLAGS) -c -s

#----------------------- 
#!! use pgf90 on juliapc
#----------------------- 
# -fpic puts code (not compiler) in charge of memory control
#  #  -C adds array bounds checking
#  -g generates symbolic debug information, with optimization level = 0
#  #  -mcmodel allows data sections to be > 2GB
#  -O2 sets optimisation level = 2 
#  #  -pg enables gprof-style sample-based profiling

FC=pgf90
#BOXFLAGS= -c -r8 -mcmodel=medium
BOXFLAGS= -c -mcmodel=medium
# NetCDF paths are specific lo local system. EDIT HERE!
#LNKFLAGS=-L/usr/local/netcdf-4.4.1/lib -lnetcdf -lnetcdff
#INCLUDES=-I/usr/local/netcdf-4.4.1/include
FFLAGS = $(INCLUDES) $(LNKFLAGS) $(OMPFLAGS) $(BOXFLAGS) -c -s -fpic
#----------------------- 

../../PROG/$(prog): ../../PROG/$(prog).f ../../OBJ/aklib.a \
$(dic)/akparameter.h ../../LIBSRC/general.h ../../LIBSRC/organic.h\
../../LIBSRC/flags.h 
	cp ../../PROG/$(prog).f ./
	cp ../../OBJ/aklib.a ./
	cp $(dic)/akparameter.h ./
	cp ../../LIBSRC/flags.h ./
	cp ../../LIBSRC/general.h ./
	cp ../../LIBSRC/organic.h ./
	$(FC) $(FFLAGS) $(prog).f aklib.a  -o ../../PROG/$(prog)
