      SUBROUTINE wrtopgas_ncdf(ncid,ibox,itout,numsp,nclro2,
     &                              time,temp,rh,cbox,cro2)


!==================================================================
! PURPOSE: write runtime gas-phase output variables 
!          in NetCDF-format box model output file
! AUTHOR: Julia Lee-Taylor, NCAR, 123Jan 2018
!==================================================================
      USE io_units_module,ONLY: lro2
      USE forcing_params_module,ONLY: nbox,sumc,sumcfix

      USE akparameter_module

      IMPLICIT NONE

      INTEGER ncid,itout
      INTEGER ibox,numsp,nclro2
      REAL    time,temp,rh(mbox)
      REAL,DIMENSION(maxsp)  :: cbox
      REAL,DIMENSION(maxro2) :: cro2

!----------------------------------------------------------
! write gas phase values for current timestep and box to netCDF output file

! NB: time,temp, rh calculated as scalars but written into 2D space
!     cbot etc are calculated as 1D arrays but written into 2D space

      CALL eznc_put_0Dreal_into1D(ncid,"time",time,itout)

      CALL eznc_put_1Dreal_into3D(ncid,"conc",
     &                                  cbox(1:numsp),
     &                                       1,numsp,ibox,itout)
      CALL eznc_put_1Dreal_into3D(ncid,"cro2",
     &                                  cro2(1:nclro2),
     &                                       1,nclro2,ibox,itout)

      WRITE(lro2,*) time,cro2(1:nclro2)

      CALL eznc_put_0Dreal_into2D(ncid,"temp",temp,ibox,itout)
      CALL eznc_put_0Dreal_into2D(ncid,"rh"  ,rh  ,ibox,itout)

      IF (sumcfix.NE.1) THEN
        CALL eznc_put_1Dreal_into2D(ncid,"sumc",sumc(1:nbox),
     &                                               1,nbox,itout)
      ENDIF

!==end write output variables

      END SUBROUTINE wrtopgas_ncdf
