      SUBROUTINE soa_dyn_update(cbox,ctotaerbox,maerbox)

      USE flags_module,ONLY: dimer_fg
      USE io_units_module,ONLY: lout
      USE time_mgmt_module
      USE NetCDF_vars_module,ONLY: ncid_prev,ncid_out
      USE akparameter_module
      USE solver_params_module,ONLY: dtmin,dtmax,numit
      USE forcing_params_module
      USE module_data_gecko_main
      USE fundamental_consts_module,ONLY: multimass

      !$ USE OMP_LIB

      IMPLICIT NONE

      REAL,INTENT(INOUT)    :: maerbox    ! = maer(ibox)
      REAL,INTENT(INOUT)    :: ctotaerbox ! = ctotaer(ibox)
      REAL,DIMENSION(maxsp) :: cbox       ! = conc(:,ibox)

! -------------------------------------
      !PRINT*,"updating dynamic soa"

! compute the new concentration of SOA (in molec/cc)
! compute the new mass concentration of SOA (in ug/m3)
      ctotaerbox = cnv
      maerbox = 0.

!$OMP PARALLEL DO private(isp) reduction(+:maerbox,ctotaerbox)
      DO isp = 1,nsat
        ctotaerbox = ctotaerbox + cbox(idasat(isp))
        maerbox    = maerbox    + cbox(idasat(isp)) &
                                * multimass*wmol(idasat(isp))
      ENDDO
!$OMP END PARALLEL DO

      IF (dimer_fg.EQ.1) THEN
!$OMP PARALLEL DO private(isp) reduction(+:maerbox,ctotaerbox)
      DO isp = 1,ndim
        ctotaerbox = ctotaerbox + cbox(iddsat(isp))
        maerbox    =    maerbox + cbox(iddsat(isp)) &
                                * multimass*wmol(iddsat(isp))
      ENDDO
!$OMP END PARALLEL DO
      ENDIF ! (dimer_fg)

      !PRINT*,"after dynamic soa update"

! -------------------------------------
      END SUBROUTINE soa_dyn_update
! -------------------------------------

